/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.persistence.PersistentReplicatesOfflineException;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractUpdateOperation;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.QueuedOperation;
import com.gemstone.gemfire.internal.cache.RemotePutAllMessage;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.delta.Delta;
import com.gemstone.gemfire.internal.cache.ha.ThreadIdentifier;
import com.gemstone.gemfire.internal.cache.partitioned.PutAllPRMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.DiskVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class DistributedPutAllOperation
extends AbstractUpdateOperation {
    private static final Logger logger = LogService.getLogger();
    protected final PutAllEntryData[] putAllData;
    public int putAllDataSize;
    protected boolean isBridgeOp = false;
    static final byte USED_FAKE_EVENT_ID = 1;
    static final byte NOTIFY_ONLY = 2;
    static final byte FILTER_ROUTING = 4;
    static final byte VERSION_TAG = 8;
    static final byte POSDUP = 16;
    static final byte PERSISTENT_TAG = 32;
    static final byte HAS_CALLBACKARG = 64;
    static final byte HAS_TAILKEY = -128;
    static final byte IS_CACHED_DESER = 1;
    static final byte IS_OBJECT = 2;

    public DistributedPutAllOperation(CacheEvent event, int size2, boolean isBridgeOp) {
        super(event, ((EntryEventImpl)event).getEventTime(0L));
        this.putAllData = new PutAllEntryData[size2];
        this.putAllDataSize = 0;
        this.isBridgeOp = isBridgeOp;
    }

    public boolean isBridgeOperation() {
        return this.isBridgeOp;
    }

    public PutAllEntryData[] getPutAllEntryData() {
        return this.putAllData;
    }

    public void addEntry(EntryEventImpl ev) {
        this.putAllData[this.putAllDataSize] = new PutAllEntryData(ev);
        ++this.putAllDataSize;
    }

    public void addEntry(EntryEventImpl ev, boolean newCallbackInvoked) {
        this.putAllData[this.putAllDataSize] = new PutAllEntryData(ev);
        this.putAllData[this.putAllDataSize].setCallbacksInvoked(newCallbackInvoked);
        ++this.putAllDataSize;
    }

    public void addEntry(EntryEventImpl ev, Integer bucketId) {
        this.putAllData[this.putAllDataSize] = new PutAllEntryData(ev);
        this.putAllData[this.putAllDataSize].setBucketId(bucketId);
        ++this.putAllDataSize;
    }

    public void setUseFakeEventId(boolean status) {
        for (int i = 0; i < this.putAllDataSize; ++i) {
            this.putAllData[i].setUsedFakeEventId(status);
        }
    }

    public Iterator eventIterator() {
        return new Iterator(){
            int position = 0;

            @Override
            public boolean hasNext() {
                return DistributedPutAllOperation.this.putAllDataSize > this.position;
            }

            public Object next() {
                EntryEventImpl ev = DistributedPutAllOperation.this.getEventForPosition(this.position);
                ++this.position;
                return ev;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public EntryEventImpl getEventForPosition(int position) {
        PutAllEntryData entry = this.putAllData[position];
        if (entry == null) {
            return null;
        }
        if (entry.event != null) {
            return entry.event;
        }
        LocalRegion region = (LocalRegion)this.event.getRegion();
        EntryEventImpl ev = new EntryEventImpl(region, entry.getOp(), entry.getKey(), null, this.event.getCallbackArgument(), false, this.event.getDistributedMember(), this.event.isGenerateCallbacks(), entry.getEventID());
        ev.setPossibleDuplicate(entry.isPossibleDuplicate());
        if (entry.versionTag != null && region.concurrencyChecksEnabled) {
            Object id = entry.versionTag.getMemberID();
            if (id != null) {
                entry.versionTag.setMemberID(ev.getRegion().getVersionVector().getCanonicalId(id));
            }
            ev.setVersionTag(entry.versionTag);
        }
        entry.event = ev;
        if (entry.getValue() == null && ev.getRegion().getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
            ev.setLocalInvalid(true);
        }
        ev.setNewValue(entry.getValue());
        ev.setOldValue(entry.getOldValue());
        if (CqService.isRunning() && !entry.getOp().isCreate() && !ev.hasOldValue()) {
            ev.setOldValueForQueryProcessing();
        }
        ev.setInvokePRCallbacks(!entry.isNotifyOnly());
        if (this.getBaseEvent().getContext() != null) {
            ev.setContext(this.getBaseEvent().getContext());
        }
        ev.callbacksInvoked(entry.isCallbacksInvoked());
        ev.setTailKey(entry.getTailKey());
        return ev;
    }

    public final EntryEventImpl getBaseEvent() {
        return this.getEvent();
    }

    @Override
    protected FilterRoutingInfo getRecipientFilterRouting(Set cacheOpRecipients) {
        LocalRegion region = (LocalRegion)this.event.getRegion();
        CacheDistributionAdvisor advisor = region instanceof PartitionedRegion ? ((PartitionedRegion)region).getCacheDistributionAdvisor() : (region.isUsedForPartitionedRegionBucket() ? ((BucketRegion)region).getPartitionedRegion().getCacheDistributionAdvisor() : ((DistributedRegion)region).getCacheDistributionAdvisor());
        FilterRoutingInfo consolidated = new FilterRoutingInfo();
        for (int i = 0; i < this.putAllData.length; ++i) {
            EntryEventImpl ev = this.getEventForPosition(i);
            if (ev == null) continue;
            FilterRoutingInfo eventRouting = advisor.adviseFilterRouting(ev, cacheOpRecipients);
            if (eventRouting != null) {
                consolidated.addFilterInfo(eventRouting);
            }
            this.putAllData[i].filterRouting = eventRouting;
        }
        return consolidated;
    }

    @Override
    protected FilterRoutingInfo.FilterInfo getLocalFilterRouting(FilterRoutingInfo frInfo) {
        FilterProfile fp = this.getRegion().getFilterProfile();
        if (fp == null) {
            return null;
        }
        if (this.putAllData != null && this.putAllData.length > 0) {
            fp.getLocalFilterRoutingForPutAllOp(this, this.putAllData);
        }
        return null;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        EntryEventImpl event = this.getBaseEvent();
        PutAllMessage msg = new PutAllMessage();
        msg.eventId = event.getEventId();
        msg.context = event.getContext();
        return msg;
    }

    public PutAllPRMessage createPRMessagesNotifyOnly(int bucketId) {
        EntryEventImpl event = this.getBaseEvent();
        PutAllPRMessage prMsg = new PutAllPRMessage(bucketId, this.putAllDataSize, true, event.isPossibleDuplicate(), !event.isGenerateCallbacks(), event.getCallbackArgument());
        if (event.getContext() != null) {
            prMsg.setBridgeContext(event.getContext());
        }
        for (int i = 0; i < this.putAllDataSize; ++i) {
            prMsg.addEntry(this.putAllData[i]);
        }
        return prMsg;
    }

    public HashMap createPRMessages() {
        HashMap<Integer, PutAllPRMessage> prMsgMap = new HashMap<Integer, PutAllPRMessage>();
        EntryEventImpl event = this.getBaseEvent();
        for (int i = 0; i < this.putAllDataSize; ++i) {
            Integer bucketId = this.putAllData[i].bucketId;
            PutAllPRMessage prMsg = (PutAllPRMessage)prMsgMap.get(bucketId);
            if (prMsg == null) {
                prMsg = new PutAllPRMessage(bucketId, this.putAllDataSize, false, event.isPossibleDuplicate(), !event.isGenerateCallbacks(), event.getCallbackArgument());
                if (event.getContext() != null) {
                    prMsg.setBridgeContext(event.getContext());
                }
            }
            this.putAllData[i].setFakeEventID();
            prMsg.addEntry(this.putAllData[i]);
            prMsgMap.put(bucketId, prMsg);
        }
        return prMsgMap;
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor proc) {
        super.initMessage(msg, proc);
        PutAllMessage m = (PutAllMessage)msg;
        RegionAttributes attr = this.event.getRegion().getAttributes();
        if (attr.getConcurrencyChecksEnabled() && !attr.getDataPolicy().withReplication() && attr.getScope() != Scope.GLOBAL) {
            if (attr.getDataPolicy() == DataPolicy.EMPTY) {
                boolean success = RemotePutAllMessage.distribute((EntryEventImpl)this.event, this.putAllData, this.putAllDataSize);
                if (success) {
                    m.callbackArg = this.event.getCallbackArgument();
                    m.putAllData = new PutAllEntryData[0];
                    m.putAllDataSize = 0;
                    m.skipCallbacks = !this.event.isGenerateCallbacks();
                    return;
                }
                if (!this.getRegion().getGenerateVersionTag()) {
                    throw new PersistentReplicatesOfflineException();
                }
            } else {
                Object[] versionless = this.selectVersionlessEntries();
                if (logger.isTraceEnabled()) {
                    logger.trace("Found these versionless entries: {}", Arrays.toString(versionless));
                }
                if (versionless.length > 0) {
                    boolean success = RemotePutAllMessage.distribute((EntryEventImpl)this.event, (PutAllEntryData[])versionless, versionless.length);
                    if (success) {
                        versionless = null;
                        Object[] versioned = this.selectVersionedEntries();
                        if (logger.isTraceEnabled()) {
                            logger.trace("Found these remaining versioned entries: {}", Arrays.toString(versioned));
                        }
                        m.callbackArg = this.event.getCallbackArgument();
                        m.putAllData = versioned;
                        m.putAllDataSize = versioned.length;
                        m.skipCallbacks = !this.event.isGenerateCallbacks();
                        return;
                    }
                    if (!this.getRegion().getGenerateVersionTag()) {
                        throw new PersistentReplicatesOfflineException();
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("All entries have versions, so using normal DPAO message");
                }
            }
        }
        m.callbackArg = this.event.getCallbackArgument();
        m.putAllData = this.putAllData;
        m.putAllDataSize = this.putAllDataSize;
        m.skipCallbacks = !this.event.isGenerateCallbacks();
    }

    @Override
    protected boolean shouldAck() {
        return super.shouldAck() || this.getRegion().concurrencyChecksEnabled;
    }

    private PutAllEntryData[] selectVersionlessEntries() {
        int resultSize = this.putAllData.length;
        for (int i = 0; i < this.putAllData.length; ++i) {
            PutAllEntryData p = this.putAllData[i];
            if (p == null || p.isInhibitDistribution()) {
                --resultSize;
                continue;
            }
            if (p.versionTag == null || !p.versionTag.hasValidVersion()) continue;
            --resultSize;
        }
        PutAllEntryData[] result = new PutAllEntryData[resultSize];
        int ri = 0;
        for (int i = 0; i < this.putAllData.length; ++i) {
            PutAllEntryData p = this.putAllData[i];
            if (p == null || p.isInhibitDistribution() || p.versionTag != null && p.versionTag.hasValidVersion()) continue;
            result[ri++] = p;
        }
        return result;
    }

    private PutAllEntryData[] selectVersionedEntries() {
        int resultSize = 0;
        for (int i = 0; i < this.putAllData.length; ++i) {
            PutAllEntryData p = this.putAllData[i];
            if (p == null || p.isInhibitDistribution() || p.versionTag == null || !p.versionTag.hasValidVersion()) continue;
            ++resultSize;
        }
        PutAllEntryData[] result = new PutAllEntryData[resultSize];
        int ri = 0;
        for (int i = 0; i < this.putAllData.length; ++i) {
            PutAllEntryData p = this.putAllData[i];
            if (p == null || p.isInhibitDistribution() || p.versionTag == null || !p.versionTag.hasValidVersion()) continue;
            result[ri++] = p;
        }
        return result;
    }

    protected void fillVersionedObjectList(VersionedObjectList list) {
        for (PutAllEntryData entry : this.putAllData) {
            if (entry.versionTag == null) continue;
            list.addKeyAndVersion(entry.key, entry.versionTag);
        }
    }

    public static class PutAllMessage
    extends AbstractUpdateOperation.AbstractUpdateMessage {
        protected PutAllEntryData[] putAllData;
        protected int putAllDataSize;
        protected transient ClientProxyMembershipID context;
        protected boolean skipCallbacks;
        protected EventID eventId = null;
        protected static final short HAS_BRIDGE_CONTEXT = 16384;
        protected static final short SKIP_CALLBACKS = Short.MIN_VALUE;

        public boolean isEmpty() {
            return this.putAllData.length == 0;
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl event = new EntryEventImpl((LocalRegion)rgn, Operation.PUTALL_UPDATE, null, null, this.callbackArg, true, this.getSender());
            if (this.context != null) {
                event.context = this.context;
            }
            event.setPossibleDuplicate(this.possibleDuplicate);
            event.setEventId(this.eventId);
            return event;
        }

        @Override
        public void appendFields(StringBuilder sb) {
            super.appendFields(sb);
            if (this.eventId != null) {
                sb.append("; eventId=").append(this.eventId);
            }
            sb.append("; entries=").append(this.putAllDataSize);
            if (this.putAllDataSize <= 20) {
                sb.append("; entry values=").append(Arrays.toString(this.putAllData));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEntryPut(PutAllEntryData entry, DistributedRegion rgn, boolean requiresRegionContext) {
            EntryEventImpl ev = PutAllMessage.createEntryEvent(entry, this.getSender(), this.context, rgn, requiresRegionContext, this.possibleDuplicate, this.needsRouting, this.callbackArg, true, this.skipCallbacks);
            try {
                super.basicOperateOnRegion(ev, rgn);
            }
            finally {
                if (ev.getVersionTag() != null && !ev.getVersionTag().isRecorded() && rgn.getVersionVector() != null) {
                    rgn.getVersionVector().recordVersion(this.getSender(), ev.getVersionTag());
                }
            }
        }

        public static EntryEventImpl createEntryEvent(PutAllEntryData entry, InternalDistributedMember sender, ClientProxyMembershipID context, DistributedRegion rgn, boolean requiresRegionContext, boolean possibleDuplicate, boolean needsRouting, Object callbackArg, boolean originRemote, boolean skipCallbacks) {
            Object key2 = entry.getKey();
            if (requiresRegionContext) {
                ((KeyWithRegionContext)key2).setRegionContext(rgn);
            }
            EventID evId = entry.getEventID();
            EntryEventImpl ev = new EntryEventImpl((LocalRegion)rgn, entry.getOp(), key2, null, callbackArg, originRemote, (DistributedMember)sender, !skipCallbacks, evId);
            if (context != null) {
                ev.context = context;
            }
            if (entry.getValue() == null && rgn.getDataPolicy() == DataPolicy.NORMAL) {
                ev.setLocalInvalid(true);
            }
            ev.setNewValue(entry.getValue());
            ev.setPossibleDuplicate(possibleDuplicate);
            ev.setVersionTag(entry.versionTag);
            if (entry.filterRouting != null) {
                InternalDistributedMember id = rgn.getMyId();
                ev.setLocalFilterInfo(entry.filterRouting.getFilterInfo(id));
            }
            ev.setTailKey(entry.getTailKey());
            return ev;
        }

        @Override
        protected void basicOperateOnRegion(EntryEventImpl ev, final DistributedRegion rgn) {
            for (int i = 0; i < this.putAllDataSize; ++i) {
                if (this.putAllData[i].versionTag == null) continue;
                this.checkVersionTag(rgn, this.putAllData[i].versionTag);
            }
            rgn.syncBulkOp(new Runnable(){

                @Override
                public void run() {
                    boolean requiresRegionContext = rgn.keyRequiresRegionContext();
                    boolean isDebugEnabled = logger.isDebugEnabled();
                    for (int i = 0; i < PutAllMessage.this.putAllDataSize; ++i) {
                        if (isDebugEnabled) {
                            logger.debug("putAll processing {} with {} sender={}", PutAllMessage.this.putAllData[i], PutAllMessage.this.putAllData[i].versionTag, PutAllMessage.this.sender);
                        }
                        PutAllMessage.this.putAllData[i].setSender(PutAllMessage.this.sender);
                        PutAllMessage.this.doEntryPut(PutAllMessage.this.putAllData[i], rgn, requiresRegionContext);
                    }
                }
            }, ev.getEventId());
        }

        @Override
        public int getDSFID() {
            return -84;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.putAllDataSize = (int)InternalDataSerializer.readUnsignedVL(in);
            this.putAllData = new PutAllEntryData[this.putAllDataSize];
            if (this.putAllDataSize > 0) {
                Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
                ByteArrayDataInput bytesIn = new ByteArrayDataInput();
                for (int i = 0; i < this.putAllDataSize; ++i) {
                    this.putAllData[i] = new PutAllEntryData(in, this.eventId, i, version, bytesIn);
                }
                boolean hasTags = in.readBoolean();
                if (hasTags) {
                    EntryVersionsList versionTags = EntryVersionsList.create(in);
                    for (int i = 0; i < this.putAllDataSize; ++i) {
                        this.putAllData[i].versionTag = (VersionTag)versionTags.get(i);
                    }
                }
            }
            if ((this.flags & 0x4000) != 0) {
                this.context = (ClientProxyMembershipID)DataSerializer.readObject(in);
            }
            this.skipCallbacks = (this.flags & Short.MIN_VALUE) != 0;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventId, out);
            InternalDataSerializer.writeUnsignedVL(this.putAllDataSize, out);
            if (this.putAllDataSize > 0) {
                EntryVersionsList versionTags = new EntryVersionsList(this.putAllDataSize);
                boolean hasTags = false;
                boolean requiresRegionContext = this.putAllData[0].key instanceof KeyWithRegionContext;
                for (int i = 0; i < this.putAllDataSize; ++i) {
                    if (!hasTags && this.putAllData[i].versionTag != null) {
                        hasTags = true;
                    }
                    VersionTag tag = this.putAllData[i].versionTag;
                    versionTags.add(tag);
                    this.putAllData[i].versionTag = null;
                    this.putAllData[i].toData(out, requiresRegionContext);
                    this.putAllData[i].versionTag = tag;
                }
                out.writeBoolean(hasTags);
                if (hasTags) {
                    InternalDataSerializer.invokeToData(versionTags, out);
                }
            }
            if (this.context != null) {
                DataSerializer.writeObject(this.context, out);
            }
        }

        @Override
        protected short computeCompressedShort(short s) {
            s = super.computeCompressedShort(s);
            if (this.context != null) {
                s = (short)(s | 0x4000);
            }
            if (this.skipCallbacks) {
                s = (short)(s | Short.MIN_VALUE);
            }
            return s;
        }

        @Override
        public int getOperationCount() {
            return this.putAllDataSize;
        }

        public ClientProxyMembershipID getContext() {
            return this.context;
        }

        public PutAllEntryData[] getPutAllEntryData() {
            return this.putAllData;
        }

        @Override
        public List getOperations() {
            QueuedOperation[] ops = new QueuedOperation[this.getOperationCount()];
            for (int i = 0; i < ops.length; ++i) {
                byte deserializationPolicy;
                PutAllEntryData entry = this.putAllData[i];
                byte[] valueBytes = null;
                Object valueObj = null;
                Object v = entry.getValue();
                if (v instanceof Delta) {
                    deserializationPolicy = 1;
                    valueObj = v;
                } else if (v instanceof CachedDeserializable) {
                    deserializationPolicy = 2;
                    valueBytes = ((CachedDeserializable)v).getSerializedValue();
                } else {
                    deserializationPolicy = 0;
                    valueBytes = (byte[])v;
                }
                ops[i] = new QueuedOperation(entry.getOp(), entry.getKey(), valueBytes, valueObj, deserializationPolicy, this.callbackArg);
            }
            return Arrays.asList(ops);
        }
    }

    public static final class EntryVersionsList
    extends ArrayList<VersionTag>
    implements DataSerializableFixedID,
    Externalizable {
        static final byte FLAG_NULL_TAG = 0;
        static final byte FLAG_FULL_TAG = 1;
        static final byte FLAG_TAG_WITH_NEW_ID = 2;
        static final byte FLAG_TAG_WITH_NUMBER_ID = 3;

        public EntryVersionsList() {
        }

        public EntryVersionsList(int size2) {
            super(size2);
        }

        public static EntryVersionsList create(DataInput in) throws IOException, ClassNotFoundException {
            EntryVersionsList newList = new EntryVersionsList();
            InternalDataSerializer.invokeFromData(newList, in);
            return newList;
        }

        private boolean extractVersion(PutAllEntryData entry) {
            VersionTag versionTag = entry.versionTag;
            if (versionTag != null) {
                this.add(versionTag);
                entry.versionTag = null;
                return true;
            }
            return false;
        }

        private VersionTag<VersionSource> getVersionTag(int index2) {
            VersionTag tag = null;
            if (this.size() > 0) {
                tag = (VersionTag)this.get(index2);
            }
            return tag;
        }

        public void replaceNullIDs(DistributedMember sender) {
            for (VersionTag versionTag : this) {
                if (versionTag == null) continue;
                versionTag.replaceNullIDs((InternalDistributedMember)sender);
            }
        }

        @Override
        public int getDSFID() {
            return 3;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            int flags = 0;
            boolean hasTags = false;
            if (this.size() > 0) {
                flags |= 4;
                hasTags = true;
                for (VersionTag tag : this) {
                    if (tag == null) continue;
                    if (!(tag instanceof DiskVersionTag)) break;
                    flags |= 0x20;
                    break;
                }
            }
            if (logger.isTraceEnabled(LogMarker.GII_VERSIONED_ENTRY)) {
                logger.trace(LogMarker.GII_VERSIONED_ENTRY, "serializing {} with flags 0x{}", this, Integer.toHexString(flags));
            }
            out.writeByte(flags);
            if (hasTags) {
                InternalDataSerializer.writeUnsignedVL(this.size(), out);
                TObjectIntHashMap ids = new TObjectIntHashMap(this.size());
                int idCount = 0;
                for (VersionTag tag : this) {
                    if (tag == null) {
                        out.writeByte(0);
                        continue;
                    }
                    Object id = tag.getMemberID();
                    if (id == null) {
                        out.writeByte(1);
                        InternalDataSerializer.invokeToData(tag, out);
                        continue;
                    }
                    int idNumber = ids.get(id);
                    if (idNumber == 0) {
                        out.writeByte(2);
                        idNumber = ++idCount;
                        ids.put(id, idNumber);
                        InternalDataSerializer.invokeToData(tag, out);
                        continue;
                    }
                    out.writeByte(3);
                    tag.toData(out, false);
                    tag.setMemberID(id);
                    InternalDataSerializer.writeUnsignedVL(idNumber - 1, out);
                }
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            boolean persistent;
            byte flags = in.readByte();
            boolean hasTags = (flags & 4) == 4;
            boolean bl = persistent = (flags & 0x20) == 32;
            if (logger.isTraceEnabled(LogMarker.GII_VERSIONED_ENTRY)) {
                logger.debug("deserializing a InitialImageVersionedObjectList with flags 0x{}", Integer.toHexString(flags));
            }
            if (hasTags) {
                int size2 = (int)InternalDataSerializer.readUnsignedVL(in);
                if (logger.isTraceEnabled(LogMarker.GII_VERSIONED_ENTRY)) {
                    logger.trace(LogMarker.GII_VERSIONED_ENTRY, "reading {} version tags", size2);
                }
                ArrayList ids = new ArrayList(size2);
                block6: for (int i = 0; i < size2; ++i) {
                    byte entryType = in.readByte();
                    switch (entryType) {
                        case 0: {
                            this.add(null);
                            continue block6;
                        }
                        case 1: {
                            this.add(VersionTag.create(persistent, in));
                            continue block6;
                        }
                        case 2: {
                            VersionTag tag = VersionTag.create(persistent, in);
                            ids.add(tag.getMemberID());
                            this.add(tag);
                            continue block6;
                        }
                        case 3: {
                            VersionTag tag = VersionTag.create(persistent, in);
                            int idNumber = (int)InternalDataSerializer.readUnsignedVL(in);
                            tag.setMemberID((VersionSource)ids.get(idNumber));
                            this.add(tag);
                        }
                    }
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.toData(out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        @Override
        public Version[] getSerializationVersions() {
            return null;
        }
    }

    public static final class PutAllEntryData {
        final Object key;
        final Object value;
        private final Object oldValue;
        private final Operation op;
        private EventID eventID;
        transient EntryEventImpl event;
        private Integer bucketId = -1;
        protected transient boolean callbacksInvoked = false;
        public FilterRoutingInfo filterRouting;
        protected byte flags = 0;
        private Long tailKey = 0L;
        public VersionTag versionTag;
        transient boolean inhibitDistribution;

        public PutAllEntryData(EntryEventImpl event) {
            this.key = event.getKey();
            this.value = event.getRawNewValue();
            Object oldValue = event.getRawOldValue();
            this.oldValue = oldValue == Token.NOT_AVAILABLE || Token.isRemoved(oldValue) ? null : oldValue;
            this.op = event.getOperation();
            this.eventID = event.getEventId();
            this.tailKey = event.getTailKey();
            this.versionTag = event.getVersionTag();
            this.setNotifyOnly(!event.getInvokePRCallbacks());
            this.setCallbacksInvoked(event.callbacksInvoked());
            this.setPossibleDuplicate(event.isPossibleDuplicate());
            this.setInhibitDistribution(event.getInhibitDistribution());
        }

        public PutAllEntryData(DataInput in, EventID baseEventID, int idx, Version version, ByteArrayDataInput bytesIn) throws IOException, ClassNotFoundException {
            this.key = DataSerializer.readObject(in);
            byte flgs = in.readByte();
            if ((flgs & 2) != 0) {
                this.value = DataSerializer.readObject(in);
            } else {
                byte[] bb = DataSerializer.readByteArray(in);
                this.value = (flgs & 1) != 0 ? CachedDeserializableFactory.create(bb) : (Object)bb;
            }
            this.oldValue = null;
            this.op = Operation.fromOrdinal(in.readByte());
            this.flags = in.readByte();
            if ((this.flags & 4) != 0) {
                this.filterRouting = (FilterRoutingInfo)DataSerializer.readObject(in);
            }
            if ((this.flags & 8) != 0) {
                boolean persistentTag = (this.flags & 0x20) != 0;
                this.versionTag = VersionTag.create(persistentTag, in);
            }
            if (this.isUsedFakeEventId()) {
                this.eventID = new EventID();
                InternalDataSerializer.invokeFromData(this.eventID, in);
            } else {
                this.eventID = new EventID(baseEventID, idx);
            }
            if ((this.flags & 0xFFFFFF80) != 0) {
                this.tailKey = DataSerializer.readLong(in);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("(").append(this.getKey()).append(",").append(this.getValue()).append(",").append(this.getOldValue());
            if (this.bucketId > 0) {
                sb.append(", b").append(this.bucketId);
            }
            if (this.versionTag != null) {
                sb.append(this.versionTag);
            }
            if (this.filterRouting != null) {
                sb.append(", ").append(this.filterRouting);
            }
            sb.append(")");
            return sb.toString();
        }

        void setSender(InternalDistributedMember sender) {
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(sender);
            }
        }

        public final void toData(DataOutput out, boolean requiresRegionContext) throws IOException {
            Object key2 = this.key;
            Object v = this.value;
            DataSerializer.writeObject(key2, out);
            if (v instanceof byte[] || v == null) {
                out.writeByte(0);
                DataSerializer.writeByteArray((byte[])v, out);
            } else if (v instanceof CachedDeserializable) {
                CachedDeserializable cd2 = (CachedDeserializable)v;
                out.writeByte(1);
                DataSerializer.writeByteArray(cd2.getSerializedValue(), out);
            } else {
                out.writeByte(1);
                DataSerializer.writeObjectAsByteArray(v, out);
            }
            out.writeByte(this.op.ordinal);
            byte bits = this.flags;
            if (this.filterRouting != null) {
                bits = (byte)(bits | 4);
            }
            if (this.versionTag != null) {
                bits = (byte)(bits | 8);
                if (this.versionTag instanceof DiskVersionTag) {
                    bits = (byte)(bits | 0x20);
                }
            }
            bits = (byte)(bits | 0xFFFFFF80);
            out.writeByte(bits);
            if (this.filterRouting != null) {
                DataSerializer.writeObject(this.filterRouting, out);
            }
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
            if (this.isUsedFakeEventId()) {
                InternalDataSerializer.invokeToData(this.eventID, out);
            }
            DataSerializer.writeLong(this.tailKey, out);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Long getTailKey() {
            return this.tailKey;
        }

        public void setTailKey(Long key2) {
            this.tailKey = key2;
        }

        public Operation getOp() {
            return this.op;
        }

        public EventID getEventID() {
            return this.eventID;
        }

        public void setEventId(EventID eventId) {
            this.eventID = eventId;
        }

        public void setBucketId(Integer bucketId) {
            this.bucketId = bucketId;
        }

        public Integer getBucketId() {
            return this.bucketId;
        }

        public boolean setFakeEventID() {
            if (this.bucketId < 0) {
                return false;
            }
            if (!this.isUsedFakeEventId()) {
                long threadId = ThreadIdentifier.createFakeThreadIDForBulkOp(this.bucketId, this.eventID.getThreadID());
                this.eventID = new EventID(this.eventID.getMembershipID(), threadId, this.eventID.getSequenceID());
                this.setUsedFakeEventId(true);
            }
            return true;
        }

        public boolean isUsedFakeEventId() {
            return (this.flags & 1) != 0;
        }

        public void setUsedFakeEventId(boolean usedFakeEventId) {
            this.flags = usedFakeEventId ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
        }

        public boolean isNotifyOnly() {
            return (this.flags & 2) != 0;
        }

        public void setNotifyOnly(boolean notifyOnly) {
            this.flags = notifyOnly ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        }

        boolean isPossibleDuplicate() {
            return (this.flags & 0x10) != 0;
        }

        public void setPossibleDuplicate(boolean possibleDuplicate) {
            this.flags = possibleDuplicate ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        }

        public boolean isInhibitDistribution() {
            return this.inhibitDistribution;
        }

        public void setInhibitDistribution(boolean inhibitDistribution) {
            this.inhibitDistribution = inhibitDistribution;
        }

        public boolean isCallbacksInvoked() {
            return this.callbacksInvoked;
        }

        public void setCallbacksInvoked(boolean callbacksInvoked) {
            this.callbacksInvoked = callbacksInvoked;
        }
    }
}

