/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.internal.cache.DiskStoreAttributes;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.persistence.BackupManager;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.DiskStoreAttributesCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.File;
import java.util.Arrays;

public class DiskStoreFactoryImpl
implements DiskStoreFactory {
    private final Cache cache;
    private final DiskStoreAttributes attrs = new DiskStoreAttributes();

    public DiskStoreFactoryImpl(Cache cache) {
        this.cache = cache;
    }

    public DiskStoreFactoryImpl(Cache cache, DiskStoreAttributes attrs) {
        this.attrs.name = attrs.name;
        this.setAutoCompact(attrs.getAutoCompact());
        this.setAllowForceCompaction(attrs.getAllowForceCompaction());
        this.setCompactionThreshold(attrs.getCompactionThreshold());
        this.setMaxOplogSizeInBytes(attrs.getMaxOplogSizeInBytes());
        this.setTimeInterval(attrs.getTimeInterval());
        this.setWriteBufferSize(attrs.getWriteBufferSize());
        this.setQueueSize(attrs.getQueueSize());
        this.setDiskDirs(DiskStoreFactoryImpl.cloneArray(attrs.getDiskDirs()));
        this.setDiskDirsAndSizes(DiskStoreFactoryImpl.cloneArray(attrs.getDiskDirs()), DiskStoreFactoryImpl.cloneArray(attrs.getDiskDirSizes()));
        this.setDiskUsageWarningPercentage(attrs.getDiskUsageWarningPercentage());
        this.setDiskUsageCriticalPercentage(attrs.getDiskUsageCriticalPercentage());
        this.cache = cache;
    }

    private static File[] cloneArray(File[] o) {
        File[] result = null;
        if (o != null) {
            result = new File[o.length];
            System.arraycopy(o, 0, result, 0, o.length);
        }
        return result;
    }

    private static int[] cloneArray(int[] o) {
        int[] result = null;
        if (o != null) {
            result = new int[o.length];
            System.arraycopy(o, 0, result, 0, o.length);
        }
        return result;
    }

    @Override
    public DiskStoreFactory setAutoCompact(boolean autoCompact) {
        this.attrs.autoCompact = autoCompact;
        return this;
    }

    @Override
    public DiskStoreFactory setAllowForceCompaction(boolean allowForceCompaction) {
        this.attrs.allowForceCompaction = allowForceCompaction;
        return this;
    }

    @Override
    public DiskStoreFactory setCompactionThreshold(int compactionThreshold) {
        if (compactionThreshold < 0) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_POSITIVE_NUMBER_AND_THE_VALUE_GIVEN_1_IS_NOT_ACCEPTABLE.toLocalizedString("compaction-threshold", compactionThreshold));
        }
        if (compactionThreshold > 100) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_LESS_THAN_2_BUT_WAS_1.toLocalizedString("compaction-threshold", compactionThreshold, 100));
        }
        this.attrs.compactionThreshold = compactionThreshold;
        return this;
    }

    @Override
    public DiskStoreFactory setTimeInterval(long timeInterval) {
        if (timeInterval < 0L) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_TIME_INTERVAL_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(timeInterval));
        }
        this.attrs.timeInterval = timeInterval;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStoreImpl createOwnedByRegion(String name, boolean isOwnedByPR, InternalRegionArguments internalRegionArgs) {
        this.attrs.name = name;
        Cache cache = this.cache;
        synchronized (cache) {
            assert (this.cache instanceof GemFireCacheImpl);
            GemFireCacheImpl gfc = (GemFireCacheImpl)this.cache;
            DiskStoreImpl ds = new DiskStoreImpl(gfc, this.attrs, true, internalRegionArgs);
            if (isOwnedByPR) {
                ds.doInitialRecovery();
            }
            gfc.addRegionOwnedDiskStore(ds);
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskStore create(String name) {
        GemFireCacheImpl gfc;
        BackupManager backup;
        DiskStore result;
        this.attrs.name = name;
        Cache cache = this.cache;
        synchronized (cache) {
            result = this.findExisting(name);
            if (result == null) {
                if (this.cache instanceof GemFireCacheImpl) {
                    GemFireCacheImpl gfc2 = (GemFireCacheImpl)this.cache;
                    TypeRegistry registry = gfc2.getPdxRegistry();
                    DiskStoreImpl dsi = new DiskStoreImpl(gfc2, this.attrs);
                    result = dsi;
                    gfc2.getDistributedSystem().handleResourceEvent(ResourceEvent.DISKSTORE_CREATE, dsi);
                    dsi.doInitialRecovery();
                    gfc2.addDiskStore(dsi);
                    if (registry != null) {
                        registry.creatingDiskStore(dsi);
                    }
                } else if (this.cache instanceof CacheCreation) {
                    CacheCreation creation = (CacheCreation)this.cache;
                    result = new DiskStoreAttributesCreation(this.attrs);
                    creation.addDiskStore(result);
                }
            }
        }
        if (this.cache instanceof GemFireCacheImpl && (backup = (gfc = (GemFireCacheImpl)this.cache).getBackupManager()) != null) {
            backup.waitForBackup();
        }
        return result;
    }

    private DiskStore findExisting(String name) {
        GemFireCacheImpl gfc;
        DiskStore existing = null;
        if (this.cache instanceof GemFireCacheImpl && (existing = (gfc = (GemFireCacheImpl)this.cache).findDiskStore(name)) != null) {
            if (((DiskStoreImpl)existing).sameAs(this.attrs)) {
                return existing;
            }
            throw new IllegalStateException("DiskStore named \"" + name + "\" already exists");
        }
        return existing;
    }

    @Override
    public DiskStoreFactory setDiskDirsAndSizes(File[] diskDirs, int[] diskDirSizes) {
        if (diskDirSizes.length != diskDirs.length) {
            throw new IllegalArgumentException(LocalizedStrings.AttributesFactory_NUMBER_OF_DISKSIZES_IS_0_WHICH_IS_NOT_EQUAL_TO_NUMBER_OF_DISK_DIRS_WHICH_IS_1.toLocalizedString(diskDirSizes.length, diskDirs.length));
        }
        DiskStoreFactoryImpl.verifyNonNegativeDirSize(diskDirSizes);
        DiskStoreFactoryImpl.checkIfDirectoriesExist(diskDirs);
        this.attrs.diskDirs = new File[diskDirs.length];
        System.arraycopy(diskDirs, 0, this.attrs.diskDirs, 0, diskDirs.length);
        this.attrs.diskDirSizes = new int[diskDirSizes.length];
        System.arraycopy(diskDirSizes, 0, this.attrs.diskDirSizes, 0, diskDirSizes.length);
        return this;
    }

    public static void checkIfDirectoriesExist(File[] diskDirs) {
        for (int i = 0; i < diskDirs.length; ++i) {
            if (diskDirs[i].isDirectory() || diskDirs[i].mkdirs()) continue;
            throw new GemFireIOException(LocalizedStrings.AttributesFactory_UNABLE_TO_CREATE_DISK_STORE_DIRECTORY_0.toLocalizedString(diskDirs[i]));
        }
    }

    public static void verifyNonNegativeDirSize(int[] sizes) {
        for (int i = 0; i < sizes.length; ++i) {
            if (sizes[i] >= 0) continue;
            throw new IllegalArgumentException(LocalizedStrings.AttributesFactory_DIR_SIZE_CANNOT_BE_NEGATIVE_0.toLocalizedString(sizes[i]));
        }
    }

    @Override
    public DiskStoreFactory setDiskDirs(File[] diskDirs) {
        DiskStoreFactoryImpl.checkIfDirectoriesExist(diskDirs);
        int[] diskSizes = new int[diskDirs.length];
        Arrays.fill(diskSizes, Integer.MAX_VALUE);
        return this.setDiskDirsAndSizes(diskDirs, diskSizes);
    }

    @Override
    public DiskStoreFactory setMaxOplogSize(long maxOplogSize) {
        long MAX = 0x7FFFFFFFFFFL;
        if (maxOplogSize > MAX) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_LESS_THAN_2_BUT_WAS_1.toLocalizedString("max oplog size", maxOplogSize, MAX));
        }
        if (maxOplogSize < 0L) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_MAXIMUM_OPLOG_SIZE_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(maxOplogSize));
        }
        this.attrs.maxOplogSizeInBytes = maxOplogSize * 0x100000L;
        return this;
    }

    public DiskStoreFactory setMaxOplogSizeInBytes(long maxOplogSizeInBytes) {
        if (maxOplogSizeInBytes < 0L) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_MAXIMUM_OPLOG_SIZE_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(maxOplogSizeInBytes));
        }
        this.attrs.maxOplogSizeInBytes = maxOplogSizeInBytes;
        return this;
    }

    @Override
    public DiskStoreFactory setQueueSize(int queueSize) {
        if (queueSize < 0) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_QUEUE_SIZE_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(queueSize));
        }
        this.attrs.queueSize = queueSize;
        return this;
    }

    @Override
    public DiskStoreFactory setWriteBufferSize(int writeBufferSize) {
        if (writeBufferSize < 0) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_QUEUE_SIZE_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(writeBufferSize));
        }
        this.attrs.writeBufferSize = writeBufferSize;
        return this;
    }

    public DiskStoreAttributes getDiskStoreAttributes() {
        return this.attrs;
    }

    @Override
    public DiskStoreFactory setDiskUsageWarningPercentage(float warningPercent) {
        this.attrs.setDiskUsageWarningPercentage(warningPercent);
        return this;
    }

    @Override
    public DiskStoreFactory setDiskUsageCriticalPercentage(float criticalPercent) {
        this.attrs.setDiskUsageCriticalPercentage(criticalPercent);
        return this;
    }
}

