/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BridgeRegionEventImpl;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.Logger;

public class DestroyRegionOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();
    private final boolean notifyOfRegionDeparture;
    private static final ThreadLocal regionDepartureNotificationDisabled = new ThreadLocal();

    @Override
    public boolean supportsDirectAck() {
        return false;
    }

    @Override
    protected boolean supportsAdjunctMessaging() {
        return false;
    }

    @Override
    public boolean canBeSentDuringShutdown() {
        return true;
    }

    public static boolean isRegionDepartureNotificationOk() {
        return regionDepartureNotificationDisabled.get() != Boolean.TRUE;
    }

    public DestroyRegionOperation(RegionEventImpl event, boolean notifyOfRegionDeparture) {
        super(event);
        this.notifyOfRegionDeparture = notifyOfRegionDeparture;
    }

    @Override
    protected Set getRecipients() {
        CacheDistributionAdvisor advisor = this.getRegion().getCacheDistributionAdvisor();
        return advisor.adviseDestroyRegion();
    }

    @Override
    protected boolean shouldAck() {
        return true;
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        DestroyRegionMessage mssg;
        if (this.event instanceof BridgeRegionEventImpl) {
            mssg = new DestroyRegionWithContextMessage();
            mssg.context = ((BridgeRegionEventImpl)this.event).getContext();
        } else {
            mssg = new DestroyRegionMessage();
        }
        mssg.notifyOfRegionDeparture = this.notifyOfRegionDeparture;
        DistributedRegion rgn = this.getRegion();
        mssg.serialNum = rgn.getSerialNumber();
        Assert.assertTrue(mssg.serialNum != -1);
        mssg.subregionSerialNumbers = rgn.getDestroyedSubregionSerialNumbers();
        RegionEventImpl rei = (RegionEventImpl)this.event;
        mssg.eventID = rei.getEventId();
        return mssg;
    }

    public static final class DestroyRegionWithContextMessage
    extends DestroyRegionMessage {
        protected transient Object context;

        @Override
        public final RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            BridgeRegionEventImpl event = new BridgeRegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, (DistributedMember)this.getSender(), (ClientProxyMembershipID)this.context);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; context=").append(this.context);
        }

        @Override
        public int getDSFID() {
            return -85;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.context = DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class DestroyRegionMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected EventID eventID;
        protected int serialNum;
        protected HashMap subregionSerialNumbers;
        protected boolean notifyOfRegionDeparture;
        protected transient LocalRegion lockRoot = null;

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            RegionEventImpl event = this.createRegionEvent(rgn);
            if (this.filterRouting != null) {
                event.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
            }
            event.setEventID(this.eventID);
            return event;
        }

        protected RegionEventImpl createRegionEvent(DistributedRegion rgn) {
            RegionEventImpl event = new RegionEventImpl(rgn, this.getOperation(), this.callbackArg, true, this.getSender());
            return event;
        }

        private Runnable destroyOp(final DistributionManager dm, final LocalRegion lclRgn, final boolean sendReply) {
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
                    Throwable thr = null;
                    try {
                        if (lclRgn == null) {
                            Bucket advisee;
                            block34: {
                                boolean waitForBucketInitializationToComplete = true;
                                advisee = null;
                                try {
                                    advisee = PartitionedRegionHelper.getProxyBucketRegion(GemFireCacheImpl.getInstance(), DestroyRegionMessage.this.regionPath, waitForBucketInitializationToComplete);
                                }
                                catch (PRLocallyDestroyedException e) {
                                }
                                catch (RegionDestroyedException e) {
                                }
                                catch (PartitionedRegionException e) {
                                    if (e.getMessage().indexOf("destroyed") != -1) break block34;
                                    throw e;
                                }
                            }
                            if (advisee != null) {
                                boolean isDestroy = DestroyRegionMessage.this.op.isRegionDestroy() && !DestroyRegionMessage.this.op.isClose();
                                advisee.getDistributionAdvisor().removeIdWithSerial(DestroyRegionMessage.this.getSender(), DestroyRegionMessage.this.serialNum, isDestroy);
                            } else if (logger.isDebugEnabled()) {
                                logger.debug("{} region not found, nothing to do", this);
                            }
                            return;
                        }
                        LocalRegion lr = DestroyRegionMessage.this.getRegionFromPath(dm.getSystem(), lclRgn.getFullPath());
                        if (lr == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("{} region not found, nothing to do", this);
                            }
                            return;
                        }
                        if (!(lr instanceof DistributedRegion)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("{} local scope region, nothing to do", this);
                            }
                            return;
                        }
                        DistributedRegion rgn = (DistributedRegion)lr;
                        InternalCacheEvent event = DestroyRegionMessage.this.createEvent(rgn);
                        if (DestroyRegionMessage.this.needsRouting && lclRgn.cache.getCacheServers().size() > 0) {
                            lclRgn.generateLocalFilterRouting(event);
                        }
                        DestroyRegionMessage.this.doRegionDestroy(event);
                    }
                    catch (RegionDestroyedException e) {
                        logger.debug("{} Region destroyed: nothing to do", this);
                    }
                    catch (CancelException e) {
                        logger.debug("{} Cancelled: nothing to do", this);
                    }
                    catch (EntryNotFoundException e) {
                        logger.debug("{} Entry not found, nothing to do", this);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        thr = t;
                    }
                    finally {
                        LocalRegion.setThreadInitLevelRequirement(oldLevel);
                        if (DestroyRegionMessage.this.lockRoot != null) {
                            DestroyRegionMessage.this.lockRoot.releaseDestroyLock();
                        }
                        if (sendReply) {
                            if (DestroyRegionMessage.this.processorId != 0) {
                                ReplyException rex = null;
                                if (thr != null) {
                                    rex = new ReplyException(thr);
                                }
                                DestroyRegionMessage.this.sendReply(DestroyRegionMessage.this.getSender(), DestroyRegionMessage.this.processorId, rex, DestroyRegionMessage.this.getReplySender(dm));
                            }
                        } else if (thr != null) {
                            logger.error(LocalizedMessage.create(LocalizedStrings.DestroyRegionOperation_EXCEPTION_WHILE_PROCESSING__0_, this), thr);
                        }
                    }
                }
            };
        }

        @Override
        protected void basicProcess(DistributionManager dm, LocalRegion lclRgn) {
            Assert.assertTrue(this.serialNum != -1);
            try {
                this.lockRoot = null;
                boolean sendReply = true;
                dm.getWaitingThreadPool().execute(this.destroyOp(dm, lclRgn, true));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        protected LocalRegion getRegionFromPath(InternalDistributedSystem sys, String path) {
            GemFireCacheImpl c = (GemFireCacheImpl)CacheFactory.getInstance(sys);
            if (this.getOperation().isDistributed()) {
                String rootName = GemFireCacheImpl.parsePath(path)[0];
                this.lockRoot = (LocalRegion)c.getRegion(rootName);
                if (this.lockRoot == null) {
                    return null;
                }
                this.lockRoot.acquireDestroyLock();
            }
            return (LocalRegion)c.getRegion(path);
        }

        private void disableRegionDepartureNotification() {
            if (!this.notifyOfRegionDeparture) {
                regionDepartureNotificationDisabled.set(Boolean.TRUE);
            }
        }

        private void enableRegionDepartureNotification() {
            if (!this.notifyOfRegionDeparture) {
                regionDepartureNotificationDisabled.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doRegionDestroy(CacheEvent event) throws EntryNotFoundException {
            this.appliedOperation = true;
            RegionEventImpl ev = (RegionEventImpl)event;
            final DistributedRegion rgn = (DistributedRegion)ev.region;
            if (this.getOperation().isLocal()) {
                Assert.assertTrue(this.serialNum != -1);
                this.disableRegionDepartureNotification();
                try {
                    rgn.handleRemoteLocalRegionDestroyOrClose(this.getSender(), this.serialNum, this.subregionSerialNumbers, !this.getOperation().isClose());
                }
                finally {
                    this.enableRegionDepartureNotification();
                }
                return true;
            }
            try {
                String fullPath = null;
                if (logger.isDebugEnabled()) {
                    fullPath = rgn.getFullPath();
                    StringBuffer subregionNames = new StringBuffer();
                    Iterator itr = rgn.debugGetSubregionNames().iterator();
                    while (itr.hasNext()) {
                        subregionNames.append(itr.next());
                        subregionNames.append(", ");
                    }
                    logger.debug("Processing DestroyRegionOperation, about to destroy {}, has immediate subregions: {}", fullPath, subregionNames);
                }
                if (this.getOperation() == Operation.REGION_LOAD_SNAPSHOT) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing DestroyRegionOperation, calling reinitialize_destroy: {}", fullPath);
                    }
                    rgn.reinitialize_destroy(ev);
                    final LocalRegion loc_lockRoot = this.lockRoot;
                    this.lockRoot = null;
                    rgn.getDistributionManager().getWaitingThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                rgn.reinitializeFromImageTarget(DestroyRegionMessage.this.getSender());
                            }
                            catch (TimeoutException e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.DestroyRegionOperation_GOT_TIMEOUT_WHEN_TRYING_TO_RECREATE_REGION_DURING_REINITIALIZATION_1, rgn.getFullPath()), (Throwable)e);
                            }
                            catch (IOException e) {
                                InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.UNEXPECTED_EXCEPTION.toLocalizedString());
                                assErr.initCause(e);
                                throw assErr;
                            }
                            catch (ClassNotFoundException e) {
                                InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.UNEXPECTED_EXCEPTION.toLocalizedString());
                                assErr.initCause(e);
                                throw assErr;
                            }
                            finally {
                                if (loc_lockRoot != null) {
                                    loc_lockRoot.releaseDestroyLock();
                                }
                            }
                        }
                    });
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing DestroyRegionOperation, calling basicDestroyRegion: {}", fullPath);
                    }
                    rgn.basicDestroyRegion(ev, false, false, true);
                }
            }
            catch (CacheWriterException e) {
                throw new Error(LocalizedStrings.DestroyRegionOperation_CACHEWRITER_SHOULD_NOT_HAVE_BEEN_CALLED.toLocalizedString());
            }
            catch (TimeoutException e) {
                throw new Error(LocalizedStrings.DestroyRegionOperation_DISTRIBUTEDLOCK_SHOULD_NOT_HAVE_BEEN_ACQUIRED.toLocalizedString());
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
            return true;
        }

        @Override
        protected boolean operateOnRegion(CacheEvent event, DistributionManager dm) throws EntryNotFoundException {
            Assert.assertTrue(false, LocalizedStrings.DestroyRegionOperation_REGION_DESTRUCTION_MESSAGE_IMPLEMENTATION_IS_IN_BASICPROCESS__NOT_THIS_METHOD.toLocalizedString());
            return false;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; eventID=").append(this.eventID).append("; serialNum=").append(this.serialNum).append("; subregionSerialNumbers=").append(this.subregionSerialNumbers).append("; notifyOfRegionDeparture=").append(this.notifyOfRegionDeparture);
        }

        @Override
        public int getDSFID() {
            return 99;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.eventID = (EventID)DataSerializer.readObject(in);
            this.serialNum = DataSerializer.readPrimitiveInt(in);
            this.notifyOfRegionDeparture = DataSerializer.readPrimitiveBoolean(in);
            this.subregionSerialNumbers = DataSerializer.readHashMap(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.eventID, out);
            DataSerializer.writePrimitiveInt(this.serialNum, out);
            DataSerializer.writePrimitiveBoolean(this.notifyOfRegionDeparture, out);
            DataSerializer.writeHashMap(this.subregionSerialNumbers, out);
        }
    }
}

