/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class DestroyPartitionedRegionMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private Object cbArg;
    private Operation op;
    private int prSerial;
    private int[] bucketSerials;

    public DestroyPartitionedRegionMessage() {
    }

    private DestroyPartitionedRegionMessage(Set recipients, PartitionedRegion region, ReplyProcessor21 processor, RegionEventImpl event, int[] serials) {
        super(recipients, region.getPRId(), processor);
        this.cbArg = event.getRawCallbackArgument();
        this.op = event.getOperation();
        this.prSerial = region.getSerialNumber();
        Assert.assertTrue(this.prSerial != -1);
        this.bucketSerials = serials;
    }

    public static DestroyPartitionedRegionResponse send(Set recipients, PartitionedRegion r, RegionEventImpl event, int[] serials) {
        Assert.assertTrue(recipients != null, "DestroyMessage NULL recipients set");
        DestroyPartitionedRegionResponse resp = new DestroyPartitionedRegionResponse(r.getSystem(), recipients);
        DestroyPartitionedRegionMessage m = new DestroyPartitionedRegionMessage(recipients, r, resp, event, serials);
        r.getDistributionManager().putOutgoing(m);
        return resp;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws CacheException {
        if (this.op.isLocal()) {
            RegionAdvisor.PartitionProfile pp = r.getRegionAdvisor().getPartitionProfile(this.getSender());
            if (pp == null) {
                return true;
            }
            Assert.assertTrue(this.prSerial != -1);
            boolean ok = true;
            int oldSerial = pp.getSerialNumber();
            if (DistributionAdvisor.isNewerSerialNumber(oldSerial, this.prSerial)) {
                ok = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("Not removing region {}l serial requested = {}; actual is {}", r.getName(), this.prSerial, r.getSerialNumber());
                }
            }
            if (ok) {
                RegionAdvisor ra = r.getRegionAdvisor();
                ra.removeIdAndBuckets(this.sender, this.prSerial, this.bucketSerials, !this.op.isClose());
            }
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
            return false;
        }
        if (r.isDestroyed()) {
            boolean isClose = this.op.isClose();
            r.destroyPartitionedRegionLocally(!isClose);
            return true;
        }
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "{} operateOnRegion: {}", this.getClass().getName(), r.getFullPath());
        }
        RegionEventImpl event = new RegionEventImpl(r, this.op, this.cbArg, true, r.getMyId());
        r.basicDestroyRegion(event, false, false, true);
        return true;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; cbArg=").append(this.cbArg).append("; op=").append(this.op);
        buff.append("; prSerial=" + this.prSerial);
        buff.append("; bucketSerials (" + this.bucketSerials.length + ")=(");
        for (int i = 0; i < this.bucketSerials.length; ++i) {
            buff.append(Integer.toString(this.bucketSerials[i]));
            if (i >= this.bucketSerials.length - 1) continue;
            buff.append(", ");
        }
    }

    @Override
    public int getDSFID() {
        return -88;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.cbArg = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        this.prSerial = in.readInt();
        int len = in.readInt();
        this.bucketSerials = new int[len];
        for (int i = 0; i < len; ++i) {
            this.bucketSerials[i] = in.readInt();
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.cbArg, out);
        out.writeByte(this.op.ordinal);
        out.writeInt(this.prSerial);
        out.writeInt(this.bucketSerials.length);
        for (int i = 0; i < this.bucketSerials.length; ++i) {
            out.writeInt(this.bucketSerials[i]);
        }
    }

    public static class DestroyPartitionedRegionResponse
    extends ReplyProcessor21 {
        public DestroyPartitionedRegionResponse(InternalDistributedSystem system, Set initMembers) {
            super(system, (Collection)initMembers);
        }

        @Override
        protected void processException(ReplyException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("DestroyRegionResponse ignoring exception", (Throwable)ex);
            }
        }
    }
}

