/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.server.ClientSubscriptionConfig;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class ClientSubscriptionConfigImpl
implements ClientSubscriptionConfig {
    public static final String CLIENT_SUBSCRIPTION = "client_subscription";
    private int haQueueCapacity = 1;
    private String haEvictionPolicy = "none";
    private String overflowDirectory = ".";
    private String diskStoreName;
    private boolean hasOverflowDirectory = false;

    @Override
    public int getCapacity() {
        return this.haQueueCapacity;
    }

    @Override
    public void setCapacity(int capacity) {
        this.haQueueCapacity = capacity;
    }

    @Override
    public String getEvictionPolicy() {
        return this.haEvictionPolicy;
    }

    @Override
    public void setEvictionPolicy(String policy) {
        this.haEvictionPolicy = policy;
    }

    @Override
    @Deprecated
    public void setOverflowDirectory(String overflowDirectory) {
        if (this.getDiskStoreName() != null) {
            throw new IllegalStateException(LocalizedStrings.DiskStore_Deprecated_API_0_Cannot_Mix_With_DiskStore_1.toLocalizedString("setOverflowDirectory", this.getDiskStoreName()));
        }
        this.overflowDirectory = overflowDirectory;
        this.setHasOverflowDirectory(true);
    }

    @Override
    @Deprecated
    public String getOverflowDirectory() {
        if (this.getDiskStoreName() != null) {
            throw new IllegalStateException(LocalizedStrings.DiskStore_Deprecated_API_0_Cannot_Mix_With_DiskStore_1.toLocalizedString("getOverflowDirectory", this.getDiskStoreName()));
        }
        return this.overflowDirectory;
    }

    public String toString() {
        String str = " Eviction policy " + this.getEvictionPolicy() + " capacity " + this.getCapacity();
        str = this.diskStoreName == null ? str + " Overflow Directory " + this.getOverflowDirectory() : str + " DiskStore Name: " + this.diskStoreName;
        return str;
    }

    @Override
    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    @Override
    public void setDiskStoreName(String diskStoreName) {
        if (this.hasOverflowDirectory()) {
            throw new IllegalStateException(LocalizedStrings.DiskStore_Deprecated_API_0_Cannot_Mix_With_DiskStore_1.toLocalizedString("setDiskStoreName", this.getDiskStoreName()));
        }
        this.diskStoreName = diskStoreName;
    }

    public boolean hasOverflowDirectory() {
        return this.hasOverflowDirectory;
    }

    private void setHasOverflowDirectory(boolean hasOverflowDirectory) {
        this.hasOverflowDirectory = hasOverflowDirectory;
    }
}

