/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractBucketRegionQueue;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.persistence.query.mock.ByteComparator;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.BucketRegionQueueUnavailableException;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.concurrent.Atomics;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.Logger;

public class BucketRegionQueue
extends AbstractBucketRegionQueue {
    private static final Logger logger = LogService.getLogger();
    private final Map indexes;
    private final BlockingQueue<Object> eventSeqNumQueue = new LinkedBlockingQueue<Object>();
    private long lastKeyRecovered;

    public BucketRegionQueue(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.keySet();
        this.indexes = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        super.initialize(snapshotInputStream, imageTarget, internalRegionArgs);
        this.loadEventsFromTempQueue();
        this.getInitializationLock().writeLock().lock();
        try {
            if (!this.keySet().isEmpty()) {
                if (this.getPartitionedRegion().getColocatedWith() == null) {
                    ArrayList keys = new ArrayList(this.keySet());
                    Collections.sort(keys, new Comparator<EventID>(){

                        @Override
                        public int compare(EventID o1, EventID o2) {
                            int compareMem = new ByteComparator().compare(o1.getMembershipID(), o2.getMembershipID());
                            if (compareMem == 1) {
                                return 1;
                            }
                            if (compareMem == -1) {
                                return -1;
                            }
                            if (o1.getThreadID() > o2.getThreadID()) {
                                return 1;
                            }
                            if (o1.getThreadID() < o2.getThreadID()) {
                                return -1;
                            }
                            return o1.getSequenceID() < o2.getSequenceID() ? -1 : (o1.getSequenceID() == o2.getSequenceID() ? 0 : 1);
                        }
                    });
                    for (EventID eventID : keys) {
                        this.eventSeqNumQueue.add(eventID);
                    }
                } else {
                    TreeSet sortedKeys = new TreeSet(this.keySet());
                    if (!sortedKeys.isEmpty()) {
                        for (Long key2 : sortedKeys) {
                            this.eventSeqNumQueue.add(key2);
                        }
                        this.lastKeyRecovered = (Long)sortedKeys.last();
                        if (this.getEventSeqNum() != null) {
                            Atomics.setIfGreater(this.getEventSeqNum(), this.lastKeyRecovered);
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("For bucket {} ,total keys recovered are : {} last key recovered is : {} and the seqNo is ", this.getId(), this.eventSeqNumQueue.size(), this.lastKeyRecovered, this.getEventSeqNum());
                }
            }
            this.initialized = true;
            this.destroyFailedBatchRemovalMessageKeys();
        }
        finally {
            this.notifyEventProcessor();
            this.getInitializationLock().writeLock().unlock();
        }
    }

    private void destroyFailedBatchRemovalMessageKeys() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Iterator<Object> itr = this.getFailedBatchRemovalMessageKeys().iterator();
        while (itr.hasNext()) {
            Object key2 = itr.next();
            itr.remove();
            if (isDebugEnabled) {
                logger.debug("key from failedBatchRemovalMessageKeys is: {}", key2);
            }
            if (!this.containsKey(key2)) continue;
            try {
                this.destroyKey(key2);
                if (!isDebugEnabled) continue;
                logger.debug("Destroyed {} from bucket: ", key2, this.getId());
            }
            catch (ForceReattemptException fe) {
                if (!isDebugEnabled) continue;
                logger.debug("Bucket :{} moved to other member", this.getId());
            }
        }
    }

    @Override
    public void beforeAcquiringPrimaryState() {
        int batchSize = this.getPartitionedRegion().getParallelGatewaySender().getBatchSize();
        Iterator itr = this.eventSeqNumQueue.iterator();
        this.markEventsAsDuplicate(batchSize, itr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearQueues() {
        this.getInitializationLock().writeLock().lock();
        try {
            this.indexes.clear();
            this.eventSeqNumQueue.clear();
        }
        finally {
            this.getInitializationLock().writeLock().unlock();
        }
    }

    @Override
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        boolean success = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        if (success) {
            if (this.getPartitionedRegion().getColocatedWith() == null) {
                return success;
            }
            if (this.getPartitionedRegion().isConflationEnabled() && this.getBucketAdvisor().isPrimary()) {
                Object object = event.getNewValue();
                Long key2 = (Long)event.getKey();
                if (object instanceof Conflatable) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Key :{} , Object : {} is conflatable", key2, object);
                    }
                    this.conflateOldEntry((Conflatable)object, key2);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Object : {} is not conflatable", object);
                }
            }
        }
        return success;
    }

    private void conflateOldEntry(Conflatable object, Long tailKey) {
        PartitionedRegion region = this.getPartitionedRegion();
        Conflatable conflatableObject = object;
        if (region.isConflationEnabled() && conflatableObject.shouldBeConflated()) {
            Long previousTailKey;
            ConcurrentHashMap<Object, Long> latestIndexesForRegion;
            Object keyToConflate = conflatableObject.getKeyToConflate();
            String rName = object.getRegionToConflate();
            if (logger.isDebugEnabled()) {
                logger.debug(" The region name is : {}", rName);
            }
            if ((latestIndexesForRegion = (ConcurrentHashMap<Object, Long>)this.indexes.get(rName)) == null) {
                latestIndexesForRegion = new ConcurrentHashMap<Object, Long>();
                this.indexes.put(rName, latestIndexesForRegion);
            }
            if ((previousTailKey = latestIndexesForRegion.put(keyToConflate, tailKey)) != null) {
                AbstractGatewaySenderEventProcessor ep;
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Conflating {} at queue index={} and previousTailKey: ", this, object, tailKey, previousTailKey);
                }
                if ((ep = region.getParallelGatewaySender().getEventProcessor()) == null) {
                    return;
                }
                ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue();
                queue.conflateEvent(conflatableObject, this.getId(), previousTailKey);
            } else {
                region.getParallelGatewaySender().getStatistics().incConflationIndexesMapSize();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("{}: Not conflating {}", this, object);
        }
    }

    private void removeIndex(Long qkey) {
        Conflatable object;
        Object o = this.getNoLRU(qkey, true, false, false);
        if (o instanceof Conflatable && (object = (Conflatable)o).shouldBeConflated()) {
            Long index2;
            String rName = object.getRegionToConflate();
            Object key2 = object.getKeyToConflate();
            Map latestIndexesForRegion = (Map)this.indexes.get(rName);
            if (latestIndexesForRegion != null && (index2 = (Long)latestIndexesForRegion.remove(key2)) != null) {
                this.getPartitionedRegion().getParallelGatewaySender().getStatistics().decConflationIndexesMapSize();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Removed index {} for {}", this, index2, object);
                }
            }
        }
    }

    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        if (this.getPartitionedRegion().isConflationEnabled()) {
            this.removeIndex((Long)event.getKey());
        }
        super.basicDestroy(event, cacheWrite, expectedOldValue);
        if (!this.getBucketAdvisor().isPrimary()) {
            if (logger.isDebugEnabled()) {
                logger.debug(" removing the key {} from eventSeqNumQueue", event.getKey());
            }
            this.eventSeqNumQueue.remove(event.getKey());
        }
    }

    private Object optimalGet(Object k) {
        Object object = null;
        try {
            object = this.getValueInVMOrDiskWithoutFaultIn(k);
            if (object != null && object instanceof CachedDeserializable) {
                object = ((CachedDeserializable)object).getDeserializedValue(this, this.getRegionEntry(k));
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        if (object == Token.TOMBSTONE) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object key2 = null;
        Object object = null;
        this.getInitializationLock().readLock().lock();
        try {
            if (this.getPartitionedRegion().isDestroyed()) {
                throw new BucketRegionQueueUnavailableException();
            }
            key2 = this.eventSeqNumQueue.peek();
            if (key2 != null) {
                object = this.optimalGet(key2);
                if (object == null && !this.getPartitionedRegion().isConflationEnabled() && logger.isDebugEnabled()) {
                    logger.debug("The value against key {} in the bucket region queue with id {} is NULL for the GatewaySender {}", key2, this.getId(), this.getPartitionedRegion().getParallelGatewaySender());
                }
                this.eventSeqNumQueue.remove(key2);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.getInitializationLock().readLock().unlock();
        }
    }

    @Override
    protected void addToEventQueue(Object key2, boolean didPut, EntryEventImpl event) {
        if (didPut) {
            if (this.initialized) {
                this.eventSeqNumQueue.add(key2);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Put successfully in the queue : {} was initialized: {}", event.getRawNewValue(), this.initialized);
            }
        }
        if (this.getBucketAdvisor().isPrimary()) {
            this.incQueueSize(1);
        }
    }

    public Object remove() throws ForceReattemptException {
        Object key2 = this.eventSeqNumQueue.remove();
        if (key2 != null) {
            this.destroyKey(key2);
        }
        return key2;
    }

    public Object take() throws InterruptedException, ForceReattemptException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyKey(Object key2) throws ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug(" destroying primary key {}", key2);
        }
        EntryEventImpl event = this.getPartitionedRegion().newDestroyEntryEvent(key2, null);
        event.setEventId(new EventID(this.cache.getSystem()));
        try {
            event.setRegion(this);
            this.basicDestroy(event, true, null);
            this.checkReadiness();
        }
        catch (EntryNotFoundException enf) {
            if (this.getPartitionedRegion().isDestroyed()) {
                this.getPartitionedRegion().checkReadiness();
                if (this.isBucketDestroyed()) {
                    throw new ForceReattemptException("Bucket moved", new RegionDestroyedException(LocalizedStrings.PartitionedRegionDataStore_REGION_HAS_BEEN_DESTROYED.toLocalizedString(), this.getPartitionedRegion().getFullPath()));
                }
            }
            throw enf;
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved while destroying key " + key2, rde);
            }
        }
        this.notifyEntriesRemoved();
    }

    public boolean isReadyForPeek() {
        return !this.getPartitionedRegion().isDestroyed() && !this.isEmpty() && !this.eventSeqNumQueue.isEmpty() && this.getBucketAdvisor().isPrimary();
    }
}

