/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.DeltaSerializationException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.partition.PartitionListener;
import com.gemstone.gemfire.cache.query.internal.IndexUpdater;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.AtomicLongWithTerminalState;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.BucketRegionQueue;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.DestroyOperation;
import com.gemstone.gemfire.internal.cache.DestroyRegionOperation;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.DistributedRemoveAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.EventTracker;
import com.gemstone.gemfire.internal.cache.ExpiryTask;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalCacheEvent;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.InvalidateOperation;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEventImpl;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.UpdateEntryVersionOperation;
import com.gemstone.gemfire.internal.cache.UpdateOperation;
import com.gemstone.gemfire.internal.cache.control.MemoryEvent;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.DestroyMessage;
import com.gemstone.gemfire.internal.cache.partitioned.InvalidateMessage;
import com.gemstone.gemfire.internal.cache.partitioned.LockObject;
import com.gemstone.gemfire.internal.cache.partitioned.PRTombstoneMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PutAllPRMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PutMessage;
import com.gemstone.gemfire.internal.cache.partitioned.RemoveAllPRMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientTombstoneMessage;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.concurrent.Atomics;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.Logger;

public class BucketRegion
extends DistributedRegion
implements Bucket {
    private static final Logger logger = LogService.getLogger();
    public static final RawValue NULLVALUE = new RawValue(null);
    public static final RawValue REQUIRES_ENTRY_LOCK = new RawValue(null);
    private static final long BUCKET_DESTROYED = Long.MIN_VALUE;
    private AtomicLong counter = new AtomicLong();
    private AtomicLong limit;
    private final AtomicLong numOverflowOnDisk = new AtomicLong();
    private final AtomicLong numOverflowBytesOnDisk = new AtomicLong();
    private final AtomicLong numEntriesInVM = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();
    private final AtomicLongWithTerminalState bytesInMemory = new AtomicLongWithTerminalState();
    private static final long serialVersionUID = 1L;
    private final int redundancy;
    private final PartitionedRegion partitionedRegion;
    private final Map<Object, ExpiryTask> pendingSecondaryExpires = new HashMap<Object, ExpiryTask>();
    public HashMap allKeysMap = new HashMap();
    static final boolean FORCE_LOCAL_LISTENERS_INVOCATION = Boolean.getBoolean("gemfire.BucketRegion.alwaysFireLocalListeners");
    private volatile AtomicLong eventSeqNum = null;
    boolean isDestroyingDiskRegion;

    public AtomicLong getEventSeqNum() {
        return this.eventSeqNum;
    }

    public BucketRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        if (PartitionedRegion.DISABLE_SECONDARY_BUCKET_ACK) {
            Assert.assertTrue(attrs.getScope().isDistributedNoAck());
        } else {
            Assert.assertTrue(attrs.getScope().isDistributedAck());
        }
        Assert.assertTrue(attrs.getDataPolicy().withReplication());
        Assert.assertTrue(!attrs.getEarlyAck());
        Assert.assertTrue(!attrs.getEnableGateway());
        Assert.assertTrue(this.isUsedForPartitionedRegionBucket());
        Assert.assertTrue(!this.isUsedForPartitionedRegionAdmin());
        Assert.assertTrue(internalRegionArgs.getBucketAdvisor() != null);
        Assert.assertTrue(internalRegionArgs.getPartitionedRegion() != null);
        this.redundancy = internalRegionArgs.getPartitionedRegionBucketRedundancy();
        this.partitionedRegion = internalRegionArgs.getPartitionedRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        this.getBucketAdvisor().getProxyBucketRegion().setBucketRegion(this);
        boolean success = false;
        try {
            BucketRegion parentBucket;
            PartitionedRegion parentPR;
            if (this.partitionedRegion.isShadowPR() && this.partitionedRegion.getColocatedWith() != null) {
                parentPR = ColocationHelper.getLeaderRegion(this.partitionedRegion);
                parentBucket = parentPR.getDataStore().getLocalBucketById(this.getId());
                if (parentBucket.eventSeqNum == null) {
                    parentBucket.eventSeqNum = new AtomicLong(this.getId());
                }
            }
            if (this.partitionedRegion.getColocatedWith() == null) {
                this.eventSeqNum = new AtomicLong(this.getId());
            } else {
                parentPR = ColocationHelper.getLeaderRegion(this.partitionedRegion);
                parentBucket = parentPR.getDataStore().getLocalBucketById(this.getId());
                if (parentBucket == null && logger.isDebugEnabled()) {
                    logger.debug("The parentBucket of region {} bucketId {} is NULL", this.partitionedRegion.getFullPath(), this.getId());
                }
                Assert.assertTrue(parentBucket != null);
                this.eventSeqNum = parentBucket.eventSeqNum;
            }
            InternalDistributedMember primaryHolder = this.getBucketAdvisor().basicGetPrimaryMember();
            if (primaryHolder != null && !primaryHolder.equals(this.getMyId())) {
                super.initialize(snapshotInputStream, primaryHolder, internalRegionArgs);
            } else {
                super.initialize(snapshotInputStream, imageTarget, internalRegionArgs);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.removeFromPeersAdvisors(false);
                this.getBucketAdvisor().getProxyBucketRegion().clearBucketRegion(this);
            }
        }
    }

    @Override
    public void initialized() {
    }

    @Override
    protected DiskStoreImpl findDiskStore(RegionAttributes ra, InternalRegionArguments internalRegionArgs) {
        return internalRegionArgs.getPartitionedRegion().getDiskStore();
    }

    @Override
    public void createEventTracker() {
        this.eventTracker = new EventTracker(this);
        this.eventTracker.start();
    }

    @Override
    protected CacheDistributionAdvisor createDistributionAdvisor(InternalRegionArguments internalRegionArgs) {
        return internalRegionArgs.getBucketAdvisor();
    }

    @Override
    public BucketAdvisor getBucketAdvisor() {
        return (BucketAdvisor)this.getDistributionAdvisor();
    }

    @Override
    public boolean isHosting() {
        return this.getBucketAdvisor().isHosting();
    }

    @Override
    protected EventID distributeTombstoneGC(Set<Object> keysRemoved) {
        EventID eventId = super.distributeTombstoneGC(keysRemoved);
        if (keysRemoved != null && keysRemoved.size() > 0 && this.getFilterProfile() != null) {
            PRTombstoneMessage.send(this, keysRemoved, eventId);
        }
        return eventId;
    }

    @Override
    protected void notifyClientsOfTombstoneGC(Map<VersionSource, Long> regionGCVersions, Set<Object> removedKeys, EventID eventID, FilterRoutingInfo.FilterInfo routing) {
        if (CacheClientNotifier.getInstance() != null) {
            FilterProfile fp = this.getFilterProfile();
            if (removedKeys != null && removedKeys.size() > 0 && (routing != null || fp != null)) {
                RegionEventImpl regionEvent = new RegionEventImpl(this.getPartitionedRegion(), Operation.REGION_DESTROY, null, true, this.getMyId());
                FilterRoutingInfo.FilterInfo clientRouting = routing;
                if (clientRouting == null) {
                    clientRouting = fp.getLocalFilterRouting(regionEvent);
                }
                regionEvent.setLocalFilterInfo(clientRouting);
                ClientTombstoneMessage clientMessage = ClientTombstoneMessage.gc((LocalRegion)this.getPartitionedRegion(), removedKeys, eventID);
                CacheClientNotifier.notifyClients(regionEvent, clientMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockObject searchAndLock(Object[] keys) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        LockObject foundLock = null;
        HashMap hashMap = this.allKeysMap;
        synchronized (hashMap) {
            int i;
            for (i = 0; i < keys.length; ++i) {
                if (!this.allKeysMap.containsKey(keys[i])) continue;
                foundLock = (LockObject)this.allKeysMap.get(keys[i]);
                if (!isDebugEnabled) break;
                logger.debug("LockKeys: found key: {}:{}", keys[i], foundLock.lockedTimeStamp);
                break;
            }
            if (foundLock == null) {
                for (i = 0; i < keys.length; ++i) {
                    LockObject lockValue = new LockObject(keys[i], isDebugEnabled ? System.currentTimeMillis() : 0L);
                    this.allKeysMap.put(keys[i], lockValue);
                    if (!isDebugEnabled) continue;
                    logger.debug("LockKeys: add key: {}:{}", keys[i], lockValue.lockedTimeStamp);
                }
            }
        }
        return foundLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndNotifyKeys(Object[] keys) {
        boolean isTraceEnabled = logger.isTraceEnabled();
        HashMap hashMap = this.allKeysMap;
        synchronized (hashMap) {
            for (int i = 0; i < keys.length; ++i) {
                LockObject lockValue = (LockObject)this.allKeysMap.remove(keys[i]);
                if (lockValue == null) continue;
                LockObject lockObject = lockValue;
                synchronized (lockObject) {
                    lockValue.setRemoved();
                    if (isTraceEnabled) {
                        long waitTime = System.currentTimeMillis() - lockValue.lockedTimeStamp;
                        logger.trace("LockKeys: remove key {}, notifyAll for {}. It waited", keys[i], lockValue, waitTime);
                    }
                    lockValue.notifyAll();
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilLocked(Object[] keys) {
        LockObject foundLock;
        boolean isDebugEnabled = logger.isDebugEnabled();
        String title = "BucketRegion.waitUntilLocked:";
        while ((foundLock = this.searchAndLock(keys)) != null) {
            LockObject lockObject = foundLock;
            synchronized (lockObject) {
                block8: {
                    try {
                        while (!foundLock.isRemoved()) {
                            this.partitionedRegion.checkReadiness();
                            foundLock.wait(1000L);
                            this.checkForPrimary();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!isDebugEnabled) break block8;
                        logger.debug("{} interrupted while waiting for {}", "BucketRegion.waitUntilLocked:", foundLock, e.getMessage());
                    }
                }
                if (isDebugEnabled) {
                    long waitTime = System.currentTimeMillis() - foundLock.lockedTimeStamp;
                    logger.debug("{} waited {} ms to lock", "BucketRegion.waitUntilLocked:", waitTime, foundLock);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        this.beginLocalWrite(event);
        try {
            if (this.partitionedRegion.isParallelWanEnabled()) {
                this.handleWANEvent(event);
            }
            if (!this.hasSeenEvent(event)) {
                RegionEntry oldEntry;
                if (!(this instanceof BucketRegionQueue)) {
                    this.forceSerialized(event);
                }
                boolean bl = (oldEntry = this.entries.basicPut(event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue, overwriteDestroyed)) != null;
                return bl;
            }
            if (event.getDeltaBytes() != null && event.getRawNewValue() == null) {
                throw new InvalidDeltaException("Cache encountered replay of event containing delta bytes for key " + event.getKey());
            }
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "BR.virtualPut: this cache has already seen this event {}", event);
            }
            this.distributeUpdateOperation(event, lastModified);
            boolean bl = true;
            return bl;
        }
        finally {
            this.endLocalWrite(event);
        }
    }

    public void handleWANEvent(EntryEventImpl event) {
        if (this.eventSeqNum == null && logger.isDebugEnabled()) {
            logger.debug("The bucket corresponding to this user bucket is not created yet. This event will not go to remote wan site. Event: {}", event);
        }
        if (!(this instanceof BucketRegionQueue)) {
            if (this.getBucketAdvisor().isPrimary()) {
                long key2 = this.eventSeqNum.addAndGet(this.partitionedRegion.getTotalNumberOfBuckets());
                if (key2 < 0L || key2 % (long)this.getPartitionedRegion().getTotalNumberOfBuckets() != (long)this.getId()) {
                    logger.error(LocalizedMessage.create(LocalizedStrings.GatewaySender_SEQUENCENUMBER_GENERATED_FOR_EVENT_IS_INVALID, new Object[]{key2, this.getId()}));
                }
                event.setTailKey(key2);
                if (logger.isDebugEnabled()) {
                    logger.debug("WAN: On primary bucket {}, setting the seq number as {}", this.getId(), this.eventSeqNum.get());
                }
            } else {
                Atomics.setIfGreater(this.eventSeqNum, event.getTailKey());
                if (logger.isDebugEnabled()) {
                    logger.debug("WAN: On secondary bucket {}, setting the seq number as {}", this.getId(), event.getTailKey());
                }
            }
        }
    }

    public void updateEventSeqNum(long l) {
        Atomics.setIfGreater(this.eventSeqNum, l);
        if (logger.isDebugEnabled()) {
            logger.debug("WAN: On bucket {}, setting the seq number as {} before GII", this.getId(), l);
        }
    }

    protected void distributeUpdateOperation(EntryEventImpl event, long lastModified) {
        if (!event.isOriginRemote() && !event.isNetSearch() && this.getBucketAdvisor().isPrimary()) {
            if (event.isBulkOpInProgress()) {
                event.getPutAllOperation().addEntry(event, this.getId());
            } else {
                new UpdateOperation(event, lastModified).distribute();
                if (logger.isDebugEnabled()) {
                    logger.debug("sent update operation : for region  : {}: with event: {}", this.getName(), event);
                }
            }
        }
        if (!event.getOperation().isPutAll()) {
            event.invokeCallbacks(this, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
        long modifiedTime = event.getEventTime(lastModified);
        if (this.partitionedRegion.getDataStore().hasClientInterest(event)) {
            this.updateStatsForGet(entry, true);
        }
        if (!event.isOriginRemote()) {
            boolean eventHasDelta;
            VersionTag v;
            if ((event.getVersionTag() == null || event.getVersionTag().isGatewayTag()) && (v = entry.generateVersionTag(null, eventHasDelta = event.getDeltaBytes() != null, this, event)) != null && logger.isDebugEnabled()) {
                logger.debug("generated version tag {} in region {}", v, this.getName());
            }
            if (!event.isBulkOpInProgress()) {
                long start = this.partitionedRegion.getPrStats().startSendReplication();
                try {
                    UpdateOperation op = new UpdateOperation(event, modifiedTime);
                    op.distribute();
                }
                finally {
                    this.partitionedRegion.getPrStats().endSendReplication(start);
                }
            }
        }
        return super.basicPutPart2(event, entry, isInitialized, lastModified, clearConflict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyGatewayHubs(EnumListenerEvent operation, EntryEventImpl event) {
        if (this.shouldNotifyGatewayHub()) {
            EntryEventImpl prEvent = this.createEventForPR(event);
            this.partitionedRegion.notifyGatewayHubs(operation, prEvent);
        } else {
            LocalRegion bucketRegion = event.getRegion();
            try {
                event.setRegion(this.partitionedRegion);
                this.partitionedRegion.notifyGatewayHubs(operation, event);
            }
            finally {
                event.setRegion(bucketRegion);
            }
        }
    }

    public void checkForPrimary() {
        boolean isp = this.getBucketAdvisor().isPrimary();
        if (!isp) {
            this.partitionedRegion.checkReadiness();
            this.checkReadiness();
            InternalDistributedMember primaryHolder = this.getBucketAdvisor().basicGetPrimaryMember();
            throw new PrimaryBucketException("Bucket " + this.getName() + " is not primary. Current primary holder is " + primaryHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginLocalWrite(EntryEventImpl event) {
        if (!this.needWriteLock(event)) {
            return;
        }
        if (this.cache.isCacheAtShutdownAll()) {
            throw new CacheClosedException("Cache is shutting down");
        }
        Object[] keys = new Object[]{event.getKey()};
        this.waitUntilLocked(keys);
        boolean lockedForPrimary = false;
        try {
            this.doLockForPrimary(false);
            lockedForPrimary = true;
        }
        finally {
            if (!lockedForPrimary) {
                this.removeAndNotifyKeys(keys);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doLockForPrimary(boolean tryLock) {
        boolean locked = this.lockPrimaryStateReadLock(tryLock);
        if (!locked) {
            return false;
        }
        boolean isPrimary = false;
        try {
            this.checkForPrimary();
            if (this.cache.isCacheAtShutdownAll()) {
                throw new CacheClosedException("Cache is shutting down");
            }
            isPrimary = true;
        }
        finally {
            if (!isPrimary) {
                this.doUnlockForPrimary();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockPrimaryStateReadLock(boolean tryLock) {
        Lock activeWriteLock = this.getBucketAdvisor().getActiveWriteLock();
        Lock parentLock = this.getBucketAdvisor().getParentActiveWriteLock();
        while (true) {
            boolean interrupted = Thread.interrupted();
            try {
                if (parentLock != null) {
                    boolean locked;
                    if (tryLock) {
                        locked = parentLock.tryLock();
                        if (!locked) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        parentLock.lockInterruptibly();
                    }
                    if (tryLock) {
                        locked = activeWriteLock.tryLock();
                        if (!locked) {
                            parentLock.unlock();
                            boolean bl = false;
                            return bl;
                        }
                        break;
                    }
                    activeWriteLock.lockInterruptibly();
                    break;
                }
                if (tryLock) {
                    boolean locked = activeWriteLock.tryLock();
                    if (!locked) {
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
                activeWriteLock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return true;
    }

    public void doUnlockForPrimary() {
        Lock activeWriteLock = this.getBucketAdvisor().getActiveWriteLock();
        activeWriteLock.unlock();
        Lock parentLock = this.getBucketAdvisor().getParentActiveWriteLock();
        if (parentLock != null) {
            parentLock.unlock();
        }
    }

    private void endLocalWrite(EntryEventImpl event) {
        if (!this.needWriteLock(event)) {
            return;
        }
        this.doUnlockForPrimary();
        Object[] keys = new Object[]{event.getKey()};
        this.removeAndNotifyKeys(keys);
    }

    protected boolean needWriteLock(EntryEventImpl event) {
        return !event.isOriginRemote() && !event.isNetSearch() && !event.getOperation().isLocal() && !event.getOperation().isPutAll() && !event.getOperation().isRemoveAll() && (!event.isExpiration() || !this.isEntryEvictDestroyEnabled()) && !event.isPendingSecondaryExpireDestroy();
    }

    @Override
    protected void distributeUpdate(EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
    }

    @Override
    void basicInvalidate(EntryEventImpl event) throws EntryNotFoundException {
        this.basicInvalidate(event, this.isInitialized(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicInvalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws EntryNotFoundException {
        Assert.assertTrue(!event.isLocalInvalid());
        Assert.assertTrue(!this.isTX());
        Assert.assertTrue(event.getOperation().isDistributed());
        this.beginLocalWrite(event);
        try {
            if (!this.hasSeenEvent(event)) {
                if (event.getOperation().isExpiration()) {
                    InternalDistributedSystem sys = this.cache.getDistributedSystem();
                    EventID newID = new EventID(sys);
                    event.setEventId(newID);
                    event.setInvokePRCallbacks(this.getBucketAdvisor().isPrimary());
                }
                boolean forceCallbacks = this.isEntryEvictDestroyEnabled();
                boolean done = this.entries.invalidate(event, invokeCallbacks, forceNewEntry, forceCallbacks);
                ExpirationAction expirationAction = this.getEntryExpirationAction();
                if (done && !this.getBucketAdvisor().isPrimary() && expirationAction != null && expirationAction.isInvalidate()) {
                    Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
                    synchronized (map) {
                        this.pendingSecondaryExpires.remove(event.getKey());
                    }
                }
                return;
            }
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "LR.basicInvalidate: this cache has already seen this event {}", event);
            }
            if (!event.isOriginRemote() && this.getBucketAdvisor().isPrimary()) {
                new InvalidateOperation(event).distribute();
            }
            event.invokeCallbacks(this, true, false);
            return;
        }
        finally {
            this.endLocalWrite(event);
        }
    }

    @Override
    void basicInvalidatePart2(RegionEntry re, EntryEventImpl event, boolean clearConflict, boolean invokeCallbacks) {
        if (!event.isOriginRemote()) {
            if (event.getVersionTag() == null || event.getVersionTag().isGatewayTag()) {
                VersionTag v = re.generateVersionTag(null, false, this, event);
                if (logger.isDebugEnabled() && v != null) {
                    logger.debug("generated version tag {} in region {}", v, this.getName());
                }
                event.setVersionTag(v);
            }
            InvalidateOperation op = new InvalidateOperation(event);
            op.distribute();
        }
        super.basicInvalidatePart2(re, event, clearConflict, invokeCallbacks);
    }

    @Override
    void distributeInvalidate(EntryEventImpl event) {
    }

    @Override
    protected void distributeInvalidateRegion(RegionEventImpl event) {
        event.region = this;
        super.distributeInvalidateRegion(event);
        event.region = this.partitionedRegion;
    }

    @Override
    protected boolean shouldDistributeInvalidateRegion(RegionEventImpl event) {
        return this.getBucketAdvisor().isPrimary();
    }

    @Override
    protected boolean shouldGenerateVersionTag(RegionEntry entry, EntryEventImpl event) {
        if (event.getOperation().isLocal()) {
            return false;
        }
        return this.concurrencyChecksEnabled && (event.getVersionTag() == null || event.getVersionTag().isGatewayTag());
    }

    @Override
    void expireDestroy(EntryEventImpl event, boolean cacheWrite) {
        if (this.needWriteLock(event) && !this.getBucketAdvisor().isPrimary()) {
            return;
        }
        try {
            super.expireDestroy(event, cacheWrite);
            return;
        }
        catch (PrimaryBucketException e) {
            return;
        }
    }

    @Override
    void expireInvalidate(EntryEventImpl event) {
        if (!this.getBucketAdvisor().isPrimary()) {
            return;
        }
        try {
            super.expireInvalidate(event);
        }
        catch (PrimaryBucketException primaryBucketException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void performExpiryTimeout(ExpiryTask p_task) throws CacheException {
        block8: {
            ExpiryTask task = p_task;
            boolean isEvictDestroy = this.isEntryEvictDestroyEnabled();
            this.lockPrimaryStateReadLock(false);
            try {
                if (!this.getBucketAdvisor().isPrimary() && !isEvictDestroy) {
                    Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
                    synchronized (map) {
                        Object key2;
                        if (task.isPending() && (key2 = task.getKey()) != null) {
                            this.pendingSecondaryExpires.put(key2, task);
                        }
                        break block8;
                    }
                }
                super.performExpiryTimeout(task);
            }
            finally {
                this.doUnlockForPrimary();
            }
        }
    }

    protected boolean isEntryEvictDestroyEnabled() {
        return this.getEvictionAttributes() != null && EvictionAction.LOCAL_DESTROY.equals(this.getEvictionAttributes().getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processPendingSecondaryExpires() {
        block10: while (true) {
            ExpiryTask[] tasks;
            Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
            synchronized (map) {
                if (this.pendingSecondaryExpires.isEmpty()) {
                    return;
                }
                tasks = new ExpiryTask[this.pendingSecondaryExpires.size()];
                tasks = this.pendingSecondaryExpires.values().toArray(tasks);
                this.pendingSecondaryExpires.clear();
            }
            try {
                if (this.isCacheClosing() || this.isClosed() || this.isDestroyed) {
                    return;
                }
                boolean isDebugEnabled = logger.isDebugEnabled();
                int i = 0;
                while (true) {
                    if (i >= tasks.length) continue block10;
                    try {
                        if (isDebugEnabled) {
                            logger.debug("{} fired at {}", tasks[i], System.currentTimeMillis());
                        }
                        tasks[i].basicPerformTimeout(true);
                        if (this.isCacheClosing() || this.isClosed() || this.isDestroyed()) {
                            return;
                        }
                    }
                    catch (EntryNotFoundException ignore) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (RegionDestroyedException re) {
                continue;
            }
            catch (CancelException ex) {
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                logger.fatal(LocalizedMessage.create(LocalizedStrings.LocalRegion_EXCEPTION_IN_EXPIRATION_TASK), ex);
                continue;
            }
            break;
        }
    }

    @Override
    protected EntryEventImpl generateEvictDestroyEvent(Object key2) {
        EntryEventImpl event = super.generateEvictDestroyEvent(key2);
        event.setInvokePRCallbacks(true);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        Assert.assertTrue(!this.isTX());
        Assert.assertTrue(event.getOperation().isDistributed());
        this.beginLocalWrite(event);
        try {
            if (this.partitionedRegion.isParallelWanEnabled()) {
                this.handleWANEvent(event);
            }
            if (!this.hasSeenEvent(event)) {
                boolean done;
                if (event.getOperation().isExpiration()) {
                    InternalDistributedSystem sys = this.cache.getDistributedSystem();
                    if (event.getEventId() == null) {
                        EventID newID = new EventID(sys);
                        event.setEventId(newID);
                    }
                    event.setInvokePRCallbacks(this.getBucketAdvisor().isPrimary());
                }
                if ((done = this.mapDestroy(event, cacheWrite, false, expectedOldValue)) && !this.getBucketAdvisor().isPrimary() && this.isEntryExpiryPossible()) {
                    Map<Object, ExpiryTask> map = this.pendingSecondaryExpires;
                    synchronized (map) {
                        this.pendingSecondaryExpires.remove(event.getKey());
                    }
                }
                return;
            }
            this.distributeDestroyOperation(event);
            return;
        }
        finally {
            this.endLocalWrite(event);
        }
    }

    protected void distributeDestroyOperation(EntryEventImpl event) {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "BR.basicDestroy: this cache has already seen this event {}", event);
        }
        if (!event.isOriginRemote() && this.getBucketAdvisor().isPrimary()) {
            if (event.isBulkOpInProgress()) {
                event.getRemoveAllOperation().addEntry(event, this.getId());
            } else {
                event.setOldValueFromRegion();
                new DestroyOperation(event).distribute();
            }
        }
        if (!event.getOperation().isRemoveAll()) {
            event.invokeCallbacks(this, true, false);
        }
    }

    @Override
    protected void basicDestroyBeforeRemoval(RegionEntry entry, EntryEventImpl event) {
        if (!(event.isOriginRemote() || event.isBulkOpInProgress() || event.getOperation().isLocal() || Operation.EVICT_DESTROY.equals(event.getOperation()) || event.isExpiration() && this.isEntryEvictDestroyEnabled())) {
            if (event.getVersionTag() == null || event.getVersionTag().isGatewayTag()) {
                VersionTag v = entry.generateVersionTag(null, false, this, event);
                if (logger.isDebugEnabled() && v != null) {
                    logger.debug("generated version tag {} in region {}", v, this.getName());
                }
            }
            new DestroyOperation(event).distribute();
        }
        super.basicDestroyBeforeRemoval(entry, event);
    }

    @Override
    void distributeDestroy(EntryEventImpl event, Object expectedOldValue) {
    }

    @Override
    protected void validateArguments(Object key2, Object value2, Object aCallbackArgument) {
        Assert.assertTrue(!this.isTX());
        super.validateArguments(key2, value2, aCallbackArgument);
    }

    public void forceSerialized(EntryEventImpl event) {
        event.makeSerializedNewValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RegionEntry basicPutEntry(EntryEventImpl event, long lastModified) throws TimeoutException, CacheWriterException {
        this.beginLocalWrite(event);
        try {
            event.setInvokePRCallbacks(true);
            this.forceSerialized(event);
            RegionEntry regionEntry = super.basicPutEntry(event, lastModified);
            return regionEntry;
        }
        finally {
            this.endLocalWrite(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void basicUpdateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        Assert.assertTrue(!this.isTX());
        Assert.assertTrue(event.getOperation().isDistributed());
        this.beginLocalWrite(event);
        try {
            if (!this.hasSeenEvent(event)) {
                this.entries.updateEntryVersion(event);
            } else if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "BR.basicUpdateEntryVersion: this cache has already seen this event {}", event);
            }
            if (!event.isOriginRemote() && this.getBucketAdvisor().isPrimary()) {
                new UpdateEntryVersionOperation(event).distribute();
            }
            return;
        }
        finally {
            this.endLocalWrite(event);
        }
    }

    public int getRedundancyLevel() {
        return this.redundancy;
    }

    @Override
    public boolean isPrimary() {
        throw new UnsupportedOperationException(LocalizedStrings.BucketRegion_THIS_SHOULD_NEVER_BE_CALLED_ON_0.toLocalizedString(this.getClass()));
    }

    @Override
    public boolean isDestroyed() {
        return this.isBucketDestroyed() || this.partitionedRegion != null && this.partitionedRegion.isLocallyDestroyed && !this.isInDestroyingThread();
    }

    public boolean isBucketDestroyed() {
        return super.isDestroyed();
    }

    @Override
    public void checkReadiness() {
        super.checkReadiness();
        if (this.isDestroyed()) {
            throw new RegionDestroyedException(this.toString(), this.getFullPath());
        }
    }

    @Override
    public PartitionedRegion getPartitionedRegion() {
        return this.partitionedRegion;
    }

    private final boolean isInDestroyingThread() {
        return this.partitionedRegion.locallyDestroyingThread == Thread.currentThread();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        super.fillInProfile(profile);
        BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)profile;
        bp.isInitializing = this.initializationLatchAfterGetInitialImage.getCount() > 0L;
    }

    public boolean isPartitionedRegionOpen() {
        return !this.partitionedRegion.isLocallyDestroyed && !this.partitionedRegion.isClosed && !this.partitionedRegion.isDestroyed();
    }

    private RawValue getSerialized(Object key2, boolean updateStats, boolean doNotLockEntry, EntryEventImpl clientEvent, boolean returnTombstones) throws EntryNotFoundException, IOException {
        RegionEntry re = this.entries.getEntry(key2);
        if (re == null) {
            return NULLVALUE;
        }
        if (re.isTombstone() && !returnTombstones) {
            return NULLVALUE;
        }
        Object v = null;
        try {
            VersionStamp stamp;
            v = re.getValue(this);
            if (doNotLockEntry && (v == Token.NOT_AVAILABLE || v == null)) {
                return REQUIRES_ENTRY_LOCK;
            }
            if (clientEvent != null && (stamp = re.getVersionStamp()) != null) {
                clientEvent.setVersionTag(stamp.asVersionTag());
            }
        }
        catch (DiskAccessException dae) {
            this.handleDiskAccessException(dae);
            throw dae;
        }
        if (v == null) {
            return NULLVALUE;
        }
        if (updateStats) {
            this.updateStatsForGet(re, true);
        }
        return new RawValue(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawValue getSerialized(KeyInfo keyInfo, boolean generateCallbacks, boolean doNotLockEntry, EntryEventImpl clientEvent, boolean returnTombstones) throws IOException {
        this.checkReadiness();
        this.checkForNoAccess();
        CachePerfStats stats = this.getCachePerfStats();
        long start = stats.startGet();
        boolean miss = true;
        try {
            RawValue valueBytes = NULLVALUE;
            boolean isCreate = false;
            RawValue result = this.getSerialized(keyInfo.getKey(), true, doNotLockEntry, clientEvent, returnTombstones);
            isCreate = result == NULLVALUE || result.getRawValue() == Token.TOMBSTONE && !returnTombstones;
            boolean bl = miss = result == NULLVALUE || Token.isInvalid(result.getRawValue());
            if (miss) {
                if (this.hasServerProxy() || this.basicGetLoader() != null) {
                    if (doNotLockEntry) {
                        RawValue rawValue = REQUIRES_ENTRY_LOCK;
                        return rawValue;
                    }
                    Object value2 = this.nonTxnFindObject(keyInfo, isCreate, generateCallbacks, result.getRawValue(), true, true, clientEvent, false);
                    if (value2 != null) {
                        result = new RawValue(value2);
                    }
                } else if (isCreate) {
                    this.recordMiss(null, keyInfo.getKey());
                }
            }
            RawValue rawValue = result;
            return rawValue;
        }
        finally {
            stats.endGet(start, miss);
        }
    }

    @Override
    public String toString() {
        return "BucketRegion" + "[path='" + this.getFullPath() + ";serial=" + this.getSerialNumber() + ";primary=" + this.getBucketAdvisor().getProxyBucketRegion().isPrimary() + ";indexUpdater=" + this.getIndexUpdater() + "]";
    }

    @Override
    protected void distributedRegionCleanup(RegionEventImpl event) {
        this.distAdvisor.removeMembershipListener(this.advisorListener);
    }

    public void removeFromPeersAdvisors(boolean rebalance2) {
        if (this.getPersistenceAdvisor() != null) {
            this.getPersistenceAdvisor().releaseTieLock();
        }
        DiskRegion diskRegion = this.getDiskRegion();
        boolean shouldDestroy = rebalance2 || diskRegion == null || !diskRegion.isRecreated();
        Operation op = shouldDestroy ? Operation.REGION_LOCAL_DESTROY : Operation.REGION_CLOSE;
        RegionEventImpl event = new RegionEventImpl((Region)this, op, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        if (this.isPartitionedRegionOpen()) {
            if (diskRegion != null && shouldDestroy) {
                diskRegion.beginDestroyDataStorage();
            }
            new DestroyRegionOperation(event, true).distribute();
        }
    }

    @Override
    protected void distributeDestroyRegion(RegionEventImpl event, boolean notifyOfRegionDeparture) {
    }

    EntryEventImpl createEventForPR(EntryEventImpl sourceEvent) {
        EntryEventImpl e2 = new EntryEventImpl(sourceEvent);
        e2.setRegion(this.partitionedRegion);
        if (FORCE_LOCAL_LISTENERS_INVOCATION) {
            e2.setInvokePRCallbacks(true);
        } else {
            e2.setInvokePRCallbacks(sourceEvent.getInvokePRCallbacks());
        }
        InternalDistributedMember dm = this.getDistributionManager().getDistributionManagerId();
        e2.setOriginRemote(!e2.getDistributedMember().equals(dm));
        return e2;
    }

    @Override
    public void invokeTXCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        if (logger.isDebugEnabled()) {
            logger.debug("BR.invokeTXCallbacks for event {}", event);
        }
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (event.isPossibleDuplicate() && this.eventTracker.isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokeTXCallbacks(eventType, event, callThem);
        }
        EntryEventImpl prevent = this.createEventForPR(event);
        this.partitionedRegion.invokeTXCallbacks(eventType, prevent, this.partitionedRegion.isInitialized() ? callDispatchListenerEvent : false);
    }

    @Override
    public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (event.isPossibleDuplicate() && this.eventTracker.isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokeDestroyCallbacks(eventType, event, callThem, notifyGateways);
        }
        EntryEventImpl prevent = this.createEventForPR(event);
        this.partitionedRegion.invokeDestroyCallbacks(eventType, prevent, this.partitionedRegion.isInitialized() ? callDispatchListenerEvent : false, false);
    }

    @Override
    public void invokeInvalidateCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (event.isPossibleDuplicate() && this.eventTracker.isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokeInvalidateCallbacks(eventType, event, callThem);
        }
        EntryEventImpl prevent = this.createEventForPR(event);
        this.partitionedRegion.invokeInvalidateCallbacks(eventType, prevent, this.partitionedRegion.isInitialized() ? callDispatchListenerEvent : false);
    }

    @Override
    public void invokePutCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (logger.isTraceEnabled()) {
            logger.trace("invoking put callbacks on bucket for event {}", event);
        }
        if (this.isInitialized()) {
            boolean callThem = callDispatchListenerEvent;
            if (callThem && event.isPossibleDuplicate() && this.eventTracker.isInitialImageProvider(event.getDistributedMember())) {
                callThem = false;
            }
            super.invokePutCallbacks(eventType, event, callThem, notifyGateways);
        }
        EntryEventImpl prevent = this.createEventForPR(event);
        this.partitionedRegion.invokePutCallbacks(eventType, prevent, this.partitionedRegion.isInitialized() ? callDispatchListenerEvent : false, false);
    }

    protected Set performAdjunctMessaging(EntryEventImpl event, Set cacheOpRecipients, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, DirectReplyProcessor processor, boolean calculateDelta, boolean sendDeltaWithFullValue) {
        Set failures = Collections.EMPTY_SET;
        PartitionMessage msg = event.getPartitionMessage();
        if (calculateDelta) {
            this.setDeltaIfNeeded(event);
        }
        if (msg != null) {
            msg = msg.getMessageForRelayToListeners(event, adjunctRecipients);
            msg.setSender(this.partitionedRegion.getDistributionManager().getDistributionManagerId());
            msg.setSendDeltaWithFullValue(sendDeltaWithFullValue);
            failures = msg.relayToListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, event, this.partitionedRegion, processor);
        } else {
            Operation op = event.getOperation();
            failures = op.isCreate() || op.isUpdate() ? PutMessage.notifyListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, this.partitionedRegion, event, op.isCreate(), !op.isCreate(), processor, sendDeltaWithFullValue) : (op.isDestroy() ? DestroyMessage.notifyListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, this.partitionedRegion, event, processor) : (op.isInvalidate() ? InvalidateMessage.notifyListeners(cacheOpRecipients, adjunctRecipients, filterRoutingInfo, this.partitionedRegion, event, processor) : adjunctRecipients));
        }
        return failures;
    }

    private void setDeltaIfNeeded(EntryEventImpl event) {
        if (this.partitionedRegion.getSystem().getConfig().getDeltaPropagation() && event.getOperation().isUpdate() && event.getDeltaBytes() == null) {
            Object rawNewValue = event.getRawNewValue();
            if (!(rawNewValue instanceof CachedDeserializable)) {
                return;
            }
            Object instance = ((CachedDeserializable)rawNewValue).getValue();
            if (instance instanceof Delta && ((Delta)instance).hasDelta()) {
                try {
                    HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                    long start = DistributionStats.getStatTime();
                    ((Delta)instance).toDelta(hdos);
                    event.setDeltaBytes(hdos.toByteArray());
                    this.partitionedRegion.getCachePerfStats().endDeltaPrepared(start);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new DeltaSerializationException(LocalizedStrings.DistributionManager_CAUGHT_EXCEPTION_WHILE_SENDING_DELTA.toLocalizedString(), e);
                }
            }
        }
    }

    public Set performPutAllAdjunctMessaging(DistributedPutAllOperation dpao, Set cacheOpRecipients, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, DirectReplyProcessor processor) {
        PutAllPRMessage prMsg = dpao.createPRMessagesNotifyOnly(this.getId());
        prMsg.initMessage(this.partitionedRegion, adjunctRecipients, true, processor);
        prMsg.setSender(this.partitionedRegion.getDistributionManager().getDistributionManagerId());
        HashSet<InternalDistributedMember> recipients = null;
        Set<InternalDistributedMember> membersWithRouting = filterRoutingInfo.getMembers();
        for (InternalDistributedMember mbr : membersWithRouting) {
            if (cacheOpRecipients.contains(mbr) || adjunctRecipients.contains(mbr) || recipients != null) continue;
            recipients = new HashSet<InternalDistributedMember>();
            recipients.add(mbr);
        }
        if (recipients == null) {
            recipients = adjunctRecipients;
        } else {
            recipients.addAll(adjunctRecipients);
        }
        Set failures = this.partitionedRegion.getDistributionManager().putOutgoing(prMsg);
        return failures;
    }

    public Set performRemoveAllAdjunctMessaging(DistributedRemoveAllOperation op, Set cacheOpRecipients, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, DirectReplyProcessor processor) {
        RemoveAllPRMessage prMsg = op.createPRMessagesNotifyOnly(this.getId());
        prMsg.initMessage(this.partitionedRegion, adjunctRecipients, true, processor);
        prMsg.setSender(this.partitionedRegion.getDistributionManager().getDistributionManagerId());
        HashSet<InternalDistributedMember> recipients = null;
        Set<InternalDistributedMember> membersWithRouting = filterRoutingInfo.getMembers();
        for (InternalDistributedMember mbr : membersWithRouting) {
            if (cacheOpRecipients.contains(mbr) || adjunctRecipients.contains(mbr) || recipients != null) continue;
            recipients = new HashSet<InternalDistributedMember>();
            recipients.add(mbr);
        }
        if (recipients == null) {
            recipients = adjunctRecipients;
        } else {
            recipients.addAll(adjunctRecipients);
        }
        Set failures = this.partitionedRegion.getDistributionManager().putOutgoing(prMsg);
        return failures;
    }

    protected Set getAdjunctReceivers(EntryEventImpl event, Set cacheOpReceivers, Set twoMessages, FilterRoutingInfo routing) {
        Operation op = event.getOperation();
        if (op.isUpdate() || op.isCreate() || op.isDestroy() || op.isInvalidate()) {
            HashSet<InternalDistributedMember> r = this.partitionedRegion.getRegionAdvisor().adviseRequiresNotification(event);
            if (r.size() > 0) {
                r.removeAll(cacheOpReceivers);
            }
            if (twoMessages.size() > 0) {
                if (r.size() == 0) {
                    r = twoMessages;
                } else {
                    r.addAll(twoMessages);
                }
            }
            if (routing != null) {
                for (InternalDistributedMember id : routing.getMembers()) {
                    if (cacheOpReceivers.contains(id)) continue;
                    if (r.isEmpty()) {
                        r = new HashSet<InternalDistributedMember>();
                    }
                    r.add(id);
                }
            }
            return r;
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public final int getId() {
        return this.getBucketAdvisor().getProxyBucketRegion().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cacheWriteBeforePut(EntryEventImpl event, Set netWriteRecipients, CacheWriter localWriter, boolean requireOldValue, Object expectedOldValue) throws CacheWriterException, TimeoutException {
        boolean origRemoteState = false;
        try {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                origRemoteState = event.isOriginRemote();
                event.setOriginRemote(true);
            }
            event.setRegion(this.partitionedRegion);
            this.partitionedRegion.cacheWriteBeforePut(event, netWriteRecipients, localWriter, requireOldValue, expectedOldValue);
        }
        finally {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                event.setOriginRemote(origRemoteState);
            }
            event.setRegion(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean cacheWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean origRemoteState = false;
        boolean ret = false;
        try {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                origRemoteState = event.isOriginRemote();
                event.setOriginRemote(true);
            }
            event.setRegion(this.partitionedRegion);
            ret = this.partitionedRegion.cacheWriteBeforeDestroy(event, expectedOldValue);
        }
        finally {
            if (event.getPartitionMessage() != null || event.hasClientOrigin()) {
                event.setOriginRemote(origRemoteState);
            }
            event.setRegion(this);
        }
        return ret;
    }

    @Override
    public CacheWriter basicGetWriter() {
        return this.partitionedRegion.basicGetWriter();
    }

    @Override
    void cleanUpOnIncompleteOp(EntryEventImpl event, RegionEntry re, boolean eventRecorded, boolean updateStats, boolean isReplace) {
        if (!eventRecorded || isReplace) {
            this.entries.removeEntry(event.getKey(), re, updateStats);
        }
    }

    @Override
    public Set getBucketOwners() {
        return this.getBucketAdvisor().getProxyBucketRegion().getBucketOwners();
    }

    public long getCounter() {
        return this.counter.get();
    }

    public void setCounter(AtomicLong counter) {
        this.counter = counter;
    }

    public void updateCounter(long delta) {
        if (delta != 0L) {
            this.counter.getAndAdd(delta);
        }
    }

    public void resetCounter() {
        if (this.counter.get() != 0L) {
            this.counter.set(0L);
        }
    }

    public long getLimit() {
        if (this.limit == null) {
            return 0L;
        }
        return this.limit.get();
    }

    public void setLimit(long limit) {
        if (this.limit == null) {
            this.limit = new AtomicLong();
        }
        this.limit.set(limit);
    }

    static int calcMemSize(Object value2) {
        if (value2 != null && value2 instanceof GatewaySenderEventImpl) {
            value2 = ((GatewaySenderEventImpl)value2).getValue();
        }
        if (value2 == null || value2 instanceof Token) {
            return 0;
        }
        if (!(value2 instanceof byte[] || value2 instanceof CachedDeserializable || value2 instanceof Delta || value2 instanceof com.gemstone.gemfire.internal.cache.delta.Delta)) {
            throw new InternalGemFireError("DEBUG: calcMemSize: weird value (class " + value2.getClass() + "): " + value2);
        }
        try {
            return CachedDeserializableFactory.calcMemSize(value2);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    @Override
    protected void updateSizeOnClearRegion(int sizeBeforeClear) {
        long oldMemValue;
        PartitionedRegionDataStore prDs = this.partitionedRegion.getDataStore();
        if (this.isDestroyed || this.isDestroyingDiskRegion) {
            oldMemValue = this.bytesInMemory.getAndSet(Long.MIN_VALUE);
        } else if (!this.isInitialized()) {
            oldMemValue = this.bytesInMemory.getAndSet(0L);
        } else {
            throw new InternalGemFireError("Trying to clear a bucket region that was not destroyed or in initialization.");
        }
        if (oldMemValue != Long.MIN_VALUE) {
            this.partitionedRegion.getPrStats().incDataStoreEntryCount(-sizeBeforeClear);
            prDs.updateMemoryStats(-oldMemValue);
        }
    }

    @Override
    public int calculateValueSize(Object val) {
        return BucketRegion.calcMemSize(val);
    }

    @Override
    public int calculateRegionEntryValueSize(RegionEntry re) {
        return BucketRegion.calcMemSize(re._getValue());
    }

    @Override
    void updateSizeOnPut(Object key2, int oldSize, int newSize) {
        this.updateBucket2Size(oldSize, newSize, SizeOp.UPDATE);
    }

    @Override
    void updateSizeOnCreate(Object key2, int newSize) {
        this.partitionedRegion.getPrStats().incDataStoreEntryCount(1);
        this.updateBucket2Size(0, newSize, SizeOp.CREATE);
    }

    @Override
    void updateSizeOnRemove(Object key2, int oldSize) {
        this.partitionedRegion.getPrStats().incDataStoreEntryCount(-1);
        this.updateBucket2Size(oldSize, 0, SizeOp.DESTROY);
    }

    @Override
    int updateSizeOnEvict(Object key2, int oldSize) {
        int newDiskSize = oldSize;
        this.updateBucket2Size(oldSize, newDiskSize, SizeOp.EVICT);
        return newDiskSize;
    }

    @Override
    public void updateSizeOnFaultIn(Object key2, int newMemSize, int oldDiskSize) {
        this.updateBucket2Size(oldDiskSize, newMemSize, SizeOp.FAULT_IN);
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        super.initializeStats(numEntriesInVM, numOverflowOnDisk, numOverflowBytesOnDisk);
        this.incNumEntriesInVM(numEntriesInVM);
        this.incNumOverflowOnDisk(numOverflowOnDisk);
        this.incNumOverflowBytesOnDisk(numOverflowBytesOnDisk);
    }

    @Override
    protected void setHeapThresholdFlag(MemoryEvent event) {
        Assert.assertTrue(false);
    }

    @Override
    public void initialCriticalMembers(boolean localHeapIsCritical, Set<InternalDistributedMember> critialMembers) {
    }

    @Override
    protected void closeCallbacksExceptListener() {
        this.closeCacheCallback(this.getCacheWriter());
        this.closeCacheCallback(this.getEvictionController());
    }

    public long getTotalBytes() {
        long result = this.bytesInMemory.get();
        if (result == Long.MIN_VALUE) {
            return 0L;
        }
        return result += this.getNumOverflowBytesOnDisk();
    }

    public void preDestroyBucket(int bucketId) {
        IndexUpdater indexUpdater = this.getIndexUpdater();
        if (indexUpdater != null) {
            indexUpdater.clearIndexes(this, bucketId);
        }
    }

    protected void invokePartitionListenerAfterBucketRemoved() {
        PartitionListener[] partitionListeners = this.getPartitionedRegion().getPartitionListeners();
        if (partitionListeners == null || partitionListeners.length == 0) {
            return;
        }
        for (int i = 0; i < partitionListeners.length; ++i) {
            PartitionListener listener = partitionListeners[i];
            if (listener == null) continue;
            listener.afterBucketRemoved(this.getId(), this.keySet());
        }
    }

    protected void invokePartitionListenerAfterBucketCreated() {
        PartitionListener[] partitionListeners = this.getPartitionedRegion().getPartitionListeners();
        if (partitionListeners == null || partitionListeners.length == 0) {
            return;
        }
        for (int i = 0; i < partitionListeners.length; ++i) {
            PartitionListener listener = partitionListeners[i];
            if (listener == null) continue;
            listener.afterBucketCreated(this.getId(), this.keySet());
        }
    }

    void updateBucket2Size(int oldSize, int newSize, SizeOp op) {
        int memoryDelta = op.computeMemoryDelta(oldSize, newSize);
        if (memoryDelta == 0) {
            return;
        }
        this.updateBucketMemoryStats(memoryDelta);
    }

    void updateBucketMemoryStats(int memoryDelta) {
        if (memoryDelta != 0) {
            long bSize = this.bytesInMemory.compareAddAndGet(Long.MIN_VALUE, memoryDelta);
            if (bSize == Long.MIN_VALUE) {
                return;
            }
            if (bSize < 0L && this.getCancelCriterion().cancelInProgress() == null) {
                throw new InternalGemFireError("Bucket " + this + " size (" + bSize + ") negative after applying delta of " + memoryDelta);
            }
        }
        PartitionedRegionDataStore prDS = this.partitionedRegion.getDataStore();
        prDS.updateMemoryStats(memoryDelta);
    }

    public long getNumOverflowOnDisk() {
        return this.numOverflowOnDisk.get();
    }

    public long getNumOverflowBytesOnDisk() {
        return this.numOverflowBytesOnDisk.get();
    }

    public long getNumEntriesInVM() {
        return this.numEntriesInVM.get();
    }

    void incNumOverflowOnDisk(long delta) {
        this.numOverflowOnDisk.addAndGet(delta);
    }

    void incNumOverflowBytesOnDisk(long delta) {
        if (delta == 0L) {
            return;
        }
        this.numOverflowBytesOnDisk.addAndGet(delta);
    }

    void incNumEntriesInVM(long delta) {
        this.numEntriesInVM.addAndGet(delta);
    }

    public void incEvictions(long delta) {
        this.evictions.getAndAdd(delta);
    }

    public long getEvictions() {
        return this.evictions.get();
    }

    @Override
    protected boolean isHeapThresholdReachedForLoad() {
        return this.getBucketAdvisor().getProxyBucketRegion().isBucketSick();
    }

    public int getSizeForEviction() {
        EvictionAttributes ea = this.getAttributes().getEvictionAttributes();
        if (ea == null) {
            return 0;
        }
        EvictionAlgorithm algo = ea.getAlgorithm();
        if (!algo.isLRUHeap()) {
            return 0;
        }
        EvictionAction action = ea.getAction();
        int size2 = action.isLocalDestroy() ? this.getRegionMap().sizeInVM() : (int)this.getNumEntriesInVM();
        return size2;
    }

    @Override
    public HashMap getDestroyedSubregionSerialNumbers() {
        return new HashMap(0);
    }

    @Override
    public FilterProfile getFilterProfile() {
        return this.partitionedRegion.getFilterProfile();
    }

    @Override
    protected void generateLocalFilterRouting(InternalCacheEvent event) {
        if (event.getLocalFilterInfo() == null) {
            super.generateLocalFilterRouting(event);
        }
    }

    public void beforeAcquiringPrimaryState() {
    }

    public void afterAcquiringPrimaryState() {
    }

    @Override
    public RegionAttributes getAttributes() {
        return this;
    }

    static enum SizeOp {
        UPDATE,
        CREATE,
        DESTROY,
        EVICT,
        FAULT_IN;


        int computeMemoryDelta(int oldSize, int newSize) {
            switch (this) {
                case CREATE: {
                    return newSize;
                }
                case DESTROY: {
                    return -oldSize;
                }
                case UPDATE: {
                    return newSize - oldSize;
                }
                case EVICT: {
                    return -oldSize;
                }
                case FAULT_IN: {
                    return newSize;
                }
            }
            throw new AssertionError((Object)("unhandled sizeOp: " + (Object)((Object)this)));
        }
    }

    public static final class RawValue {
        private final Object rawValue;

        public RawValue(Object rawVal) {
            this.rawValue = rawVal;
        }

        public final boolean isValueByteArray() {
            return this.rawValue instanceof byte[];
        }

        public Object getRawValue() {
            return this.rawValue;
        }

        public void writeAsByteArray(DataOutput out) throws IOException {
            if (this.isValueByteArray()) {
                DataSerializer.writeByteArray((byte[])this.rawValue, out);
            } else if (this.rawValue instanceof CachedDeserializable) {
                ((CachedDeserializable)this.rawValue).writeValueAsByteArray(out);
            } else if (Token.isInvalid(this.rawValue)) {
                DataSerializer.writeByteArray(null, out);
            } else if (this.rawValue == Token.TOMBSTONE) {
                DataSerializer.writeByteArray(null, out);
            } else {
                DataSerializer.writeObjectAsByteArray(this.rawValue, out);
            }
        }

        public String toString() {
            return "RawValue(" + this.rawValue + ")";
        }

        public Object getDeserialized(boolean copyOnRead) {
            if (this.isValueByteArray()) {
                if (copyOnRead) {
                    byte[] src = (byte[])this.rawValue;
                    byte[] dest = new byte[src.length];
                    System.arraycopy(this.rawValue, 0, dest, 0, dest.length);
                    return dest;
                }
                return this.rawValue;
            }
            if (this.rawValue instanceof CachedDeserializable) {
                if (copyOnRead) {
                    return ((CachedDeserializable)this.rawValue).getDeserializedWritableCopy(null, null);
                }
                return ((CachedDeserializable)this.rawValue).getDeserializedForReading();
            }
            if (Token.isInvalid(this.rawValue)) {
                return null;
            }
            if (copyOnRead) {
                return CopyHelper.copy(this.rawValue);
            }
            return this.rawValue;
        }
    }
}

