/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class BridgeEventConflator {
    private static final Logger logger = LogService.getLogger();
    protected Map _latestValues;
    protected Object _latestValuesLock = new Object();

    public BridgeEventConflator() {
        this._latestValues = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeLatestValue(Conflatable object) {
        boolean shouldAddToQueue = true;
        if (object.shouldBeConflated()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Conflating {}", this, object);
            }
            String regionName = object.getRegionToConflate();
            Object key2 = object.getKeyToConflate();
            Object object2 = this._latestValuesLock;
            synchronized (object2) {
                HashMap<Object, Object> latestValuesForRegion = (HashMap<Object, Object>)this._latestValues.get(regionName);
                if (latestValuesForRegion == null) {
                    latestValuesForRegion = new HashMap<Object, Object>();
                    this._latestValues.put(regionName, latestValuesForRegion);
                    shouldAddToQueue = true;
                } else {
                    boolean bl = shouldAddToQueue = !latestValuesForRegion.containsKey(key2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Replacing value={} with value={} for key={} in latest values map for {}", this, this.deserialize(latestValuesForRegion.get(key2)), this.deserialize(object.getValueToConflate()), key2, regionName);
                }
                latestValuesForRegion.put(key2, object.getValueToConflate());
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Not conflating {}", this, object);
            }
            shouldAddToQueue = true;
        }
        return shouldAddToQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLatestValue(Conflatable object) {
        if (!object.shouldBeConflated()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} already has latest value", this, object);
            }
            return (byte[])object.getValueToConflate();
        }
        String regionName = object.getRegionToConflate();
        Object key2 = object.getKeyToConflate();
        byte[] latestValue = null;
        Object object2 = this._latestValuesLock;
        synchronized (object2) {
            Map latestValuesForRegion = (Map)this._latestValues.get(regionName);
            if (latestValuesForRegion != null) {
                latestValue = (byte[])latestValuesForRegion.remove(key2);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: {} using latest value: {}", this, object, this.deserialize(latestValue));
                }
                if (latestValue == null) {
                    latestValue = (byte[])object.getValueToConflate();
                }
            }
        }
        return latestValue;
    }

    public String toString() {
        return "BridgeEventConflator";
    }

    protected Object deserialize(Object value2) {
        Object deserializedObject = value2;
        try {
            if (value2 instanceof byte[]) {
                byte[] serializedBytes = (byte[])value2;
                deserializedObject = EntryEventImpl.deserialize(serializedBytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedObject;
    }
}

