/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BackupLock
extends ReentrantLock {
    private Thread backupThread;
    boolean isBackingUp;
    Condition backupDone = super.newCondition();

    public void lockForBackup() {
        super.lock();
        this.isBackingUp = true;
        super.unlock();
    }

    public void setBackupThread(Thread thread) {
        super.lock();
        this.backupThread = thread;
        super.unlock();
    }

    public void unlockForBackup() {
        super.lock();
        this.isBackingUp = false;
        this.backupThread = null;
        this.backupDone.signalAll();
        super.unlock();
    }

    @Override
    public void lock() {
        this.lock(true);
    }

    public void lock(boolean waitForBackup) {
        super.lock();
        while (this.isBackingUp && waitForBackup && Thread.currentThread() != this.backupThread) {
            this.backupDone.awaitUninterruptibly();
        }
    }
}

