/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.SearchLoadAndWriteProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.util.Set;

class AcceptHelper {
    public ServerSocketChannel ackServerChannel;
    public ServerSocketChannel nackServerChannel;
    public int ackPort = 0;
    public int nackPort = 0;
    public Set relevantIdSet;
    public SearchLoadAndWriteProcessor processor;
    public SelectionKey ackSelKey;
    public SelectionKey nackSelKey;
    public boolean closed = false;

    public void close() {
        try {
            if (this.ackServerChannel != null) {
                this.ackServerChannel.close();
            }
            this.nackServerChannel.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.closed = true;
    }

    public synchronized void reset(boolean ackPortInit) {
        try {
            InetSocketAddress addr;
            if (ackPortInit) {
                this.ackServerChannel = ServerSocketChannel.open();
                this.ackServerChannel.configureBlocking(false);
                this.ackServerChannel.socket().bind(null, 1);
                addr = (InetSocketAddress)this.ackServerChannel.socket().getLocalSocketAddress();
                this.ackPort = addr.getPort();
            } else {
                this.ackServerChannel = null;
            }
            this.nackServerChannel = ServerSocketChannel.open();
            this.nackServerChannel.configureBlocking(false);
            this.nackServerChannel.socket().bind(null, 1);
            addr = (InetSocketAddress)this.nackServerChannel.socket().getLocalSocketAddress();
            this.nackPort = addr.getPort();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.closed = false;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

