/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBucketRegionQueue
extends BucketRegion {
    private static final Logger logger = LogService.getLogger();
    private final long maximumSize = 0x100000L * Long.getLong("gemfire.GATEWAY_QUEUE_THROTTLE_SIZE_MB", -1L);
    private final long throttleTime = Long.getLong("gemfire.GATEWAY_QUEUE_THROTTLE_TIME_MS", 100L);
    private final LRUStatistics stats;
    private final ReentrantReadWriteLock initializationLock = new ReentrantReadWriteLock();
    private final GatewaySenderStats gatewaySenderStats;
    protected volatile boolean initialized = false;
    private final ConcurrentHashSet<Object> failedBatchRemovalMessageKeys = new ConcurrentHashSet();

    public AbstractBucketRegionQueue(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.stats = ((AbstractLRURegionMap)this.getRegionMap()).getLRUStatistics();
        this.gatewaySenderStats = this.getPartitionedRegion().getParallelGatewaySender().getStatistics();
    }

    @Override
    public boolean supportsConcurrencyChecks() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitIfQueueFull() {
        if (this.maximumSize <= 0L) {
            return;
        }
        if (this.stats.getCounter() > this.maximumSize) {
            try {
                LRUStatistics lRUStatistics = this.stats;
                synchronized (lRUStatistics) {
                    this.stats.wait(this.throttleTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEntriesRemoved() {
        if (this.maximumSize > 0L) {
            LRUStatistics lRUStatistics = this.stats;
            synchronized (lRUStatistics) {
                this.stats.notifyAll();
            }
        }
    }

    @Override
    protected void distributeUpdateOperation(EntryEventImpl event, long lastModified) {
    }

    @Override
    protected boolean needWriteLock(EntryEventImpl event) {
        return false;
    }

    @Override
    protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
        return System.currentTimeMillis();
    }

    @Override
    protected void basicDestroyBeforeRemoval(RegionEntry entry, EntryEventImpl event) {
        if (logger.isDebugEnabled()) {
            logger.debug("For Key {}, BasicDestroyBeforeRemoval: no need to send destroy operation to remote nodes. This will be done using BatchRemoval Message.", event.getKey());
        }
    }

    @Override
    protected void distributeDestroyOperation(EntryEventImpl event) {
    }

    @Override
    protected void updateSizeOnClearRegion(int sizeBeforeClear) {
    }

    public ReentrantReadWriteLock getInitializationLock() {
        return this.initializationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyKey(Object key2) throws ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug(" destroying primary key {}", key2);
        }
        EntryEventImpl event = this.getPartitionedRegion().newDestroyEntryEvent(key2, null);
        event.setEventId(new EventID(this.cache.getSystem()));
        try {
            event.setRegion(this);
            this.basicDestroy(event, true, null);
            this.checkReadiness();
        }
        catch (EntryNotFoundException enf) {
            if (this.getPartitionedRegion().isDestroyed()) {
                this.getPartitionedRegion().checkReadiness();
                if (this.isBucketDestroyed()) {
                    throw new ForceReattemptException("Bucket moved", new RegionDestroyedException(LocalizedStrings.PartitionedRegionDataStore_REGION_HAS_BEEN_DESTROYED.toLocalizedString(), this.getPartitionedRegion().getFullPath()));
                }
            }
            throw enf;
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved while destroying key " + key2, rde);
            }
        }
        this.notifyEntriesRemoved();
    }

    public void decQueueSize(int size2) {
        this.gatewaySenderStats.decQueueSize(size2);
    }

    public void decQueueSize() {
        this.gatewaySenderStats.decQueueSize();
    }

    public void incQueueSize(int size2) {
        this.gatewaySenderStats.incQueueSize(size2);
    }

    public void incQueueSize() {
        this.gatewaySenderStats.incQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadEventsFromTempQueue() {
        Set<RegionQueue> queues;
        if (logger.isDebugEnabled()) {
            logger.debug("For bucket {} about to load events from the temp queue...", this.getId());
        }
        if ((queues = this.getPartitionedRegion().getParallelGatewaySender().getQueues()) == null) return;
        ConcurrentParallelGatewaySenderQueue prq = (ConcurrentParallelGatewaySenderQueue)queues.toArray()[0];
        BlockingQueue<GatewaySenderEventImpl> tempQueue = prq.getBucketTmpQueue(this.getId());
        if (tempQueue == null) return;
        if (tempQueue.isEmpty()) return;
        BlockingQueue<GatewaySenderEventImpl> blockingQueue = tempQueue;
        synchronized (blockingQueue) {
            try {
                GatewaySenderEventImpl event;
                this.getInitializationLock().writeLock().lock();
                while ((event = (GatewaySenderEventImpl)tempQueue.poll()) != null) {
                    try {
                        event.setPossibleDuplicate(true);
                        if (!this.addToQueue(event.getShadowKey(), event)) continue;
                        event = null;
                    }
                    catch (ForceReattemptException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("For bucket {} , enqueing event {} caused exception", this.getId(), event, e);
                    }
                }
                return;
            }
            finally {
                if (!tempQueue.isEmpty()) {
                    tempQueue.clear();
                }
                this.getInitializationLock().writeLock().unlock();
            }
        }
    }

    protected void markEventsAsDuplicate(int batchSize, Iterator itr) {
        for (int i = 0; i < batchSize && itr.hasNext(); ++i) {
            Object key2 = itr.next();
            Object senderEvent = this.getNoLRU(key2, true, false, false);
            if (senderEvent == null) continue;
            ((GatewaySenderEventImpl)senderEvent).setPossibleDuplicate(true);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Set possibleDuplicate to true on event: {}", senderEvent);
        }
    }

    @Override
    public void forceSerialized(EntryEventImpl event) {
    }

    @Override
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        boolean success = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        if (success && logger.isDebugEnabled()) {
            logger.debug("Key : ----> {}", event.getKey());
        }
        return success;
    }

    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        super.basicDestroy(event, cacheWrite, expectedOldValue);
    }

    public Collection<BucketRegion> getCorrespondingUserPRBuckets() {
        ArrayList<BucketRegion> userPRBuckets = new ArrayList<BucketRegion>(4);
        Map<String, PartitionedRegion> colocatedPRs = ColocationHelper.getAllColocationRegions(this.getPartitionedRegion());
        for (PartitionedRegion colocatedPR : colocatedPRs.values()) {
            BucketRegion parentBucket;
            if (colocatedPR.isShadowPR() || !this.isThisSenderAttached(colocatedPR) || (parentBucket = colocatedPR.getDataStore().getLocalBucketById(this.getId())) == null) continue;
            userPRBuckets.add(parentBucket);
        }
        return userPRBuckets;
    }

    private boolean isThisSenderAttached(PartitionedRegion pr2) {
        return pr2.getParallelGatewaySenderIds().contains(this.getPartitionedRegion().getParallelGatewaySender().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToQueue(Object key2, Object value2) throws ForceReattemptException {
        if (this.failedBatchRemovalMessageKeys.remove(key2)) {
            return false;
        }
        boolean didPut = false;
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = new EntryEventImpl((LocalRegion)this, Operation.UPDATE, key2, value2, null, false, this.getMyId());
        if (logger.isDebugEnabled()) {
            logger.debug("Value : {}", event.getRawNewValue());
        }
        this.waitIfQueueFull();
        try {
            didPut = this.virtualPut(event, false, false, null, false, startPut, true);
            this.checkReadiness();
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved", rde);
            }
        }
        if (this.failedBatchRemovalMessageKeys.remove(key2) && didPut) {
            this.destroyKey(key2);
            didPut = false;
        } else {
            this.addToEventQueue(key2, didPut, event);
        }
        return didPut;
    }

    protected abstract void clearQueues();

    protected abstract void addToEventQueue(Object var1, boolean var2, EntryEventImpl var3);

    @Override
    public void afterAcquiringPrimaryState() {
        super.afterAcquiringPrimaryState();
        this.notifyEventProcessor();
    }

    protected void notifyEventProcessor() {
        AbstractGatewaySenderEventProcessor ep;
        ParallelGatewaySenderImpl sender = this.getPartitionedRegion().getParallelGatewaySender();
        if (sender != null && (ep = sender.getEventProcessor()) != null) {
            ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue();
            if (logger.isDebugEnabled()) {
                logger.debug("notifyEventProcessor : {} event processor {} queue {}", sender, ep, queue);
            }
            queue.notifyEventProcessorIfRequired(this.getId());
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void addToFailedBatchRemovalMessageKeys(Object key2) {
        this.failedBatchRemovalMessageKeys.add(key2);
    }

    public ConcurrentHashSet<Object> getFailedBatchRemovalMessageKeys() {
        return this.failedBatchRemovalMessageKeys;
    }
}

