/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.statalerts;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.admin.StatAlert;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.admin.statalerts.BaseDecoratorImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class NumberThresholdDecoratorImpl
extends BaseDecoratorImpl
implements DataSerializableFixedID {
    private static final long serialVersionUID = -1799140125261894306L;
    protected Number threshold;
    protected boolean evalForGtThan;
    public static final String ID = "NumberThreshold";

    public NumberThresholdDecoratorImpl() {
    }

    public NumberThresholdDecoratorImpl(StatAlertDefinition definition, Number threshold, boolean evalForGtThan) {
        super(definition);
        this.threshold = threshold;
        this.evalForGtThan = evalForGtThan;
    }

    @Override
    public int getDSFID() {
        return 1073;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public boolean isGauge() {
        return false;
    }

    public boolean isEvalForGreaterThan() {
        return this.evalForGtThan;
    }

    @Override
    public boolean verify(StatisticsFactory factory) {
        return super.verify(factory) && null != this.threshold;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("Threshold Value:" + this.threshold + "\n");
        return buffer.toString();
    }

    @Override
    public boolean evaluate(Number[] params) {
        if (this.evalForGtThan) {
            return super.evaluate(params) && NumberThresholdDecoratorImpl.isGreaterThan(this.getValue(params)[0], this.threshold);
        }
        return super.evaluate(params) && NumberThresholdDecoratorImpl.isLessThan(this.getValue(params)[0], this.threshold);
    }

    @Override
    public boolean evaluate() {
        return this.evaluate(this.getValue());
    }

    @Override
    public StatAlert evaluateAndAlert(Number[] params) {
        return this.evaluate(params) ? super.evaluateAndAlert(params) : null;
    }

    @Override
    public StatAlert evaluateAndAlert() {
        return this.evaluate() ? super.evaluateAndAlert() : null;
    }

    @Override
    public Number[] getValue() {
        return super.getValue();
    }

    @Override
    public Number[] getValue(Number[] vals) {
        return super.getValue(vals);
    }

    @Override
    public boolean hasDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) || super.hasDecorator(decoratorID);
    }

    @Override
    public StatAlertDefinition getDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) ? this : super.getDecorator(decoratorID);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.threshold, out);
        DataSerializer.writePrimitiveBoolean(this.evalForGtThan, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.threshold = (Number)DataSerializer.readObject(in);
        this.evalForGtThan = DataSerializer.readPrimitiveBoolean(in);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

