/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminRegion;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CacheDisplay;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class SubRegionResponse
extends AdminResponse {
    String[] subRegionNames;
    String[] userAttributes;

    public static SubRegionResponse create(DistributionManager dm, InternalDistributedMember recipient, Region r) {
        SubRegionResponse m = new SubRegionResponse();
        m.setRecipient(recipient);
        Set<Region<?, ?>> subregions = r.subregions(false);
        ArrayList<String> subNames = new ArrayList<String>();
        ArrayList<Object> userAttrs = new ArrayList<Object>();
        for (Region<?, ?> reg : subregions) {
            subNames.add(reg.getName());
            userAttrs.add(CacheDisplay.getCachedObjectDisplay(reg.getUserAttribute(), 100));
        }
        String[] temp = new String[]{};
        m.subRegionNames = subNames.toArray(temp);
        m.userAttributes = userAttrs.toArray(temp);
        return m;
    }

    public Set getRegionSet(AdminRegion parent) {
        HashSet<AdminRegion> result = new HashSet<AdminRegion>(this.subRegionNames.length);
        for (int i = 0; i < this.subRegionNames.length; ++i) {
            result.add(new AdminRegion(this.subRegionNames[i], parent, this.userAttributes[i]));
        }
        return new HashSet(result);
    }

    @Override
    public int getDSFID() {
        return 1060;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.subRegionNames, out);
        DataSerializer.writeObject(this.userAttributes, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.subRegionNames = (String[])DataSerializer.readObject(in);
        this.userAttributes = (String[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "SubRegionResponse from " + this.getRecipient();
    }
}

