/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.internal.admin.CacheSnapshot;
import com.gemstone.gemfire.internal.admin.remote.RemoteGfManagerAgent;
import com.gemstone.gemfire.internal.admin.remote.RemoteRegionSnapshot;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class SnapshotResultMessage
extends PooledDistributionMessage
implements AdminMessageType {
    private CacheSnapshot results;
    private int snapshotId;

    public static SnapshotResultMessage create(Region region, int snapshotId) throws CacheException {
        SnapshotResultMessage m = new SnapshotResultMessage();
        m.results = new RemoteRegionSnapshot(region);
        m.snapshotId = snapshotId;
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        RemoteGfManagerAgent agent = dm.getAgent();
        if (agent != null) {
            agent.enqueueSnapshotResults(this);
        }
    }

    @Override
    public boolean sendViaJGroups() {
        return true;
    }

    public CacheSnapshot getSnapshot() {
        return this.results;
    }

    public int getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    public int getDSFID() {
        return 1055;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.results, out);
        out.writeInt(this.snapshotId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.results = (CacheSnapshot)DataSerializer.readObject(in);
        this.snapshotId = in.readInt();
    }
}

