/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AdminMultipleReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.ShutdownAllGatewayHubsResponse;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import java.util.Collection;

public class ShutdownAllGatewayHubsRequest
extends AdminRequest {
    @Override
    public boolean sendViaJGroups() {
        return true;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            cache.stopGatewayHubs(true);
            cache.stopGatewaySenders(true);
            cache.stopGatewayReceivers(true);
        }
        return new ShutdownAllGatewayHubsResponse(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 147;
    }

    @Override
    public String toString() {
        return "ShutdownAllGatewayHubsRequest sent to " + ArrayUtils.toString(this.getRecipients()) + " from " + this.getSender();
    }

    public static class ShutDownAllGatewayHubsReplyProcessor
    extends AdminMultipleReplyProcessor {
        public ShutDownAllGatewayHubsReplyProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }
    }
}

