/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RefreshMemberSnapshotResponse
extends AdminResponse {
    GemFireMemberStatus snapshot;

    public static RefreshMemberSnapshotResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RefreshMemberSnapshotResponse m = new RefreshMemberSnapshotResponse();
        m.setRecipient(recipient);
        try {
            InternalDistributedSystem sys = dm.getSystem();
            GemFireCacheImpl c = (GemFireCacheImpl)CacheFactory.getInstance(sys);
            m.snapshot = new GemFireMemberStatus(c);
        }
        catch (Exception ex) {
            m.snapshot = null;
        }
        return m;
    }

    public GemFireMemberStatus getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.snapshot, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.snapshot = (GemFireMemberStatus)DataSerializer.readObject(in);
    }

    @Override
    public int getDSFID() {
        return 1068;
    }

    @Override
    public String toString() {
        return "RefreshMemberSnapshotResponse from " + this.getRecipient() + " snapshot=" + this.snapshot;
    }
}

