/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.persistence.RevokeFailedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.admin.remote.AdminMultipleReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CliLegacyMessage;
import com.gemstone.gemfire.internal.admin.remote.RevokePersistentIDResponse;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class PrepareRevokePersistentIDRequest
extends CliLegacyMessage {
    PersistentMemberPattern pattern;
    private boolean cancel;

    public PrepareRevokePersistentIDRequest() {
    }

    public PrepareRevokePersistentIDRequest(PersistentMemberPattern pattern, boolean cancel) {
        this.pattern = pattern;
        this.cancel = cancel;
    }

    public static void cancel(DM dm, PersistentMemberPattern pattern) {
        PrepareRevokePersistentIDRequest.send(dm, pattern, true);
    }

    public static void send(DM dm, PersistentMemberPattern pattern) {
        PrepareRevokePersistentIDRequest.send(dm, pattern, false);
    }

    private static void send(DM dm, PersistentMemberPattern pattern, boolean cancel) {
        Set recipients = dm.getOtherDistributionManagerIds();
        recipients.remove(dm.getId());
        PrepareRevokePersistentIDRequest request = new PrepareRevokePersistentIDRequest(pattern, cancel);
        request.setRecipients(recipients);
        AdminMultipleReplyProcessor replyProcessor = new AdminMultipleReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof CancelException) {
                return;
            }
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        request.setSender(dm.getId());
        request.createResponse((DistributionManager)dm);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            PersistentMemberManager mm = cache.getPersistentMemberManager();
            if (this.cancel) {
                mm.cancelRevoke(this.pattern);
            } else if (!mm.prepareRevoke(this.pattern, dm, this.getSender())) {
                throw new RevokeFailedException(LocalizedStrings.RevokeFailedException_Member_0_is_already_running_1.toLocalizedString(dm.getId(), this.pattern));
            }
        }
        return new RevokePersistentIDResponse(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 2129;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.pattern = new PersistentMemberPattern();
        InternalDataSerializer.invokeFromData(this.pattern, in);
        this.cancel = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData(this.pattern, out);
        out.writeBoolean(this.cancel);
    }
}

