/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.Cancellable;
import com.gemstone.gemfire.internal.admin.remote.CancellationRegistry;
import com.gemstone.gemfire.internal.admin.remote.ObjectNamesResponse;
import com.gemstone.gemfire.internal.admin.remote.RegionAdminRequest;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ObjectNamesRequest
extends RegionAdminRequest
implements Cancellable {
    private transient boolean cancelled;
    private transient ObjectNamesResponse resp;

    public static ObjectNamesRequest create() {
        ObjectNamesRequest m = new ObjectNamesRequest();
        return m;
    }

    public ObjectNamesRequest() {
        this.friendlyName = LocalizedStrings.ObjectNamesRequest_LIST_CACHED_OBJECTS.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        CancellationRegistry.getInstance().registerMessage(this);
        this.resp = ObjectNamesResponse.create(dm, this.getSender());
        if (this.cancelled) {
            return null;
        }
        this.resp.buildNames(this.getRegion(dm.getSystem()));
        if (this.cancelled) {
            return null;
        }
        CancellationRegistry.getInstance().deregisterMessage(this);
        return this.resp;
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.resp != null) {
            this.resp.cancel();
        }
    }

    @Override
    public int getDSFID() {
        return 1039;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public String toString() {
        return "ObjectNamesRequest from " + this.getRecipient() + " region=" + this.getRegionName();
    }
}

