/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.RemoteStat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class FetchResourceAttributesResponse
extends AdminResponse {
    private RemoteStat[] stats;

    public static FetchResourceAttributesResponse create(DistributionManager dm, InternalDistributedMember recipient, long rsrcUniqueId) {
        FetchResourceAttributesResponse m = new FetchResourceAttributesResponse();
        m.setRecipient(recipient);
        Statistics s = null;
        InternalDistributedSystem ds = dm.getSystem();
        s = ds.findStatisticsByUniqueId(rsrcUniqueId);
        if (s != null) {
            StatisticsType type = s.getType();
            StatisticDescriptor[] tmp = type.getStatistics();
            m.stats = new RemoteStat[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                m.stats[i] = new RemoteStat(s, tmp[i]);
            }
        }
        if (m.stats == null) {
            m.stats = new RemoteStat[0];
        }
        return m;
    }

    public RemoteStat[] getStats() {
        return this.stats;
    }

    @Override
    public int getDSFID() {
        return 1028;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.stats, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.stats = (RemoteStat[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "FetchResourceAttributesResponse from " + this.getRecipient();
    }
}

