/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;

public class CompactResponse
extends AdminResponse {
    private HashSet<PersistentID> persistentIds;

    public CompactResponse() {
    }

    public CompactResponse(InternalDistributedMember sender, HashSet<PersistentID> persistentIds) {
        this.setRecipient(sender);
        this.persistentIds = persistentIds;
    }

    public HashSet<PersistentID> getPersistentIds() {
        return this.persistentIds;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.persistentIds = DataSerializer.readHashSet(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeHashSet(this.persistentIds, out);
    }

    public CompactResponse(InternalDistributedMember sender) {
        this.setRecipient(sender);
    }

    @Override
    public int getDSFID() {
        return 2119;
    }
}

