/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClientHealthStats
implements DataSerializableFixedID,
Serializable {
    private static final long serialVersionUID = 4229401714870332766L;
    protected int numOfGets;
    protected int numOfPuts;
    protected int numOfMisses;
    protected int numOfCacheListenerCalls;
    protected int numOfThreads;
    protected long processCpuTime;
    protected int cpus;
    protected Date updateTime;
    private HashMap<String, String> poolStats = new HashMap();
    private static final Version[] dsfidVersions = new Version[]{Version.GFE_80};

    public int getNumOfGets() {
        return this.numOfGets;
    }

    public void setNumOfGets(int numOfGets) {
        this.numOfGets = numOfGets;
    }

    public int getNumOfPuts() {
        return this.numOfPuts;
    }

    public void setNumOfPuts(int numOfPuts) {
        this.numOfPuts = numOfPuts;
    }

    public int getNumOfMisses() {
        return this.numOfMisses;
    }

    public void setNumOfMisses(int numOfMisses) {
        this.numOfMisses = numOfMisses;
    }

    public int getNumOfCacheListenerCalls() {
        return this.numOfCacheListenerCalls;
    }

    public void setNumOfCacheListenerCalls(int numOfCacheListenerCalls) {
        this.numOfCacheListenerCalls = numOfCacheListenerCalls;
    }

    public int getNumOfThreads() {
        return this.numOfThreads;
    }

    public void setNumOfThreads(int numOfThreads) {
        this.numOfThreads = numOfThreads;
    }

    public long getProcessCpuTime() {
        return this.processCpuTime;
    }

    public void setProcessCpuTime(long processCpuTime) {
        this.processCpuTime = processCpuTime;
    }

    public int getCpus() {
        return this.cpus;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writePrimitiveInt(this.numOfGets, out);
        DataSerializer.writePrimitiveInt(this.numOfPuts, out);
        DataSerializer.writePrimitiveInt(this.numOfMisses, out);
        DataSerializer.writePrimitiveInt(this.numOfCacheListenerCalls, out);
        DataSerializer.writePrimitiveInt(this.numOfThreads, out);
        DataSerializer.writePrimitiveInt(this.cpus, out);
        DataSerializer.writePrimitiveLong(this.processCpuTime, out);
        DataSerializer.writeDate(this.updateTime, out);
        DataSerializer.writeHashMap(this.poolStats, out);
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        DataSerializer.writePrimitiveInt(this.numOfGets, out);
        DataSerializer.writePrimitiveInt(this.numOfPuts, out);
        DataSerializer.writePrimitiveInt(this.numOfMisses, out);
        DataSerializer.writePrimitiveInt(this.numOfCacheListenerCalls, out);
        DataSerializer.writePrimitiveInt(this.numOfThreads, out);
        DataSerializer.writePrimitiveInt(this.cpus, out);
        DataSerializer.writePrimitiveLong(this.processCpuTime, out);
        DataSerializer.writeDate(this.updateTime, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.numOfGets = DataSerializer.readPrimitiveInt(in);
        this.numOfPuts = DataSerializer.readPrimitiveInt(in);
        this.numOfMisses = DataSerializer.readPrimitiveInt(in);
        this.numOfCacheListenerCalls = DataSerializer.readPrimitiveInt(in);
        this.numOfThreads = DataSerializer.readPrimitiveInt(in);
        this.cpus = DataSerializer.readPrimitiveInt(in);
        this.processCpuTime = DataSerializer.readPrimitiveLong(in);
        this.updateTime = DataSerializer.readDate(in);
        this.poolStats = DataSerializer.readHashMap(in);
    }

    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.numOfGets = DataSerializer.readPrimitiveInt(in);
        this.numOfPuts = DataSerializer.readPrimitiveInt(in);
        this.numOfMisses = DataSerializer.readPrimitiveInt(in);
        this.numOfCacheListenerCalls = DataSerializer.readPrimitiveInt(in);
        this.numOfThreads = DataSerializer.readPrimitiveInt(in);
        this.cpus = DataSerializer.readPrimitiveInt(in);
        this.processCpuTime = DataSerializer.readPrimitiveLong(in);
        this.updateTime = DataSerializer.readDate(in);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ClientHealthStats [");
        buf.append("\n numOfGets=" + this.numOfGets);
        buf.append("\n numOfPuts=" + this.numOfPuts);
        buf.append("\n numOfMisses=" + this.numOfMisses);
        buf.append("\n numOfCacheListenerCalls=" + this.numOfCacheListenerCalls);
        buf.append("\n numOfThreads=" + this.numOfThreads);
        buf.append("\n cpus=" + this.cpus);
        buf.append("\n processCpuTime=" + this.processCpuTime);
        buf.append("\n updateTime=" + this.updateTime);
        Iterator<Map.Entry<String, String>> it = this.poolStats.entrySet().iterator();
        StringBuffer tempBuffer = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            tempBuffer.append(entry.getKey() + " = " + entry.getValue());
        }
        buf.append("\n poolStats " + tempBuffer);
        buf.append("\n]");
        return buf.toString();
    }

    @Override
    public int getDSFID() {
        return -126;
    }

    @Override
    public Version[] getSerializationVersions() {
        return dsfidVersions;
    }

    public HashMap<String, String> getPoolStats() {
        return this.poolStats;
    }

    public void setPoolStats(HashMap<String, String> statsMap) {
        this.poolStats = statsMap;
    }
}

