/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.internal.admin.StatAlertsManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ChangeRefreshIntervalMessage
extends PooledDistributionMessage {
    private long _refreshInterval;

    public static ChangeRefreshIntervalMessage create(long refreshInterval) {
        ChangeRefreshIntervalMessage m = new ChangeRefreshIntervalMessage();
        m._refreshInterval = refreshInterval;
        return m;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this._refreshInterval);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this._refreshInterval = in.readLong();
    }

    @Override
    public int getDSFID() {
        return 1071;
    }

    @Override
    protected void process(DistributionManager dm) {
        StatAlertsManager.getInstance(dm).setRefreshTimeInterval(this.getRefreshInterval());
    }

    public long getRefreshInterval() {
        return this._refreshInterval;
    }

    public void setRefreshInterval(long interval) {
        this._refreshInterval = interval;
    }

    @Override
    public String toString() {
        return "Set alerts refresh time interval in " + InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }
}

