/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CancelStatListenerResponse;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class CancelStatListenerRequest
extends AdminRequest {
    private int listenerId;

    public static CancelStatListenerRequest create(int listenerId) {
        CancelStatListenerRequest m = new CancelStatListenerRequest();
        m.listenerId = listenerId;
        return m;
    }

    public CancelStatListenerRequest() {
        this.friendlyName = LocalizedStrings.CancelStatListenerRequest_REMOVE_STATISTIC_RESOURCE_LISTENER.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return CancelStatListenerResponse.create(dm, this.getSender(), this.listenerId);
    }

    @Override
    public int getDSFID() {
        return 1017;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.listenerId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.listenerId = in.readInt();
    }

    @Override
    public String toString() {
        return LocalizedStrings.CancelStatListenerRequest_CANCELSTATLISTENERREQUEST_FROM_0_FOR_1.toLocalizedString(this.getRecipient(), this.listenerId);
    }
}

