/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public final class AlertLevelChangeMessage
extends PooledDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private int newLevel;

    public static AlertLevelChangeMessage create(int newLevel) {
        AlertLevelChangeMessage m = new AlertLevelChangeMessage();
        m.newLevel = newLevel;
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        AlertAppender.getInstance().removeAlertListener(this.getSender());
        if (this.newLevel != Integer.MAX_VALUE) {
            AlertAppender.getInstance().addAlertListener(this.getSender(), this.newLevel);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "Added new AlertListener to application log writer");
            }
        }
    }

    @Override
    public int getDSFID() {
        return 1007;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.newLevel);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.newLevel = in.readInt();
    }

    @Override
    public String toString() {
        return LocalizedStrings.AlertLevelChangeMessage_CHANGING_ALERT_LEVEL_TO_0.toLocalizedString(AlertLevel.forSeverity(this.newLevel));
    }
}

