/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminWaiters;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AdminResponse
extends HighPriorityDistributionMessage
implements AdminMessageType {
    private int msgId;

    int getMsgId() {
        return this.msgId;
    }

    void setMsgId(int msgId) {
        this.msgId = msgId;
    }

    @Override
    public boolean sendViaJGroups() {
        return true;
    }

    @Override
    protected void process(DistributionManager dm) {
        AdminWaiters.sendResponse(this);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgId = in.readInt();
    }

    public InternalDistributedMember getRecipient() {
        InternalDistributedMember[] recipients = this.getRecipients();
        int size2 = recipients.length;
        if (size2 == 0) {
            return null;
        }
        if (size2 > 1) {
            throw new IllegalStateException(LocalizedStrings.AdminResponse_COULD_NOT_RETURN_ONE_RECIPIENT_BECAUSE_THIS_MESSAGE_HAS_0_RECIPIENTS.toLocalizedString(size2));
        }
        return recipients[0];
    }
}

