/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.Stat;
import com.gemstone.gemfire.internal.admin.StatResource;
import com.gemstone.gemfire.internal.admin.remote.AddStatListenerResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class AddStatListenerRequest
extends AdminRequest {
    private long resourceId;
    private String statName;

    public static AddStatListenerRequest create(StatResource observedResource, Stat observedStat) {
        AddStatListenerRequest m = new AddStatListenerRequest();
        m.resourceId = observedResource.getResourceUniqueID();
        m.statName = observedStat.getName();
        return m;
    }

    public AddStatListenerRequest() {
        this.friendlyName = LocalizedStrings.AddStatListenerRequest_ADD_STATISTIC_RESOURCE_LISTENER.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return AddStatListenerResponse.create(dm, this.getSender(), this.resourceId, this.statName);
    }

    @Override
    public int getDSFID() {
        return 1002;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.resourceId);
        out.writeUTF(this.statName);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.resourceId = in.readLong();
        this.statName = in.readUTF();
    }

    @Override
    public String toString() {
        return "AddStatListenerRequest from " + this.getRecipient() + " for " + this.resourceId + " " + this.statName;
    }
}

