/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClientMembershipMessage
extends PooledDistributionMessage {
    public static final int JOINED = 0;
    public static final int LEFT = 1;
    public static final int CRASHED = 2;
    private String clientId;
    private String clientHost;
    private int eventType;

    public ClientMembershipMessage() {
    }

    public ClientMembershipMessage(String clientId, String clientHost, int eventType) {
        this.clientId = clientId;
        this.clientHost = clientHost;
        this.eventType = eventType;
    }

    @Override
    protected void process(DistributionManager dm) {
        AdminDistributedSystemImpl adminDs = AdminDistributedSystemImpl.getConnectedInstance();
        if (adminDs != null) {
            String senderId = null;
            InternalDistributedMember msgSender = this.getSender();
            if (msgSender != null) {
                senderId = msgSender.getId();
            }
            adminDs.processClientMembership(senderId, this.clientId, this.clientHost, this.eventType);
        }
    }

    @Override
    public int getDSFID() {
        return 1080;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.clientId, out);
        DataSerializer.writeString(this.clientHost, out);
        out.writeInt(this.eventType);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.clientId = DataSerializer.readString(in);
        this.clientHost = DataSerializer.readString(in);
        this.eventType = in.readInt();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public int getEventType() {
        return this.eventType;
    }

    public static String getEventTypeString(int eventType) {
        switch (eventType) {
            case 0: {
                return "Member JOINED";
            }
            case 1: {
                return "Member LEFT";
            }
            case 2: {
                return "Member CRASHED";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public String toString() {
        String clientMembership = "JOINED";
        switch (this.eventType) {
            case 1: {
                clientMembership = "LEFT";
                break;
            }
            case 2: {
                clientMembership = "CRASHED and left";
                break;
            }
        }
        return "Client with Id: " + this.clientId + " running on host: " + this.clientHost + " " + clientMembership + " the server: " + this.getSender();
    }
}

