/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.SocketIOWithTimeout;
import com.gemstone.gemfire.internal.SocketInputStream;
import com.gemstone.gemfire.internal.SocketInputWrapper;
import com.gemstone.gemfire.internal.SocketOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;

public class SocketUtils {
    public static boolean USE_SELECTOR_POOLING = Boolean.valueOf(System.getProperty("gemfire.useSelectorPooling", "true"));

    public static void connect(Socket socket, SocketAddress address, int timeout) throws IOException {
        SocketUtils.connect(socket, address, null, timeout);
    }

    public static void connect(Socket socket, SocketAddress endpoint, SocketAddress localAddr, int timeout) throws IOException {
        if (socket == null || endpoint == null || timeout < 0) {
            throw new IllegalArgumentException("Illegal argument for connect()");
        }
        SocketChannel ch = socket.getChannel();
        if (localAddr != null) {
            socket.bind(localAddr);
        }
        try {
            if (ch == null) {
                socket.connect(endpoint, timeout);
            } else if (USE_SELECTOR_POOLING) {
                SocketIOWithTimeout.connect(ch, endpoint, timeout);
            } else {
                socket.connect(endpoint, timeout);
            }
        }
        catch (SocketTimeoutException ste) {
            throw new IOException(ste.getMessage());
        }
    }

    public static InputStream getInputStream(Socket socket) throws IOException {
        return SocketUtils.getInputStream(socket, socket.getSoTimeout());
    }

    public static InputStream getInputStream(Socket socket, long timeout) throws IOException {
        if (socket.getChannel() == null || !USE_SELECTOR_POOLING) {
            return socket.getInputStream();
        }
        SocketInputWrapper w = new SocketInputWrapper(socket, new SocketInputStream(socket));
        w.setTimeout(timeout);
        return w;
    }

    public static OutputStream getOutputStream(Socket socket) throws IOException {
        return SocketUtils.getOutputStream(socket, 0L);
    }

    public static OutputStream getOutputStream(Socket socket, long timeout) throws IOException {
        if (socket.getChannel() == null || !USE_SELECTOR_POOLING) {
            return socket.getOutputStream();
        }
        return new SocketOutputStream(socket, timeout);
    }
}

