/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

public final class NanoTimer {
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    private final long constructionTime;
    private long lastResetTime;

    public NanoTimer() {
        this.constructionTime = this.lastResetTime = NanoTimer.getTime();
    }

    public static long nanosToMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long millisToNanos(long millis) {
        return millis * 1000000L;
    }

    public static long getTime() {
        return System.nanoTime();
    }

    public long getConstructionTime() {
        return this.constructionTime;
    }

    public long getLastResetTime() {
        return this.lastResetTime;
    }

    public long reset() {
        long save = this.lastResetTime;
        this.lastResetTime = NanoTimer.getTime();
        return this.lastResetTime - save;
    }

    public long getTimeSinceReset() {
        return NanoTimer.getTime() - this.lastResetTime;
    }

    public long getTimeSinceConstruction() {
        return NanoTimer.getTime() - this.constructionTime;
    }
}

