/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.AbstractStatisticsFactory;
import com.gemstone.gemfire.internal.DummyStatisticsImpl;
import com.gemstone.gemfire.internal.SimpleStatSampler;
import com.gemstone.gemfire.internal.StatisticsManager;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class LocalStatisticsFactory
extends AbstractStatisticsFactory
implements StatisticsFactory,
StatisticsManager {
    private static final Logger logger = LogService.getLogger();
    public static final String STATS_DISABLE_NAME_PROPERTY = "stats.disable";
    private final SimpleStatSampler sampler;
    private final boolean statsDisabled = Boolean.getBoolean("stats.disable");

    public LocalStatisticsFactory(CancelCriterion stopper) {
        super(LocalStatisticsFactory.initId(), LocalStatisticsFactory.initName(), LocalStatisticsFactory.initStartTime());
        if (this.statsDisabled) {
            this.sampler = null;
            logger.info(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.LocalStatisticsFactory_STATISTIC_COLLECTION_IS_DISABLED_USE_DSTATSDISABLEFALSE_TO_TURN_ON_STATISTICS));
        } else {
            this.sampler = new SimpleStatSampler(stopper, this);
            this.sampler.start();
        }
    }

    protected static long initId() {
        return Thread.currentThread().hashCode();
    }

    protected static String initName() {
        return System.getProperty("stats.name", Thread.currentThread().getName());
    }

    protected static long initStartTime() {
        return System.currentTimeMillis();
    }

    protected SimpleStatSampler getStatSampler() {
        return this.sampler;
    }

    @Override
    public void close() {
        if (this.sampler != null) {
            this.sampler.stop();
        }
    }

    @Override
    protected Statistics createOsStatistics(StatisticsType type, String textId, long numericId, int osStatFlags) {
        if (this.statsDisabled) {
            return new DummyStatisticsImpl(type, textId, numericId);
        }
        return super.createOsStatistics(type, textId, numericId, osStatFlags);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        if (this.statsDisabled) {
            return new DummyStatisticsImpl(type, textId, numericId);
        }
        return super.createAtomicStatistics(type, textId, numericId);
    }
}

