/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.CanonicalInstantiator;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.GemFireRethrowable;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.ToDataException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LonerDistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.DSCODE;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.PdxSerializerObject;
import com.gemstone.gemfire.internal.SerializationVersions;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataStream;
import com.gemstone.gemfire.internal.VersionedObjectInput;
import com.gemstone.gemfire.internal.VersionedObjectOutput;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientDataSerializerMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.util.concurrent.CopyOnWriteHashMap;
import com.gemstone.gemfire.pdx.NonPortableClassException;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxSerializable;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.internal.AutoSerializableManager;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxInputStream;
import com.gemstone.gemfire.pdx.internal.PdxInstanceEnum;
import com.gemstone.gemfire.pdx.internal.PdxInstanceImpl;
import com.gemstone.gemfire.pdx.internal.PdxOutputStream;
import com.gemstone.gemfire.pdx.internal.PdxReaderImpl;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.PdxWriterImpl;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public abstract class InternalDataSerializer
extends DataSerializer
implements DSCODE {
    private static final Logger logger = LogService.getLogger();
    private static final Set loggedClasses = new HashSet();
    private static final ConcurrentHashMap<String, DataSerializer> classesToSerializers = new ConcurrentHashMap();
    private static final String serializationVersionTxt = System.getProperty("gemfire.serializationVersion");
    private static final SERIALIZATION_VERSION latestVersion = SERIALIZATION_VERSION.v662;
    private static final SERIALIZATION_VERSION serializationVersion = InternalDataSerializer.calculateSerializationVersion();
    private static final ConcurrentMap idsToSerializers;
    private static final ConcurrentHashMap<String, SerializerAttributesHolder> dsClassesToHolders;
    private static final ConcurrentHashMap<Integer, SerializerAttributesHolder> idsToHolders;
    private static final ConcurrentHashMap<String, SerializerAttributesHolder> supportedClassesToHolders;
    private static volatile Set listeners;
    private static final Object listenersSync;
    private static final byte TIME_UNIT_NANOSECONDS = -1;
    private static final byte TIME_UNIT_MICROSECONDS = -2;
    private static final byte TIME_UNIT_MILLISECONDS = -3;
    private static final byte TIME_UNIT_SECONDS = -4;
    private static final ConcurrentMap dsfidToClassMap;
    public static final byte NULL_ARRAY = -1;
    private static final byte SHORT_ARRAY_LEN = -2;
    public static final byte INT_ARRAY_LEN = -3;
    private static final int MAX_BYTE_ARRAY_LEN = 252;
    private static DataSerializer dvddeserializer;
    private static final ThreadLocal<Boolean> pdxSerializationInProgress;
    private static final byte INT_VL = 126;
    private static final byte LONG_VL = 127;
    private static final int MAX_BYTE_VL = 125;
    public static final boolean LOAD_CLASS_EACH_TIME;
    private static final CopyOnWriteHashMap<String, WeakReference<Class<?>>> classCache;
    private static final Object cacheAccessLock;

    public static ConcurrentHashMap<String, DataSerializer> getClassesToSerializers() {
        return classesToSerializers;
    }

    private static SERIALIZATION_VERSION calculateSerializationVersion() {
        if (serializationVersionTxt == null || serializationVersionTxt.equals("")) {
            return latestVersion;
        }
        if (serializationVersionTxt.startsWith("6.6.0") || serializationVersionTxt.startsWith("6.6.1")) {
            return SERIALIZATION_VERSION.v660;
        }
        if (serializationVersionTxt.startsWith("6.6.2")) {
            return SERIALIZATION_VERSION.v662;
        }
        return SERIALIZATION_VERSION.vINVALID;
    }

    public static boolean is662SerializationEnabled() {
        return serializationVersion.ordinal() >= SERIALIZATION_VERSION.v662.ordinal();
    }

    public static void checkSerializationVersion() {
        if (serializationVersion == SERIALIZATION_VERSION.vINVALID) {
            throw new IllegalArgumentException("The system property \"gemfire.serializationVersion\" was set to \"" + serializationVersionTxt + "\" which is not a valid serialization version. Valid versions must start with \"6.6.0\", \"6.6.1\", or \"6.6.2\"");
        }
    }

    private static void initializeWellKnownSerializers() {
        classesToSerializers.put("java.lang.String", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                try {
                    1.writeString((String)o, out);
                }
                catch (UTFDataFormatException ex) {
                    String s = "While writing a String of length " + ((String)o).length();
                    UTFDataFormatException ex2 = new UTFDataFormatException(s);
                    ex2.initCause(ex);
                    throw ex2;
                }
                return true;
            }
        });
        classesToSerializers.put("java.net.InetAddress", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(62);
                2.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.net.Inet4Address", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(62);
                3.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.net.Inet6Address", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(62);
                4.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Class", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Class c = (Class)o;
                if (c.isPrimitive()) {
                    InternalDataSerializer.writePrimitiveClass(c, out);
                } else {
                    out.writeByte(43);
                    5.writeClass(c, out);
                }
                return true;
            }
        });
        classesToSerializers.put("java.lang.Boolean", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Boolean value2 = (Boolean)o;
                out.writeByte(53);
                6.writeBoolean(value2, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Character", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Character value2 = (Character)o;
                out.writeByte(54);
                7.writeCharacter(value2, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Byte", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Byte value2 = (Byte)o;
                out.writeByte(55);
                8.writeByte(value2, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Short", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Short value2 = (Short)o;
                out.writeByte(56);
                9.writeShort(value2, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Integer", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Integer value2 = (Integer)o;
                out.writeByte(57);
                10.writeInteger(value2, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Long", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Long value2 = (Long)o;
                out.writeByte(58);
                11.writeLong(value2, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Float", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Float value2 = (Float)o;
                out.writeByte(59);
                12.writeFloat(value2, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Double", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Double value2 = (Double)o;
                out.writeByte(60);
                13.writeDouble(value2, out);
                return true;
            }
        });
        classesToSerializers.put("[Z", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(26);
                14.writeBooleanArray((boolean[])o, out);
                return true;
            }
        });
        classesToSerializers.put("[B", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                byte[] array = (byte[])o;
                out.writeByte(46);
                15.writeByteArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[C", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(27);
                16.writeCharArray((char[])o, out);
                return true;
            }
        });
        classesToSerializers.put("[D", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                double[] array = (double[])o;
                out.writeByte(51);
                17.writeDoubleArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[F", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                float[] array = (float[])o;
                out.writeByte(50);
                18.writeFloatArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[I", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                int[] array = (int[])o;
                out.writeByte(48);
                19.writeIntArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[J", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                long[] array = (long[])o;
                out.writeByte(49);
                20.writeLongArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[S", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                short[] array = (short[])o;
                out.writeByte(47);
                21.writeShortArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[Ljava.lang.String;", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                String[] array = (String[])o;
                out.writeByte(64);
                22.writeStringArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.concurrent.TimeUnit", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                TimeUnit unit = (TimeUnit)((Object)o);
                out.writeByte(68);
                InternalDataSerializer.writeTimeUnit(unit, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Date", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Date date = (Date)o;
                out.writeByte(61);
                24.writeDate(date, out);
                return true;
            }
        });
        classesToSerializers.put("java.io.File", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                File file = (File)o;
                out.writeByte(63);
                25.writeFile(file, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.ArrayList", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                ArrayList list = (ArrayList)o;
                out.writeByte(65);
                26.writeArrayList(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.LinkedList", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                LinkedList list = (LinkedList)o;
                out.writeByte(10);
                27.writeLinkedList(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Vector", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(71);
                28.writeVector((Vector)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Stack", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(74);
                29.writeStack((Stack)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.HashSet", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                HashSet list = (HashSet)o;
                out.writeByte(66);
                30.writeHashSet(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.LinkedHashSet", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(73);
                31.writeLinkedHashSet((LinkedHashSet)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.HashMap", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                HashMap list = (HashMap)o;
                out.writeByte(67);
                32.writeHashMap(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.IdentityHashMap", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(72);
                33.writeIdentityHashMap((IdentityHashMap)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Hashtable", new WellKnownPdxDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(70);
                34.writeHashtable((Hashtable)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Properties", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                Properties props = (Properties)o;
                out.writeByte(11);
                35.writeProperties(props, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.TreeMap", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(75);
                36.writeTreeMap((TreeMap)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.TreeSet", new WellKnownDS(){

            @Override
            public final boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(76);
                37.writeTreeSet((TreeSet)o, out);
                return true;
            }
        });
        if (InternalDataSerializer.is662SerializationEnabled()) {
            classesToSerializers.put("java.math.BigInteger", new WellKnownDS(){

                @Override
                public final boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(95);
                    InternalDataSerializer.writeBigInteger((BigInteger)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.math.BigDecimal", new WellKnownDS(){

                @Override
                public final boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(96);
                    InternalDataSerializer.writeBigDecimal((BigDecimal)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.util.UUID", new WellKnownDS(){

                @Override
                public final boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(98);
                    InternalDataSerializer.writeUUID((UUID)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.sql.Timestamp", new WellKnownDS(){

                @Override
                public final boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(99);
                    InternalDataSerializer.writeTimestamp((Timestamp)o, out);
                    return true;
                }
            });
        }
    }

    private static final int ubyteToInt(byte ub) {
        return ub & 0xFF;
    }

    private static DataSerializer newInstance(Class c) {
        DataSerializer s;
        Constructor init;
        if (!DataSerializer.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(LocalizedStrings.DataSerializer_0_DOES_NOT_EXTEND_DATASERIALIZER.toLocalizedString(c.getName()));
        }
        try {
            init = c.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            StringId s2 = LocalizedStrings.DataSerializer_CLASS_0_DOES_NOT_HAVE_A_ZEROARGUMENT_CONSTRUCTOR;
            Object[] args = new Object[]{c.getName()};
            if (c.getDeclaringClass() != null) {
                s2 = LocalizedStrings.DataSerializer_CLASS_0_DOES_NOT_HAVE_A_ZEROARGUMENT_CONSTRUCTOR_IT_IS_AN_INNER_CLASS_OF_1_SHOULD_IT_BE_A_STATIC_INNER_CLASS;
                args = new Object[]{c.getName(), c.getDeclaringClass()};
            }
            throw new IllegalArgumentException(s2.toLocalizedString(args));
        }
        try {
            init.setAccessible(true);
            s = (DataSerializer)init.newInstance(new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(LocalizedStrings.DataSerializer_COULD_NOT_INSTANTIATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()));
        }
        catch (InstantiationException ex) {
            IllegalArgumentException ex2 = new IllegalArgumentException(LocalizedStrings.DataSerializer_COULD_NOT_INSTANTIATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()));
            ex2.initCause(ex);
            throw ex2;
        }
        catch (InvocationTargetException ex) {
            IllegalArgumentException ex2 = new IllegalArgumentException(LocalizedStrings.DataSerializer_WHILE_INSTANTIATING_AN_INSTANCE_OF_0.toLocalizedString(c.getName()));
            ex2.initCause(ex);
            throw ex2;
        }
        return s;
    }

    public static DataSerializer register(Class c, boolean distribute, EventID eventId, ClientProxyMembershipID context) {
        DataSerializer s = InternalDataSerializer.newInstance(c);
        s.setEventId(eventId);
        s.setContext(context);
        return InternalDataSerializer._register(s, distribute);
    }

    public static DataSerializer register(Class c, boolean distribute) {
        DataSerializer s = InternalDataSerializer.newInstance(c);
        return InternalDataSerializer._register(s, distribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSerializer _register(DataSerializer s, boolean distribute) {
        boolean retry;
        int id = s.getId();
        DataSerializer dsForMarkers = s;
        if (id == 0) {
            throw new IllegalArgumentException(LocalizedStrings.InternalDataSerializer_CANNOT_CREATE_A_DATASERIALIZER_WITH_ID_0.toLocalizedString());
        }
        Class<?>[] classes = s.getSupportedClasses();
        if (classes == null || classes.length == 0) {
            StringId msg = LocalizedStrings.InternalDataSerializer_THE_DATASERIALIZER_0_HAS_NO_SUPPORTED_CLASSES_ITS_GETSUPPORTEDCLASSES_METHOD_MUST_RETURN_AT_LEAST_ONE_CLASS;
            throw new IllegalArgumentException(msg.toLocalizedString(s.getClass().getName()));
        }
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == null) {
                StringId msg = LocalizedStrings.InternalDataSerializer_THE_DATASERIALIZER_GETSUPPORTEDCLASSES_METHOD_FOR_0_RETURNED_AN_ARRAY_THAT_CONTAINED_A_NULL_ELEMENT;
                throw new IllegalArgumentException(msg.toLocalizedString(s.getClass().getName()));
            }
            if (!classes[i].isArray()) continue;
            StringId msg = LocalizedStrings.InternalDataSerializer_THE_DATASERIALIZER_GETSUPPORTEDCLASSES_METHOD_FOR_0_RETURNED_AN_ARRAY_THAT_CONTAINED_AN_ARRAY_CLASS_WHICH_IS_NOT_ALLOWED_SINCE_ARRAYS_HAVE_BUILTIN_SUPPORT;
            throw new IllegalArgumentException(msg.toLocalizedString(s.getClass().getName()));
        }
        Integer idx = id;
        Marker oldMarker = null;
        InitMarker m = new InitMarker();
        do {
            retry = false;
            InitMarker oldSerializer = idsToSerializers.putIfAbsent(idx, m);
            if (oldSerializer == null) continue;
            if (oldSerializer instanceof Marker) {
                boolean bl = retry = !idsToSerializers.replace(idx, oldSerializer, m);
                if (retry) continue;
                oldMarker = oldSerializer;
                continue;
            }
            if (oldSerializer.getClass().equals(s.getClass())) {
                if (distribute) {
                    InternalDataSerializer.sendRegistrationMessage(s);
                }
                return (DataSerializer)((Object)oldSerializer);
            }
            DataSerializer other = (DataSerializer)((Object)oldSerializer);
            throw new IllegalStateException(LocalizedStrings.InternalDataSerializer_A_DATASERIALIZER_OF_CLASS_0_IS_ALREADY_REGISTERED_WITH_ID_1_SO_THE_DATASERIALIZER_OF_CLASS_2_COULD_NOT_BE_REGISTERED.toLocalizedString(other.getClass().getName(), other.getId()));
        } while (retry);
        try {
            for (int i = 0; i < classes.length; ++i) {
                DataSerializer oldS = classesToSerializers.putIfAbsent(classes[i].getName(), s);
                if (oldS == null || s.equals(oldS)) continue;
                for (int j = 0; j < i; ++j) {
                    classesToSerializers.remove(classes[j].getName(), s);
                }
                dsForMarkers = null;
                String oldMsg = oldS.getId() == 0 ? "DataSerializer has built-in support for class " : "A DataSerializer of class " + oldS.getClass().getName() + " is already registered to support class ";
                String msg = oldMsg + classes[i].getName() + " so the DataSerializer of class " + s.getClass().getName() + " could not be registered.";
                if (oldS.getId() == 0) {
                    throw new IllegalArgumentException(msg);
                }
                throw new IllegalStateException(msg);
            }
        }
        finally {
            if (dsForMarkers == null) {
                idsToSerializers.remove(idx, m);
            } else {
                idsToSerializers.replace(idx, m, dsForMarkers);
            }
            if (oldMarker != null) {
                oldMarker.setSerializer(dsForMarkers);
            }
            m.setSerializer(dsForMarkers);
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && s.getEventId() == null) {
            s.setEventId(new EventID(cache.getDistributedSystem()));
        }
        if (distribute) {
            InternalDataSerializer.sendRegistrationMessage(s);
            InternalDataSerializer.sendRegistrationMessageToServers(s);
        }
        InternalDataSerializer.sendRegistrationMessageToClients(s);
        InternalDataSerializer.fireNewDataSerializer(s);
        return s;
    }

    public static void register(String className, boolean distribute, EventID eventId, ClientProxyMembershipID proxyId, int id) {
        InternalDataSerializer.register(className, distribute, new SerializerAttributesHolder(className, eventId, proxyId, id));
    }

    public static void register(String className, boolean distribute) {
        InternalDataSerializer.register(className, distribute, new SerializerAttributesHolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String className, boolean distribute, SerializerAttributesHolder holder) {
        if (className == null || className.trim().equals("")) {
            throw new IllegalArgumentException("Class name cannot be null or empty.");
        }
        SerializerAttributesHolder oldValue = dsClassesToHolders.putIfAbsent(className, holder);
        if (oldValue != null && oldValue.getId() != 0 && holder.getId() != 0 && oldValue.getId() != holder.getId()) {
            throw new IllegalStateException(LocalizedStrings.InternalDataSerializer_A_DATASERIALIZER_OF_CLASS_0_IS_ALREADY_REGISTERED_WITH_ID_1_SO_THE_DATASERIALIZER_OF_CLASS_2_COULD_NOT_BE_REGISTERED.toLocalizedString(oldValue.getClass().getName(), oldValue.getId()));
        }
        idsToHolders.putIfAbsent(holder.getId(), holder);
        Object ds = idsToSerializers.get(holder.getId());
        if (ds instanceof Marker) {
            Object v = ds;
            synchronized (v) {
                ((Marker)ds).notifyAll();
            }
        }
        if (distribute) {
            InternalDataSerializer.sendRegistrationMessageToServers(holder);
        }
    }

    public static void updateSupportedClassesMap(HashMap<Integer, ArrayList<String>> map) {
        for (Map.Entry<Integer, ArrayList<String>> e : map.entrySet()) {
            for (String supportedClassName : e.getValue()) {
                supportedClassesToHolders.putIfAbsent(supportedClassName, idsToHolders.get(e.getKey()));
            }
        }
    }

    public static void updateSupportedClassesMap(String dsClassName, String supportedClassName) {
        supportedClassesToHolders.putIfAbsent(supportedClassName, dsClassesToHolders.get(dsClassName));
    }

    private static void sendRegistrationMessageToServers(DataSerializer dataSerializer) {
        PoolManagerImpl.allPoolsRegisterDataSerializers(dataSerializer);
    }

    private static void sendRegistrationMessageToServers(SerializerAttributesHolder holder) {
        PoolManagerImpl.allPoolsRegisterDataSerializers(holder);
    }

    private static void sendRegistrationMessageToClients(DataSerializer dataSerializer) {
        byte[][] serializedDataSerializer;
        block3: {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            serializedDataSerializer = new byte[2][];
            try {
                serializedDataSerializer[0] = CacheServerHelper.serialize(dataSerializer.getClass().toString().substring(6));
                byte[] idBytes = new byte[4];
                Part.encodeInt(dataSerializer.getId(), idBytes);
                serializedDataSerializer[1] = idBytes;
            }
            catch (IOException e) {
                if (!logger.isTraceEnabled(LogMarker.SERIALIZER)) break block3;
                logger.trace(LogMarker.SERIALIZER, "InternalDataSerializer encountered an IOException while serializing DataSerializer :{}", dataSerializer);
            }
        }
        ClientDataSerializerMessage clientDataSerializerMessage = new ClientDataSerializerMessage(EnumListenerEvent.AFTER_REGISTER_DATASERIALIZER, serializedDataSerializer, (ClientProxyMembershipID)dataSerializer.getContext(), (EventID)dataSerializer.getEventId(), new Class[][]{dataSerializer.getSupportedClasses()});
        CacheClientNotifier.routeClientMessage(clientDataSerializerMessage);
    }

    public static EventID generateEventId() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return null;
        }
        return new EventID(InternalDistributedSystem.getAnyInstance());
    }

    public static void unregister(int id) {
        Integer idx = id;
        Object o = idsToSerializers.remove(idx);
        if (o != null && o instanceof InitMarker) {
            o = ((Marker)o).getSerializer();
        }
        if (o instanceof DataSerializer) {
            DataSerializer s = (DataSerializer)o;
            Class<?>[] classes = s.getSupportedClasses();
            for (int i = 0; i < classes.length; ++i) {
                classesToSerializers.remove(classes[i].getName(), s);
                supportedClassesToHolders.remove(classes[i].getName());
            }
            dsClassesToHolders.remove(s.getClass().getName());
            idsToHolders.remove(idx);
        }
    }

    public static void reinitialize() {
        idsToSerializers.clear();
        classesToSerializers.clear();
        supportedClassesToHolders.clear();
        dsClassesToHolders.clear();
        idsToHolders.clear();
        InternalDataSerializer.initializeWellKnownSerializers();
    }

    public static DataSerializer getSerializer(Class c) {
        SerializerAttributesHolder sah;
        DataSerializer ds = classesToSerializers.get(c.getName());
        if (ds == null && (sah = supportedClassesToHolders.get(c.getName())) != null) {
            Class<?> dsClass = null;
            try {
                dsClass = InternalDataSerializer.getCachedClass(sah.getClassName());
                DataSerializer serializer = InternalDataSerializer.register(dsClass, false);
                dsClassesToHolders.remove(dsClass.getName());
                idsToHolders.remove(serializer.getId());
                for (Class<?> clazz : serializer.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                return serializer;
            }
            catch (ClassNotFoundException cnfe) {
                logger.info(LogMarker.SERIALIZER, LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, dsClass));
            }
        }
        return ds;
    }

    public static DataSerializer getSerializer(int id) {
        Integer idx = id;
        GetMarker marker = new GetMarker();
        DataSerializer result = null;
        boolean timedOut = false;
        SerializerAttributesHolder sah = idsToHolders.get(idx);
        while (result == null && !timedOut && sah == null) {
            GetMarker o = idsToSerializers.putIfAbsent(idx, marker);
            if (o == null) {
                result = marker.getSerializer();
                if (result != null) continue;
                timedOut = true;
                idsToSerializers.remove(idx, marker);
                continue;
            }
            if (o instanceof Marker) {
                result = ((Marker)o).getSerializer();
                continue;
            }
            result = (DataSerializer)((Object)o);
        }
        if (result == null && sah != null) {
            Class<?> dsClass = null;
            try {
                dsClass = InternalDataSerializer.getCachedClass(sah.getClassName());
                DataSerializer ds = InternalDataSerializer.register(dsClass, false);
                dsClassesToHolders.remove(sah.getClassName());
                idsToHolders.remove(id);
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                return ds;
            }
            catch (ClassNotFoundException cnfe) {
                logger.info(LogMarker.SERIALIZER, LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, dsClass));
            }
        }
        return result;
    }

    public static DataSerializer[] getSerializers() {
        int size2 = idsToSerializers.size();
        ArrayList<Object> coll = new ArrayList<Object>(size2);
        for (Object v : idsToSerializers.values()) {
            if (v instanceof InitMarker) {
                v = ((Marker)v).getSerializer();
            }
            if (!(v instanceof DataSerializer)) continue;
            coll.add(v);
        }
        Iterator<Map.Entry<String, SerializerAttributesHolder>> iterator = dsClassesToHolders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SerializerAttributesHolder> entry = iterator.next();
            String name = entry.getKey();
            SerializerAttributesHolder holder = entry.getValue();
            try {
                Class<?> cl = InternalDataSerializer.getCachedClass(name);
                DataSerializer ds = null;
                ds = holder.getEventId() != null ? InternalDataSerializer.register(cl, false, holder.getEventId(), holder.getProxyId()) : InternalDataSerializer.register(cl, false);
                coll.add(ds);
                iterator.remove();
                idsToHolders.remove(ds.getId());
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
            }
            catch (ClassNotFoundException cnfe) {
                logger.info(LogMarker.SERIALIZER, LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, name));
            }
        }
        return coll.toArray(new DataSerializer[coll.size()]);
    }

    public static SerializerAttributesHolder[] getSerializersForDistribution() {
        int size2 = idsToSerializers.size() + dsClassesToHolders.size();
        ArrayList<SerializerAttributesHolder> coll = new ArrayList<SerializerAttributesHolder>(size2);
        for (Object v : idsToSerializers.values()) {
            if (v instanceof InitMarker) {
                v = ((Marker)v).getSerializer();
            }
            if (!(v instanceof DataSerializer)) continue;
            DataSerializer s = (DataSerializer)v;
            coll.add(new SerializerAttributesHolder(s.getClass().getName(), (EventID)s.getEventId(), (ClientProxyMembershipID)s.getContext(), s.getId()));
        }
        Iterator<Map.Entry<String, SerializerAttributesHolder>> iterator = dsClassesToHolders.entrySet().iterator();
        while (iterator.hasNext()) {
            SerializerAttributesHolder v = iterator.next().getValue();
            coll.add(v);
        }
        return coll.toArray(new SerializerAttributesHolder[coll.size()]);
    }

    public static void saveRegistrations(DataOutput out) throws IOException {
        for (Object v : idsToSerializers.values()) {
            if (v instanceof InitMarker) {
                v = ((Marker)v).getSerializer();
            }
            if (!(v instanceof DataSerializer)) continue;
            DataSerializer ds = (DataSerializer)v;
            out.writeInt(ds.getId());
            DataSerializer.writeClass(ds.getClass(), out);
        }
        if (!dsClassesToHolders.isEmpty()) {
            Iterator<Map.Entry<String, SerializerAttributesHolder>> iterator = dsClassesToHolders.entrySet().iterator();
            Class<?> dsClass = null;
            while (iterator.hasNext()) {
                try {
                    dsClass = InternalDataSerializer.getCachedClass(iterator.next().getKey());
                }
                catch (ClassNotFoundException cnfe) {
                    logger.info(LogMarker.SERIALIZER, LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, dsClass));
                    continue;
                }
                DataSerializer ds = InternalDataSerializer.register(dsClass, false);
                iterator.remove();
                idsToHolders.remove(ds.getId());
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                out.writeInt(ds.getId());
                DataSerializer.writeClass(ds.getClass(), out);
            }
        }
        out.writeInt(0);
    }

    public static void loadRegistrations(DataInput in) throws IOException {
        while (in.readInt() != 0) {
            Class<?> dsClass = null;
            boolean skip = false;
            try {
                dsClass = DataSerializer.readClass(in);
            }
            catch (ClassNotFoundException ex) {
                skip = true;
            }
            if (skip) continue;
            InternalDataSerializer.register(dsClass, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegistrationListener(RegistrationListener l) {
        Object object = listenersSync;
        synchronized (object) {
            HashSet<RegistrationListener> newSet = new HashSet<RegistrationListener>(listeners);
            newSet.add(l);
            listeners = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRegistrationListener(RegistrationListener l) {
        Object object = listenersSync;
        synchronized (object) {
            HashSet newSet = new HashSet(listeners);
            newSet.remove(l);
            listeners = newSet;
        }
    }

    private static void fireNewDataSerializer(DataSerializer ds) {
        for (RegistrationListener listener : listeners) {
            listener.newDataSerializer(ds);
        }
    }

    static void fireNewInstantiator(Instantiator instantiator) {
        for (RegistrationListener listener : listeners) {
            listener.newInstantiator(instantiator);
        }
    }

    private static void sendRegistrationMessage(DataSerializer s) {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system != null) {
            RegistrationMessage m = new RegistrationMessage(s);
            system.getDistributionManager().putOutgoing(m);
        }
    }

    public static final void writeDSFID(DataSerializableFixedID o, DataOutput out) throws IOException {
        int dsfid = o.getDSFID();
        if (dsfid == 0) {
            throw new IllegalStateException(LocalizedStrings.InternalDataSerializer_ATTEMPTED_TO_SERIALIZE_ILLEGAL_DSFID.toLocalizedString());
        }
        if (dsfidToClassMap != null && logger.isTraceEnabled(LogMarker.DEBUG_DSFID)) {
            logger.trace(LogMarker.DEBUG_DSFID, "writeDSFID {} class={}", dsfid, o.getClass());
            if (dsfid != Integer.MAX_VALUE) {
                String newClassName = o.getClass().getName();
                String existingClassName = dsfidToClassMap.putIfAbsent(dsfid, newClassName);
                if (existingClassName != null && !existingClassName.equals(newClassName)) {
                    logger.trace(LogMarker.DEBUG_DSFID, "dsfid={} is used for class {} and class {}", dsfid, existingClassName, newClassName);
                }
            }
        }
        if (dsfid <= 127 && dsfid >= -128) {
            out.writeByte(1);
            out.writeByte(dsfid);
        } else if (dsfid <= Short.MAX_VALUE && dsfid >= Short.MIN_VALUE) {
            out.writeByte(2);
            out.writeShort(dsfid);
        } else if (dsfid == Integer.MAX_VALUE) {
            out.writeByte(4);
            DataSerializer.writeClass(o.getClass(), out);
        } else {
            out.writeByte(3);
            out.writeInt(dsfid);
        }
        try {
            InternalDataSerializer.invokeToData(o, out);
        }
        catch (IOException io) {
            throw io;
        }
        catch (CancelException ex) {
            throw ex;
        }
        catch (ToDataException ex) {
            throw ex;
        }
        catch (GemFireRethrowable ex) {
            throw ex;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw new ToDataException("toData failed on dsfid=" + dsfid + " msg:" + t.getMessage(), t);
        }
    }

    public static boolean writeWellKnownObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        return InternalDataSerializer.writeUserObject(o, out, ensurePdxCompatibility);
    }

    private static boolean writeUserObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        Class<?> c = o.getClass();
        DataSerializer serializer = InternalDataSerializer.getSerializer(c);
        if (serializer != null) {
            int id = serializer.getId();
            if (id != 0) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                if (id <= 127 && id >= -128) {
                    out.writeByte(40);
                    out.writeByte((byte)id);
                } else if (id <= Short.MAX_VALUE && id >= Short.MIN_VALUE) {
                    out.writeByte(5);
                    out.writeShort(id);
                } else {
                    out.writeByte(6);
                    out.writeInt(id);
                }
            } else if (ensurePdxCompatibility && !(serializer instanceof WellKnownPdxDS)) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
            }
            boolean toDataResult = false;
            try {
                toDataResult = serializer.toData(o, out);
            }
            catch (IOException io) {
                if (serializer instanceof WellKnownDS) {
                    throw io;
                }
                throw new ToDataException("toData failed on DataSerializer with id=" + id + " for class " + c, io);
            }
            catch (ToDataException ex) {
                throw ex;
            }
            catch (CancelException ex) {
                throw ex;
            }
            catch (GemFireRethrowable ex) {
                throw ex;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                throw new ToDataException("toData failed on DataSerializer with id=" + id + " for class " + c, t);
            }
            if (toDataResult) {
                return true;
            }
            throw new ToDataException(LocalizedStrings.DataSerializer_SERIALIZER_0_A_1_SAID_THAT_IT_COULD_SERIALIZE_AN_INSTANCE_OF_2_BUT_ITS_TODATA_METHOD_RETURNED_FALSE.toLocalizedString(serializer.getId(), serializer.getClass().getName(), o.getClass().getName()));
        }
        if (o instanceof byte[][]) {
            byte[][] byteArrays = (byte[][])o;
            out.writeByte(91);
            InternalDataSerializer.writeArrayOfByteArrays(byteArrays, out);
            return true;
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            out.writeByte(52);
            InternalDataSerializer.writeObjectArray(array, out, ensurePdxCompatibility);
            return true;
        }
        if (InternalDataSerializer.is662SerializationEnabled() && o.getClass().isEnum()) {
            if (InternalDataSerializer.isPdxSerializationInProgress()) {
                InternalDataSerializer.writePdxEnum((Enum)o, out);
            } else {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                InternalDataSerializer.writeGemFireEnum((Enum)o, out);
            }
            return true;
        }
        PdxSerializer pdxSerializer = TypeRegistry.getPdxSerializer();
        if (pdxSerializer != null) {
            return InternalDataSerializer.writePdx(out, null, o, pdxSerializer);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean autoSerialized(Object o, DataOutput out) throws IOException {
        AutoSerializableManager.AutoClassInfo aci;
        AutoSerializableManager asm = TypeRegistry.getAutoSerializableManager();
        if (asm != null && (aci = asm.getExistingClassInfo(o.getClass())) != null) {
            PdxWriterImpl writer;
            GemFireCacheImpl gfc;
            block14: {
                gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                TypeRegistry tr = gfc.getPdxRegistry();
                PdxOutputStream os = out instanceof HeapDataOutputStream ? new PdxOutputStream((HeapDataOutputStream)out) : new PdxOutputStream();
                writer = new PdxWriterImpl(tr, o, aci, os);
                try {
                    if (InternalDataSerializer.is662SerializationEnabled()) {
                        boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                        if (!alreadyInProgress) {
                            InternalDataSerializer.setPdxSerializationInProgress(true);
                            try {
                                asm.writeData(writer, o, aci);
                                break block14;
                            }
                            finally {
                                InternalDataSerializer.setPdxSerializationInProgress(false);
                            }
                        }
                        asm.writeData(writer, o, aci);
                        break block14;
                    }
                    asm.writeData(writer, o, aci);
                }
                catch (ToDataException ex) {
                    throw ex;
                }
                catch (CancelException ex) {
                    throw ex;
                }
                catch (NonPortableClassException ex) {
                    throw ex;
                }
                catch (GemFireRethrowable ex) {
                    throw ex;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    throw new ToDataException("PdxSerializer failed when calling toData on " + o.getClass(), t);
                }
            }
            int bytesWritten = writer.completeByteStreamGeneration();
            InternalDataSerializer.getDMStats(gfc).incPdxSerialization(bytesWritten);
            if (!(out instanceof HeapDataOutputStream)) {
                writer.sendTo(out);
            }
            return true;
        }
        return false;
    }

    public static void checkPdxCompatible(Object o, boolean ensurePdxCompatibility) {
        if (ensurePdxCompatibility) {
            throw new NonPortableClassException("Instances of " + o.getClass() + " are not compatible with non-java PDX.");
        }
    }

    private static boolean isGemfireObject(Object o) {
        return (o instanceof Function || o.getClass().getName().startsWith("com.gemstone.")) && !(o instanceof PdxSerializerObject);
    }

    private static Object readUserObject(DataInput in, int serializerId) throws IOException, ClassNotFoundException {
        DataSerializer serializer = InternalDataSerializer.getSerializer(serializerId);
        if (serializer == null) {
            throw new IOException(LocalizedStrings.DataSerializer_SERIALIZER_0_IS_NOT_REGISTERED.toLocalizedString(serializerId));
        }
        return serializer.fromData(in);
    }

    public static void checkOut(DataOutput out) {
        if (out == null) {
            String s = "Null DataOutput";
            throw new NullPointerException(s);
        }
    }

    public static void checkIn(DataInput in) {
        if (in == null) {
            String s = "Null DataInput";
            throw new NullPointerException(s);
        }
    }

    public static void writeSet(Collection<?> set, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size2 = set == null ? -1 : set.size();
        InternalDataSerializer.writeArrayLength(size2, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing HashSet with {} elements: {}", size2, set);
        }
        if (size2 > 0) {
            for (Object element : set) {
                InternalDataSerializer.writeObject(element, out);
            }
        }
    }

    public static Set readSet(DataInput in) throws IOException, ClassNotFoundException {
        return InternalDataSerializer.readHashSet(in);
    }

    public static <E> boolean readCollection(DataInput in, Collection<E> c) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size2 = InternalDataSerializer.readArrayLength(in);
        if (size2 >= 0) {
            for (int index2 = 0; index2 < size2; ++index2) {
                Object element = DataSerializer.readObject(in);
                c.add(element);
            }
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Read Collection with {} elements: {}", size2, c);
            }
            return true;
        }
        return false;
    }

    public static void writeSetOfLongs(Set set, boolean hasLongIDs, DataOutput out) throws IOException {
        if (set == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(set.size());
            out.writeBoolean(hasLongIDs);
            for (Long l : set) {
                if (hasLongIDs) {
                    out.writeLong(l);
                    continue;
                }
                out.writeInt((int)l.longValue());
            }
        }
    }

    public static Set<Long> readSetOfLongs(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 < 0) {
            return null;
        }
        HashSet<Long> result = new HashSet<Long>(size2);
        boolean longIDs = in.readBoolean();
        for (int i = 0; i < size2; ++i) {
            long l = longIDs ? in.readLong() : (long)in.readInt();
            result.add(l);
        }
        return result;
    }

    public static void writeListOfLongs(List list, boolean hasLongIDs, DataOutput out) throws IOException {
        if (list == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(list.size());
            out.writeBoolean(hasLongIDs);
            for (Long l : list) {
                if (hasLongIDs) {
                    out.writeLong(l);
                    continue;
                }
                out.writeInt((int)l.longValue());
            }
        }
    }

    public static List<Long> readListOfLongs(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 < 0) {
            return null;
        }
        LinkedList<Long> result = new LinkedList<Long>();
        boolean longIDs = in.readBoolean();
        for (int i = 0; i < size2; ++i) {
            long l = longIDs ? in.readLong() : (long)in.readInt();
            result.add(l);
        }
        return result;
    }

    public static final void writePrimitiveClass(Class c, DataOutput out) throws IOException {
        if (c == Boolean.TYPE) {
            out.writeByte(17);
        } else if (c == Character.TYPE) {
            out.writeByte(18);
        } else if (c == Byte.TYPE) {
            out.writeByte(19);
        } else if (c == Short.TYPE) {
            out.writeByte(20);
        } else if (c == Integer.TYPE) {
            out.writeByte(21);
        } else if (c == Long.TYPE) {
            out.writeByte(22);
        } else if (c == Float.TYPE) {
            out.writeByte(23);
        } else if (c == Double.TYPE) {
            out.writeByte(24);
        } else if (c == Void.TYPE) {
            out.writeByte(25);
        } else if (c == null) {
            out.writeByte(41);
        } else {
            throw new InternalGemFireError(LocalizedStrings.InternalDataSerializer_UNKNOWN_PRIMITIVE_TYPE_0.toLocalizedString(c.getName()));
        }
    }

    public static final Class decodePrimitiveClass(byte typeCode) {
        switch (typeCode) {
            case 17: {
                return Boolean.TYPE;
            }
            case 18: {
                return Character.TYPE;
            }
            case 19: {
                return Byte.TYPE;
            }
            case 20: {
                return Short.TYPE;
            }
            case 21: {
                return Integer.TYPE;
            }
            case 22: {
                return Long.TYPE;
            }
            case 23: {
                return Float.TYPE;
            }
            case 24: {
                return Double.TYPE;
            }
            case 25: {
                return Void.TYPE;
            }
            case 41: {
                return null;
            }
        }
        throw new InternalGemFireError(LocalizedStrings.InternalDataSerializer_UNEXPECTED_TYPECODE_0.toLocalizedString(typeCode));
    }

    public static void writeTimeUnit(TimeUnit unit, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing TimeUnit: {}", new Object[]{unit});
        }
        if (unit.equals((Object)TimeUnit.NANOSECONDS)) {
            out.writeByte(-1);
        } else if (unit.equals((Object)TimeUnit.MICROSECONDS)) {
            out.writeByte(-2);
        } else if (unit.equals((Object)TimeUnit.MILLISECONDS)) {
            out.writeByte(-3);
        } else if (unit.equals((Object)TimeUnit.SECONDS)) {
            out.writeByte(-4);
        } else {
            throw new InternalGemFireException(LocalizedStrings.DataSerializer_UNSUPPORTED_TIMEUNIT_0.toLocalizedString(new Object[]{unit}));
        }
    }

    public static TimeUnit readTimeUnit(DataInput in) throws IOException {
        TimeUnit unit;
        InternalDataSerializer.checkIn(in);
        byte type = in.readByte();
        switch (type) {
            case -1: {
                unit = TimeUnit.NANOSECONDS;
                break;
            }
            case -2: {
                unit = TimeUnit.MICROSECONDS;
                break;
            }
            case -3: {
                unit = TimeUnit.MILLISECONDS;
                break;
            }
            case -4: {
                unit = TimeUnit.SECONDS;
                break;
            }
            default: {
                throw new IOException(LocalizedStrings.DataSerializer_UNKNOWN_TIMEUNIT_TYPE_0.toLocalizedString(type));
            }
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read TimeUnit: {}", new Object[]{unit});
        }
        return unit;
    }

    public static void writeTimestamp(Timestamp o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Timestamp: {}", o);
        }
        DataSerializer.writePrimitiveLong(o.getTime(), out);
    }

    public static Timestamp readTimestamp(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Timestamp result = new Timestamp(DataSerializer.readPrimitiveLong(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read Timestamp: {}", result);
        }
        return result;
    }

    public static void writeUUID(UUID o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing UUID: {}", o);
        }
        DataSerializer.writePrimitiveLong(o.getMostSignificantBits(), out);
        DataSerializer.writePrimitiveLong(o.getLeastSignificantBits(), out);
    }

    public static UUID readUUID(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        long mb = DataSerializer.readPrimitiveLong(in);
        long lb = DataSerializer.readPrimitiveLong(in);
        UUID result = new UUID(mb, lb);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read UUID: {}", result);
        }
        return result;
    }

    public static void writeBigDecimal(BigDecimal o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing BigDecimal: {}", o);
        }
        DataSerializer.writeString(o.toString(), out);
    }

    public static BigDecimal readBigDecimal(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        BigDecimal result = new BigDecimal(DataSerializer.readString(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read BigDecimal: {}", result);
        }
        return result;
    }

    public static void writeBigInteger(BigInteger o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing BigInteger: {}", o);
        }
        DataSerializer.writeByteArray(o.toByteArray(), out);
    }

    public static BigInteger readBigInteger(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        BigInteger result = new BigInteger(DataSerializer.readByteArray(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Read BigInteger: {}", result);
        }
        return result;
    }

    public static final void writeUserDataSerializableHeader(int classId, DataOutput out) throws IOException {
        if (classId <= 127 && classId >= -128) {
            out.writeByte(39);
            out.writeByte(classId);
        } else if (classId <= Short.MAX_VALUE && classId >= Short.MIN_VALUE) {
            out.writeByte(38);
            out.writeShort(classId);
        } else {
            out.writeByte(37);
            out.writeInt(classId);
        }
    }

    public static void writeCharArray(char[] array, int length, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (array == null) {
            length = -1;
        }
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing char array of length {}", length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeChar(array[i]);
            }
        }
    }

    public static final boolean isSerializedNull(byte[] serializedForm) {
        return serializedForm.length == 1 && serializedForm[0] == 41;
    }

    public static final void basicWriteObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        InternalDataSerializer.checkOut(out);
        boolean isDebugEnabled_SERIALIZER = logger.isTraceEnabled(LogMarker.SERIALIZER);
        if (isDebugEnabled_SERIALIZER) {
            logger.trace(LogMarker.SERIALIZER, "basicWriteObject: {}", o);
        }
        if (o == null) {
            out.writeByte(41);
        } else if (o instanceof DataSerializableFixedID) {
            InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
            DataSerializableFixedID dsfid = (DataSerializableFixedID)o;
            InternalDataSerializer.writeDSFID(dsfid, out);
        } else if (!InternalDataSerializer.autoSerialized(o, out)) {
            if (o instanceof DataSerializable.Replaceable) {
                Object replacement = ((DataSerializable.Replaceable)o).replace();
                InternalDataSerializer.basicWriteObject(replacement, out, ensurePdxCompatibility);
            } else if (o instanceof PdxSerializable) {
                InternalDataSerializer.writePdx(out, GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed."), o, null);
            } else if (o instanceof DataSerializable) {
                if (isDebugEnabled_SERIALIZER) {
                    logger.trace(LogMarker.SERIALIZER, "Writing DataSerializable: {}", o);
                }
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                Class<?> c = o.getClass();
                int classId = InternalInstantiator.getClassId(c);
                if (classId != 0) {
                    InternalDataSerializer.writeUserDataSerializableHeader(classId, out);
                } else {
                    out.writeByte(45);
                    DataSerializer.writeClass(c, out);
                }
                DataSerializable ds = (DataSerializable)o;
                InternalDataSerializer.invokeToData(ds, out);
            } else if (o instanceof Sendable) {
                if (!(o instanceof PdxInstance) || o instanceof PdxInstanceEnum) {
                    InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                }
                ((Sendable)o).sendTo(out);
            } else if (!InternalDataSerializer.writeWellKnownObject(o, out, ensurePdxCompatibility)) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                if (logger.isTraceEnabled(LogMarker.DUMP_SERIALIZED)) {
                    logger.trace(LogMarker.DUMP_SERIALIZED, "DataSerializer Serializing an instance of {}", o.getClass().getName());
                }
                if (InternalDataSerializer.disallowJavaSerialization() && o instanceof Serializable) {
                    throw new NotSerializableException(LocalizedStrings.DataSerializer_0_IS_NOT_DATASERIALIZABLE_AND_JAVA_SERIALIZATION_IS_DISALLOWED.toLocalizedString(o.getClass().getName()));
                }
                InternalDataSerializer.writeSerializableObject(o, out);
            }
        }
    }

    private static boolean disallowJavaSerialization() {
        Boolean v = (Boolean)DISALLOW_JAVA_SERIALIZATION.get();
        return v != null && v != false;
    }

    private static void writePdxEnum(Enum<?> e, DataOutput out) throws IOException {
        TypeRegistry tr = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.").getPdxRegistry();
        int eId = tr.getEnumId(e);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "write PdxEnum id={} enum={}", eId, e);
        }
        InternalDataSerializer.writePdxEnumId(eId, out);
    }

    public static void writePdxEnumId(int eId, DataOutput out) throws IOException {
        out.writeByte(94);
        out.writeByte(eId >> 24);
        InternalDataSerializer.writeArrayLength(eId & 0xFFFFFF, out);
    }

    private static Object readPdxEnum(DataInput in) throws IOException {
        GemFireCacheImpl gfc;
        TypeRegistry tr;
        Object result;
        byte dsId = in.readByte();
        int tmp = InternalDataSerializer.readArrayLength(in);
        int enumId = dsId << 24 | tmp & 0xFFFFFF;
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "read PdxEnum id={}", enumId);
        }
        if ((result = (tr = (gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.")).getPdxRegistry()).getEnumById(enumId)) instanceof PdxInstance) {
            InternalDataSerializer.getDMStats(gfc).incPdxInstanceCreations();
        }
        return result;
    }

    private static void writeGemFireEnum(Enum<?> e, DataOutput out) throws IOException {
        boolean isGemFireObject = InternalDataSerializer.isGemfireObject(e);
        DataSerializer.writePrimitiveByte(isGemFireObject ? (byte)100 : 101, out);
        DataSerializer.writeString(e.getDeclaringClass().getName(), out);
        DataSerializer.writeString(e.name(), out);
        if (!isGemFireObject) {
            InternalDataSerializer.writeArrayLength(e.ordinal(), out);
        }
    }

    private static Enum<?> readGemFireEnum(DataInput in) throws IOException, ClassNotFoundException {
        String className = DataSerializer.readString(in);
        String enumName = DataSerializer.readString(in);
        Class<?> c = InternalDataSerializer.getCachedClass(className);
        return Enum.valueOf(c, enumName);
    }

    private static Object readPdxInlineEnum(DataInput in) throws IOException, ClassNotFoundException {
        GemFireCacheImpl gfc = GemFireCacheImpl.getInstance();
        if (gfc != null && gfc.getPdxReadSerializedByAnyGemFireServices()) {
            String className = DataSerializer.readString(in);
            String enumName = DataSerializer.readString(in);
            int enumOrdinal = InternalDataSerializer.readArrayLength(in);
            InternalDataSerializer.getDMStats(gfc).incPdxInstanceCreations();
            return new PdxInstanceEnum(className, enumName, enumOrdinal);
        }
        Enum<?> e = InternalDataSerializer.readGemFireEnum(in);
        InternalDataSerializer.readArrayLength(in);
        return e;
    }

    public static final void writeSerializableObject(Object o, DataOutput out) throws IOException {
        out.writeByte(44);
        if (out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)out).writeObject(o);
        } else {
            Version v;
            OutputStream stream;
            if (out instanceof OutputStream) {
                stream = (OutputStream)((Object)out);
            } else {
                final DataOutput out2 = out;
                stream = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        out2.write(b);
                    }
                };
            }
            ObjectOutput oos = new ObjectOutputStream(stream);
            if (stream instanceof VersionedDataStream && (v = ((VersionedDataStream)((Object)stream)).getVersion()) != null && v != Version.CURRENT) {
                oos = new VersionedObjectOutput(oos, v);
            }
            oos.writeObject(o);
            oos.flush();
        }
    }

    public static final void invokeToData(Object ds, DataOutput out) throws IOException {
        boolean isDSFID = ds instanceof DataSerializableFixedID;
        try {
            boolean invoked = false;
            Version v = InternalDataSerializer.getVersionForDataStreamOrNull(out);
            Version[] versions = null;
            if (v != null && v != Version.CURRENT) {
                if (ds instanceof SerializationVersions) {
                    SerializationVersions sv = (SerializationVersions)ds;
                    versions = sv.getSerializationVersions();
                }
                if (versions != null && versions.length > 0) {
                    for (int i = 0; i < versions.length; ++i) {
                        if (v.compareTo(versions[i]) >= 0) continue;
                        ds.getClass().getMethod("toDataPre_" + versions[i].getMethodSuffix(), DataOutput.class).invoke(ds, out);
                        invoked = true;
                        break;
                    }
                }
            }
            if (!invoked) {
                if (isDSFID) {
                    ((DataSerializableFixedID)ds).toData(out);
                } else {
                    ((DataSerializable)ds).toData(out);
                }
            }
        }
        catch (IOException io) {
            if (isDSFID) {
                throw io;
            }
            throw new ToDataException("toData failed on DataSerializable " + ds.getClass(), io);
        }
        catch (ToDataException ex) {
            throw ex;
        }
        catch (CancelException ex) {
            throw ex;
        }
        catch (GemFireRethrowable ex) {
            throw ex;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw new ToDataException("toData failed on DataSerializable " + ds.getClass(), t);
        }
    }

    public static final void invokeFromData(Object ds, DataInput in) throws IOException, ClassNotFoundException {
        try {
            boolean invoked = false;
            Version v = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            Version[] versions = null;
            if (v != null && v != Version.CURRENT) {
                if (ds instanceof SerializationVersions) {
                    SerializationVersions vds = (SerializationVersions)ds;
                    versions = vds.getSerializationVersions();
                }
                if (versions != null && versions.length > 0) {
                    for (int i = 0; i < versions.length; ++i) {
                        if (v.compareTo(versions[i]) >= 0) continue;
                        ds.getClass().getMethod("fromDataPre_" + versions[i].getMethodSuffix(), DataInput.class).invoke(ds, in);
                        invoked = true;
                        break;
                    }
                }
            }
            if (!invoked) {
                if (ds instanceof DataSerializableFixedID) {
                    ((DataSerializableFixedID)ds).fromData(in);
                } else {
                    ((DataSerializable)ds).fromData(in);
                }
            }
        }
        catch (EOFException ex) {
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (CacheClosedException cce) {
            throw cce;
        }
        catch (Exception ex) {
            SerializationException ex2 = new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_0.toLocalizedString(ds.getClass().getName()), ex);
            throw ex2;
        }
    }

    private static final Object readDataSerializable(DataInput in) throws IOException, ClassNotFoundException {
        Class<?> c = InternalDataSerializer.readClass(in);
        try {
            Constructor<?> init = c.getConstructor(new Class[0]);
            init.setAccessible(true);
            Object o = init.newInstance(new Object[0]);
            Assert.assertTrue(o instanceof DataSerializable);
            DataSerializable ds = (DataSerializable)o;
            InternalDataSerializer.invokeFromData(ds, in);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Read DataSerializable {}", ds);
            }
            return ds;
        }
        catch (EOFException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SerializationException ex2 = new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()), ex);
            throw ex2;
        }
    }

    private static final DataSerializableFixedID readDataSerializableFixedID(DataInput in) throws IOException, ClassNotFoundException {
        Class<?> c = InternalDataSerializer.readClass(in);
        try {
            Constructor<?> init = c.getConstructor(new Class[0]);
            init.setAccessible(true);
            Object o = init.newInstance(new Object[0]);
            DataSerializableFixedID ds = (DataSerializableFixedID)o;
            InternalDataSerializer.invokeFromData(ds, in);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Read DataSerializableFixedID {}", ds);
            }
            return ds;
        }
        catch (Exception ex) {
            SerializationException ex2 = new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()), ex);
            throw ex2;
        }
    }

    public static final Version getVersionForDataStream(DataInput in) {
        if (in instanceof VersionedDataStream) {
            Version v = ((VersionedDataStream)((Object)in)).getVersion();
            return v != null ? v : Version.CURRENT;
        }
        return Version.CURRENT;
    }

    public static final Version getVersionForDataStreamOrNull(DataInput in) {
        if (in instanceof VersionedDataStream) {
            return ((VersionedDataStream)((Object)in)).getVersion();
        }
        return null;
    }

    public static final Version getVersionForDataStream(DataOutput out) {
        if (out instanceof VersionedDataStream) {
            Version v = ((VersionedDataStream)((Object)out)).getVersion();
            return v != null ? v : Version.CURRENT;
        }
        return Version.CURRENT;
    }

    public static final Version getVersionForDataStreamOrNull(DataOutput out) {
        if (out instanceof VersionedDataStream) {
            return ((VersionedDataStream)((Object)out)).getVersion();
        }
        return null;
    }

    public static void writeArrayLength(int len, DataOutput out) throws IOException {
        if (len == -1) {
            out.writeByte(-1);
        } else if (len <= 252) {
            out.writeByte(len);
        } else if (len <= 65535) {
            out.writeByte(-2);
            out.writeShort(len);
        } else {
            out.writeByte(-3);
            out.writeInt(len);
        }
    }

    public static int readArrayLength(DataInput in) throws IOException {
        byte code = in.readByte();
        if (code == -1) {
            return -1;
        }
        int result = InternalDataSerializer.ubyteToInt(code);
        if (result > 252) {
            if (code == -2) {
                result = in.readUnsignedShort();
            } else if (code == -3) {
                result = in.readInt();
            } else {
                throw new IllegalStateException("unexpected array length code=" + code);
            }
        }
        return result;
    }

    public static void skipByteArray(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        int length = InternalDataSerializer.readArrayLength(in);
        if (length != -1) {
            in.skipBytes(length);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Skipped byte array of length {}", length);
            }
        }
    }

    public static final DataSerializableFixedID readDSFID(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        byte header = in.readByte();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "readDSFID: header={}", header);
        }
        if (header == 1) {
            return DSFIDFactory.create(in.readByte(), in);
        }
        if (header == 2) {
            return DSFIDFactory.create(in.readShort(), in);
        }
        if (header == 4) {
            return InternalDataSerializer.readDataSerializableFixedID(in);
        }
        if (header == 3) {
            return DSFIDFactory.create(in.readInt(), in);
        }
        throw new IllegalStateException("unexpected byte: " + header + " while reading dsfid");
    }

    public static String readString(DataInput in, byte header) throws IOException {
        if (header == 87) {
            int len = in.readUnsignedShort();
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Reading STRING_BYTES of len={}", len);
            }
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            return new String(buf, 0);
        }
        if (header == 42) {
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Reading utf STRING");
            }
            return in.readUTF();
        }
        if (header == 69) {
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Reading NULL_STRING");
            }
            return null;
        }
        if (header == 88) {
            int len = in.readInt();
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Reading HUGE_STRING_BYTES of len={}", len);
            }
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            return new String(buf, 0);
        }
        if (header == 89) {
            int len = in.readInt();
            if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
                logger.trace(LogMarker.SERIALIZER, "Reading HUGE_STRING of len={}", len);
            }
            char[] buf = new char[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = in.readChar();
            }
            return new String(buf);
        }
        String s = "Unknown String header " + header;
        throw new IOException(s);
    }

    public static void registerDVDDeserializer(DataSerializer dvddeslzr) {
        dvddeserializer = dvddeslzr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T readNonPdxInstanceObject(DataInput in) throws IOException, ClassNotFoundException {
        boolean wouldReadSerialized = PdxInstanceImpl.getPdxReadSerialized();
        if (!wouldReadSerialized) {
            return DataSerializer.readObject(in);
        }
        PdxInstanceImpl.setPdxReadSerialized(false);
        try {
            Object t = DataSerializer.readObject(in);
            return t;
        }
        finally {
            PdxInstanceImpl.setPdxReadSerialized(true);
        }
    }

    public static final Object basicReadObject(final DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        byte header = in.readByte();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "basicReadObject: header={}", header);
        }
        switch (header) {
            case 1: {
                return DSFIDFactory.create(in.readByte(), in);
            }
            case 2: {
                return DSFIDFactory.create(in.readShort(), in);
            }
            case 3: {
                return DSFIDFactory.create(in.readInt(), in);
            }
            case 4: {
                return InternalDataSerializer.readDataSerializableFixedID(in);
            }
            case 90: {
                return dvddeserializer.fromData(in);
            }
            case 41: {
                return null;
            }
            case 42: 
            case 69: 
            case 87: 
            case 88: 
            case 89: {
                return InternalDataSerializer.readString(in, header);
            }
            case 43: {
                return InternalDataSerializer.readClass(in);
            }
            case 61: {
                return InternalDataSerializer.readDate(in);
            }
            case 63: {
                return InternalDataSerializer.readFile(in);
            }
            case 62: {
                return InternalDataSerializer.readInetAddress(in);
            }
            case 53: {
                return InternalDataSerializer.readBoolean(in);
            }
            case 54: {
                return InternalDataSerializer.readCharacter(in);
            }
            case 55: {
                return InternalDataSerializer.readByte(in);
            }
            case 56: {
                return InternalDataSerializer.readShort(in);
            }
            case 57: {
                return InternalDataSerializer.readInteger(in);
            }
            case 58: {
                return InternalDataSerializer.readLong(in);
            }
            case 59: {
                return InternalDataSerializer.readFloat(in);
            }
            case 60: {
                return InternalDataSerializer.readDouble(in);
            }
            case 46: {
                return InternalDataSerializer.readByteArray(in);
            }
            case 91: {
                return InternalDataSerializer.readArrayOfByteArrays(in);
            }
            case 47: {
                return InternalDataSerializer.readShortArray(in);
            }
            case 64: {
                return InternalDataSerializer.readStringArray(in);
            }
            case 48: {
                return InternalDataSerializer.readIntArray(in);
            }
            case 49: {
                return InternalDataSerializer.readLongArray(in);
            }
            case 50: {
                return InternalDataSerializer.readFloatArray(in);
            }
            case 51: {
                return InternalDataSerializer.readDoubleArray(in);
            }
            case 26: {
                return InternalDataSerializer.readBooleanArray(in);
            }
            case 27: {
                return InternalDataSerializer.readCharArray(in);
            }
            case 52: {
                return InternalDataSerializer.readObjectArray(in);
            }
            case 65: {
                return InternalDataSerializer.readArrayList(in);
            }
            case 10: {
                return InternalDataSerializer.readLinkedList(in);
            }
            case 66: {
                return InternalDataSerializer.readHashSet(in);
            }
            case 73: {
                return InternalDataSerializer.readLinkedHashSet(in);
            }
            case 67: {
                return InternalDataSerializer.readHashMap(in);
            }
            case 72: {
                return InternalDataSerializer.readIdentityHashMap(in);
            }
            case 70: {
                return InternalDataSerializer.readHashtable(in);
            }
            case 97: {
                return InternalDataSerializer.readConcurrentHashMap(in);
            }
            case 11: {
                return InternalDataSerializer.readProperties(in);
            }
            case 68: {
                return InternalDataSerializer.readTimeUnit(in);
            }
            case 40: {
                return InternalDataSerializer.readUserObject(in, in.readByte());
            }
            case 5: {
                return InternalDataSerializer.readUserObject(in, in.readShort());
            }
            case 6: {
                return InternalDataSerializer.readUserObject(in, in.readInt());
            }
            case 71: {
                return InternalDataSerializer.readVector(in);
            }
            case 74: {
                return InternalDataSerializer.readStack(in);
            }
            case 75: {
                return InternalDataSerializer.readTreeMap(in);
            }
            case 76: {
                return InternalDataSerializer.readTreeSet(in);
            }
            case 17: {
                return Boolean.TYPE;
            }
            case 18: {
                return Character.TYPE;
            }
            case 19: {
                return Byte.TYPE;
            }
            case 20: {
                return Short.TYPE;
            }
            case 21: {
                return Integer.TYPE;
            }
            case 22: {
                return Long.TYPE;
            }
            case 23: {
                return Float.TYPE;
            }
            case 24: {
                return Double.TYPE;
            }
            case 25: {
                return Void.TYPE;
            }
            case 39: {
                return InternalDataSerializer.readUserDataSerializable(in, in.readByte());
            }
            case 38: {
                return InternalDataSerializer.readUserDataSerializable(in, in.readShort());
            }
            case 37: {
                return InternalDataSerializer.readUserDataSerializable(in, in.readInt());
            }
            case 45: {
                return InternalDataSerializer.readDataSerializable(in);
            }
            case 44: {
                boolean isDebugEnabled_SERIALIZER = logger.isTraceEnabled(LogMarker.SERIALIZER);
                Object serializableResult = null;
                if (in instanceof DSObjectInputStream) {
                    serializableResult = ((DSObjectInputStream)in).readObject();
                } else {
                    Version v;
                    InputStream stream = in instanceof InputStream ? (InputStream)((Object)in) : new InputStream(){

                        @Override
                        public int read() throws IOException {
                            try {
                                return in.readUnsignedByte();
                            }
                            catch (EOFException enfOfStream) {
                                return -1;
                            }
                        }
                    };
                    ObjectInput ois = new DSObjectInputStream(stream);
                    if (stream instanceof VersionedDataStream && (v = ((VersionedDataStream)((Object)stream)).getVersion()) != null && v != Version.CURRENT) {
                        ois = new VersionedObjectInput(ois, v);
                    }
                    serializableResult = ois.readObject();
                    if (isDebugEnabled_SERIALIZER) {
                        logger.trace(LogMarker.SERIALIZER, "Read Serializable object: {}", serializableResult);
                    }
                }
                if (isDebugEnabled_SERIALIZER) {
                    logger.trace(LogMarker.SERIALIZER, "deserialized instanceof {}", serializableResult.getClass());
                }
                return serializableResult;
            }
            case 93: {
                return InternalDataSerializer.readPdxSerializable(in);
            }
            case 94: {
                return InternalDataSerializer.readPdxEnum(in);
            }
            case 100: {
                return InternalDataSerializer.readGemFireEnum(in);
            }
            case 101: {
                return InternalDataSerializer.readPdxInlineEnum(in);
            }
            case 95: {
                return InternalDataSerializer.readBigInteger(in);
            }
            case 96: {
                return InternalDataSerializer.readBigDecimal(in);
            }
            case 98: {
                return InternalDataSerializer.readUUID(in);
            }
            case 99: {
                return InternalDataSerializer.readTimestamp(in);
            }
        }
        String s = "Unknown header byte: " + header;
        throw new IOException(s);
    }

    private static final Object readUserDataSerializable(DataInput in, int classId) throws IOException, ClassNotFoundException {
        Instantiator instantiator = InternalInstantiator.getInstantiator(classId);
        if (instantiator == null) {
            logger.error(LogMarker.SERIALIZER, LocalizedMessage.create(LocalizedStrings.DataSerializer_NO_INSTANTIATOR_HAS_BEEN_REGISTERED_FOR_CLASS_WITH_ID_0, classId));
            throw new IOException(LocalizedStrings.DataSerializer_NO_INSTANTIATOR_HAS_BEEN_REGISTERED_FOR_CLASS_WITH_ID_0.toLocalizedString(classId));
        }
        try {
            DataSerializable ds;
            if (instantiator instanceof CanonicalInstantiator) {
                CanonicalInstantiator ci = (CanonicalInstantiator)instantiator;
                ds = ci.newInstance(in);
            } else {
                ds = instantiator.newInstance();
            }
            ds.fromData(in);
            return ds;
        }
        catch (Exception ex) {
            SerializationException ex2 = new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_DESERIALIZE_AN_INSTANCE_OF_0.toLocalizedString(instantiator.getInstantiatedClass().getName()), ex);
            throw ex2;
        }
    }

    public static boolean isPdxSerializationInProgress() {
        Boolean v = pdxSerializationInProgress.get();
        return v != null && v != false;
    }

    public static void setPdxSerializationInProgress(boolean v) {
        if (v) {
            pdxSerializationInProgress.set(true);
        } else {
            pdxSerializationInProgress.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean writePdx(DataOutput out, GemFireCacheImpl gfc, Object pdx, PdxSerializer pdxSerializer) throws IOException {
        PdxWriterImpl writer;
        block23: {
            TypeRegistry tr = null;
            if (gfc != null) {
                tr = gfc.getPdxRegistry();
            }
            PdxOutputStream os = out instanceof HeapDataOutputStream ? new PdxOutputStream((HeapDataOutputStream)out) : new PdxOutputStream();
            writer = new PdxWriterImpl(tr, pdx, os);
            try {
                if (pdxSerializer != null) {
                    if (InternalDataSerializer.isGemfireObject(pdx)) {
                        return false;
                    }
                    if (InternalDataSerializer.is662SerializationEnabled()) {
                        boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                        if (!alreadyInProgress) {
                            InternalDataSerializer.setPdxSerializationInProgress(true);
                            try {
                                if (!pdxSerializer.toData(pdx, writer)) {
                                    boolean bl = false;
                                    return bl;
                                }
                                break block23;
                            }
                            finally {
                                InternalDataSerializer.setPdxSerializationInProgress(false);
                            }
                        }
                        if (!pdxSerializer.toData(pdx, writer)) {
                            return false;
                        }
                        break block23;
                    }
                    if (!pdxSerializer.toData(pdx, writer)) {
                        return false;
                    }
                    break block23;
                }
                if (InternalDataSerializer.is662SerializationEnabled()) {
                    boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                    if (!alreadyInProgress) {
                        InternalDataSerializer.setPdxSerializationInProgress(true);
                        try {
                            ((PdxSerializable)pdx).toData(writer);
                            break block23;
                        }
                        finally {
                            InternalDataSerializer.setPdxSerializationInProgress(false);
                        }
                    }
                    ((PdxSerializable)pdx).toData(writer);
                    break block23;
                }
                ((PdxSerializable)pdx).toData(writer);
            }
            catch (ToDataException ex) {
                throw ex;
            }
            catch (CancelException ex) {
                throw ex;
            }
            catch (NonPortableClassException ex) {
                throw ex;
            }
            catch (GemFireRethrowable ex) {
                throw ex;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (pdxSerializer == null) throw new ToDataException("toData failed on PdxSerializable " + pdx.getClass(), t);
                throw new ToDataException("PdxSerializer failed when calling toData on " + pdx.getClass(), t);
            }
        }
        int bytesWritten = writer.completeByteStreamGeneration();
        InternalDataSerializer.getDMStats(gfc).incPdxSerialization(bytesWritten);
        if (out instanceof HeapDataOutputStream) return true;
        writer.sendTo(out);
        return true;
    }

    public static DMStats getDMStats(GemFireCacheImpl gfc) {
        if (gfc != null) {
            return gfc.getDistributionManager().getStats();
        }
        DMStats result = InternalDistributedSystem.getDMStats();
        if (result == null) {
            result = new LonerDistributionManager.DummyDMStats();
        }
        return result;
    }

    private static final Object readPdxSerializable(DataInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        int typeId = in.readInt();
        GemFireCacheImpl gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
        PdxType pdxType = gfc.getPdxRegistry().getType(typeId);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "readPdxSerializable pdxType={}", pdxType);
        }
        if (pdxType == null) {
            throw new IllegalStateException("Unknown pdx type=" + typeId);
        }
        DMStats dmStats = InternalDataSerializer.getDMStats(gfc);
        dmStats.incPdxDeserialization(len + 9);
        if (pdxType.getNoDomainClass() || gfc.getPdxReadSerializedByAnyGemFireServices()) {
            dmStats.incPdxInstanceCreations();
            return new PdxInstanceImpl(pdxType, in, len);
        }
        PdxReaderImpl pdxReader = new PdxReaderImpl(pdxType, in, len);
        return pdxReader.getObject();
    }

    public static final PdxInstance readPdxInstance(byte[] dataBytes, GemFireCacheImpl gfc) {
        try {
            byte type = dataBytes[0];
            if (type == 93) {
                PdxInputStream in = new PdxInputStream(dataBytes);
                in.readByte();
                int len = in.readInt();
                int typeId = in.readInt();
                PdxType pdxType = gfc.getPdxRegistry().getType(typeId);
                if (pdxType == null) {
                    throw new IllegalStateException("Unknown pdx type=" + typeId);
                }
                return new PdxInstanceImpl(pdxType, in, len);
            }
            if (type == 94) {
                PdxInputStream in = new PdxInputStream(dataBytes);
                in.readByte();
                byte dsId = in.readByte();
                int tmp = InternalDataSerializer.readArrayLength(in);
                int enumId = dsId << 24 | tmp & 0xFFFFFF;
                TypeRegistry tr = gfc.getPdxRegistry();
                EnumInfo ei = tr.getEnumInfoById(enumId);
                if (ei == null) {
                    throw new IllegalStateException("Unknown pdx enum id=" + enumId);
                }
                return ei.getPdxInstance(enumId);
            }
            if (type == 101) {
                PdxInputStream in = new PdxInputStream(dataBytes);
                in.readByte();
                String className = DataSerializer.readString(in);
                String enumName = DataSerializer.readString(in);
                int enumOrdinal = InternalDataSerializer.readArrayLength(in);
                return new PdxInstanceEnum(className, enumName, enumOrdinal);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static int getLoadedDataSerializers() {
        return idsToSerializers.size();
    }

    public static final Map getDsClassesToHoldersMap() {
        return dsClassesToHolders;
    }

    public static final Map getIdsToHoldersMap() {
        return idsToHolders;
    }

    public static final Map getSupportedClassesToHoldersMap() {
        return supportedClassesToHolders;
    }

    public static void writeObjectArray(Object[] array, DataOutput out, boolean ensureCompatibility) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER)) {
            logger.trace(LogMarker.SERIALIZER, "Writing Object array of length {}", length);
        }
        if (length >= 0) {
            InternalDataSerializer.writeClass(array.getClass().getComponentType(), out);
            for (int i = 0; i < length; ++i) {
                InternalDataSerializer.basicWriteObject(array[i], out, ensureCompatibility);
            }
        }
    }

    public static void writeVLOld(long data, DataOutput out) throws IOException {
        if (data < 0L) {
            Assert.fail("Data expected to be >=0 is " + data);
        }
        if (data <= 125L) {
            out.writeByte((byte)data);
        } else if (data <= 32767L) {
            out.write(((int)data >>> 8 | 0x80) & 0xFF);
            out.write((int)data >>> 0 & 0xFF);
        } else if (data <= Integer.MAX_VALUE) {
            out.writeByte(126);
            out.writeInt((int)data);
        } else {
            out.writeByte(127);
            out.writeLong(data);
        }
    }

    public static long readVLOld(DataInput in) throws IOException {
        long result;
        byte code = in.readByte();
        if (code < 0) {
            result = code & 0x7F;
            result <<= 8;
            result |= (long)(in.readByte() & 0xFF);
        } else if (code <= 125) {
            result = code;
        } else if (code == 126) {
            result = in.readInt();
        } else if (code == 127) {
            result = in.readLong();
        } else {
            throw new IllegalStateException("unexpected variable length code=" + code);
        }
        return result;
    }

    public static void writeUnsignedVL(long data, DataOutput out) throws IOException {
        while (true) {
            if ((data & 0xFFFFFFFFFFFFFF80L) == 0L) {
                out.writeByte((int)data);
                return;
            }
            out.writeByte((int)data & 0x7F | 0x80);
            data >>>= 7;
        }
    }

    public static long readUnsignedVL(DataInput in) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new GemFireIOException("Malformed variable length integer");
    }

    public static void writeSignedVL(long data, DataOutput out) throws IOException {
        InternalDataSerializer.writeUnsignedVL(InternalDataSerializer.encodeZigZag64(data), out);
    }

    public static long readSignedVL(DataInput in) throws IOException {
        return InternalDataSerializer.decodeZigZag64(InternalDataSerializer.readUnsignedVL(in));
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int calculateBytesForTSandDSID(int dsid) {
        HeapDataOutputStream out = new HeapDataOutputStream(12, Version.CURRENT);
        long now = System.currentTimeMillis();
        try {
            InternalDataSerializer.writeUnsignedVL(now, out);
            InternalDataSerializer.writeUnsignedVL(InternalDataSerializer.encodeZigZag64(dsid), out);
        }
        catch (IOException e) {
            return 0;
        }
        return out.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getCachedClass(String className) throws ClassNotFoundException {
        if (LOAD_CLASS_EACH_TIME) {
            return ClassPathLoader.getLatest().forName(className);
        }
        Class<?> result = InternalDataSerializer.getExistingCachedClass(className);
        if (result == null) {
            result = ClassPathLoader.getLatest().forName(className);
            Object object = cacheAccessLock;
            synchronized (object) {
                Class<?> cachedClass = InternalDataSerializer.getExistingCachedClass(className);
                if (cachedClass == null) {
                    classCache.put(className, new WeakReference(result));
                } else {
                    result = cachedClass;
                }
            }
        }
        return result;
    }

    private static Class<?> getExistingCachedClass(String className) {
        WeakReference<Class<?>> wr = classCache.get(className);
        Class result = null;
        if (wr != null) {
            result = (Class)wr.get();
        }
        return result;
    }

    public static void flushClassCache() {
        if (classCache != null) {
            classCache.clear();
        }
    }

    static {
        InternalDataSerializer.initializeWellKnownSerializers();
        idsToSerializers = new ConcurrentHashMap();
        dsClassesToHolders = new ConcurrentHashMap();
        idsToHolders = new ConcurrentHashMap();
        supportedClassesToHolders = new ConcurrentHashMap();
        listeners = new HashSet();
        listenersSync = new Object();
        dsfidToClassMap = logger.isTraceEnabled(LogMarker.DEBUG_DSFID) ? new ConcurrentHashMap() : null;
        pdxSerializationInProgress = new ThreadLocal();
        LOAD_CLASS_EACH_TIME = Boolean.getBoolean("gemfire.loadClassOnEveryDeserialization");
        classCache = LOAD_CLASS_EACH_TIME ? null : new CopyOnWriteHashMap();
        cacheAccessLock = new Object();
    }

    public static interface Sendable {
        public void sendTo(DataOutput var1) throws IOException;
    }

    protected static abstract class WellKnownPdxDS
    extends WellKnownDS {
        protected WellKnownPdxDS() {
        }
    }

    protected static abstract class WellKnownDS
    extends DataSerializer {
        protected WellKnownDS() {
        }

        @Override
        public final int getId() {
            return 0;
        }

        public final Class[] getSupportedClasses() {
            return null;
        }

        @Override
        public final Object fromData(DataInput in) throws IOException, ClassNotFoundException {
            throw new IllegalStateException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }
    }

    private static class DSObjectInputStream
    extends ObjectInputStream {
        public DSObjectInputStream(InputStream stream) throws IOException {
            super(stream);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            try {
                return InternalDataSerializer.getCachedClass(className);
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader nonPublicLoader = null;
            boolean hasNonPublicInterface = false;
            Class[] classObjs = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> cl = InternalDataSerializer.getCachedClass(interfaces[i]);
                if ((cl.getModifiers() & 1) == 0) {
                    if (hasNonPublicInterface) {
                        if (nonPublicLoader != cl.getClassLoader()) {
                            String s = "conflicting non-public interface class loaders";
                            throw new IllegalAccessError(s);
                        }
                    } else {
                        nonPublicLoader = cl.getClassLoader();
                        hasNonPublicInterface = true;
                    }
                }
                classObjs[i] = cl;
            }
            try {
                if (hasNonPublicInterface) {
                    return Proxy.getProxyClass(nonPublicLoader, classObjs);
                }
                return ClassPathLoader.getLatest().getProxyClass(classObjs);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
    }

    public static interface RegistrationListener {
        public void newInstantiator(Instantiator var1);

        public void newDataSerializer(DataSerializer var1);
    }

    public static final class RegistrationMessage
    extends PooledDistributionMessage {
        private int id;
        protected EventID eventId;
        private String className;
        private static final Version[] dsfidVersions = new Version[0];

        public RegistrationMessage() {
        }

        public RegistrationMessage(DataSerializer s) {
            this.className = s.getClass().getName();
            this.id = s.getId();
            this.eventId = (EventID)s.getEventId();
        }

        public static String getFullMessage(Throwable t) {
            StringBuffer sb = new StringBuffer();
            RegistrationMessage.getFullMessage(sb, t);
            return sb.toString();
        }

        private static void getFullMessage(StringBuffer sb, Throwable t) {
            if (t.getMessage() != null) {
                sb.append(t.getMessage());
            } else {
                sb.append(t.getClass());
            }
            if (t.getCause() != null) {
                sb.append(" caused by: ");
                RegistrationMessage.getFullMessage(sb, t.getCause());
            }
        }

        @Override
        protected void process(DistributionManager dm) {
            if (CacheClientNotifier.getInstance() != null) {
                Class<?> c = null;
                try {
                    c = InternalDataSerializer.getCachedClass(this.className);
                }
                catch (ClassNotFoundException ex) {
                    logger.warn("Could not load data serializer class {} so both clients of this server and this server will not have this data serializer. Load failed because: {}", this.className, RegistrationMessage.getFullMessage(ex));
                    return;
                }
                DataSerializer s = null;
                try {
                    s = InternalDataSerializer.newInstance(c);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Could not create an instance of data serializer for class {} so both clients of this server and this server will not have this data serializer. Create failed because: {}", this.className, RegistrationMessage.getFullMessage(ex));
                    return;
                }
                s.setEventId(this.eventId);
                try {
                    InternalDataSerializer._register(s, false);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Could not register data serializer for class {} so both clients of this server and this server will not have this data serializer. Registration failed because: {}", this.className, RegistrationMessage.getFullMessage(ex));
                    return;
                }
                catch (IllegalStateException ex) {
                    logger.warn("Could not register data serializer for class {} so both clients of this server and this server will not have this data serializer. Registration failed because: {}", this.className, RegistrationMessage.getFullMessage(ex));
                    return;
                }
            }
            try {
                InternalDataSerializer.register(this.className, false, this.eventId, null, this.id);
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Could not register data serializer for class {} so it will not be available in this JVM. Registration failed because: {}", this.className, RegistrationMessage.getFullMessage(ex));
                return;
            }
            catch (IllegalStateException ex) {
                logger.warn("Could not register data serializer for class {} so it will not be available in this JVM. Registration failed because: {}", this.className, RegistrationMessage.getFullMessage(ex));
                return;
            }
        }

        @Override
        public int getDSFID() {
            return -68;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeNonPrimitiveClassName(this.className, out);
            out.writeInt(this.id);
            DataSerializer.writeObject(this.eventId, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            InternalDataSerializer.checkIn(in);
            this.className = DataSerializer.readNonPrimitiveClassName(in);
            this.id = in.readInt();
            this.eventId = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            return LocalizedStrings.InternalDataSerializer_REGISTER_DATASERIALIZER_0_OF_CLASS_1.toLocalizedString(this.id, this.className);
        }

        @Override
        public Version[] getSerializationVersions() {
            return dsfidVersions;
        }
    }

    static class InitMarker
    extends Marker {
        InitMarker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        DataSerializer getSerializer() {
            InitMarker initMarker = this;
            synchronized (initMarker) {
                while (!this.hasBeenSet) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.serializer;
            }
        }
    }

    static class GetMarker
    extends Marker {
        static int WAIT_MS = Integer.getInteger("gemfire.InternalDataSerializer.WAIT_MS", 60000);

        GetMarker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        DataSerializer getSerializer() {
            boolean firstTime = true;
            long endTime = 0L;
            GetMarker getMarker = this;
            synchronized (getMarker) {
                while (!this.hasBeenSet) {
                    if (firstTime) {
                        firstTime = false;
                        endTime = System.currentTimeMillis() + (long)WAIT_MS;
                    }
                    try {
                        long remainingMs = endTime - System.currentTimeMillis();
                        if (remainingMs > 0L) {
                            this.wait(remainingMs);
                            continue;
                        }
                        this.setSerializer(null);
                        break;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.serializer;
            }
        }
    }

    static abstract class Marker {
        protected DataSerializer serializer = null;
        protected boolean hasBeenSet = false;

        Marker() {
        }

        abstract DataSerializer getSerializer();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSerializer(DataSerializer serializer) {
            Marker marker = this;
            synchronized (marker) {
                this.hasBeenSet = true;
                this.serializer = serializer;
                this.notifyAll();
            }
        }
    }

    public static class SerializerAttributesHolder {
        private String className = "";
        private EventID eventId = null;
        private ClientProxyMembershipID proxyId = null;
        private int id = 0;

        public SerializerAttributesHolder() {
        }

        public SerializerAttributesHolder(String name, EventID event, ClientProxyMembershipID proxy, int id) {
            this.className = name;
            this.eventId = event;
            this.proxyId = proxy;
            this.id = id;
        }

        public String getClassName() {
            return this.className;
        }

        public EventID getEventId() {
            return this.eventId;
        }

        public ClientProxyMembershipID getProxyId() {
            return this.proxyId;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "SerializerAttributesHolder[name=" + this.className + ",id=" + this.id + ",eventId=" + this.eventId + "]";
        }
    }

    private static enum SERIALIZATION_VERSION {
        vINVALID,
        v660,
        v662;

    }
}

