/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.internal.LinuxProcFsStatistics;
import com.gemstone.gemfire.internal.LinuxProcessStats;
import com.gemstone.gemfire.internal.LinuxSystemStats;
import com.gemstone.gemfire.internal.LocalStatisticsImpl;
import com.gemstone.gemfire.internal.OSXProcessStats;
import com.gemstone.gemfire.internal.OSXSystemStats;
import com.gemstone.gemfire.internal.OsStatisticsFactory;
import com.gemstone.gemfire.internal.ProcessStats;
import com.gemstone.gemfire.internal.PureJavaMode;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SolarisProcessStats;
import com.gemstone.gemfire.internal.SolarisSystemStats;
import com.gemstone.gemfire.internal.WindowsProcessStats;
import com.gemstone.gemfire.internal.WindowsSystemStats;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostStatHelper {
    static final int SOLARIS_CODE = 1;
    static final int WINDOWS_CODE = 2;
    static final int LINUX_CODE = 3;
    static final int OSX_CODE = 4;
    static final int PROCESS_STAT_FLAG = 1;
    static final int SYSTEM_STAT_FLAG = 2;
    static final int osCode;

    public static boolean isWindows() {
        return osCode == 2;
    }

    public static boolean isUnix() {
        return osCode != 2;
    }

    public static boolean isSolaris() {
        return osCode == 1;
    }

    public static boolean isLinux() {
        return osCode == 3;
    }

    public static boolean isOSX() {
        return osCode == 4;
    }

    private HostStatHelper() {
    }

    static int initOSStats() {
        if (HostStatHelper.isLinux()) {
            return LinuxProcFsStatistics.init();
        }
        return HostStatHelper.init();
    }

    static void closeOSStats() {
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.close();
        } else {
            HostStatHelper.close();
        }
    }

    static void readyRefreshOSStats() {
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.readyRefresh();
        } else {
            HostStatHelper.readyRefresh();
        }
    }

    private static native int init();

    private static native void close();

    private static native void readyRefresh();

    private static void refreshProcess(LocalStatisticsImpl s) {
        int pid = (int)s.getNumericId();
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.refreshProcess(pid, s._getIntStorage(), s._getLongStorage(), s._getDoubleStorage());
        } else {
            HostStatHelper.refreshProcess(pid, s._getIntStorage(), s._getLongStorage(), s._getDoubleStorage());
        }
    }

    private static native void refreshProcess(int var0, int[] var1, long[] var2, double[] var3);

    private static void refreshSystem(LocalStatisticsImpl s) {
        if (HostStatHelper.isLinux()) {
            LinuxProcFsStatistics.refreshSystem(s._getIntStorage(), s._getLongStorage(), s._getDoubleStorage());
        } else {
            HostStatHelper.refreshSystem(s._getIntStorage(), s._getLongStorage(), s._getDoubleStorage());
        }
    }

    private static native void refreshSystem(int[] var0, long[] var1, double[] var2);

    public static void refresh(LocalStatisticsImpl stats) {
        int flags = stats.getOsStatFlags();
        if ((flags & 1) != 0) {
            HostStatHelper.refreshProcess(stats);
        } else if ((flags & 2) != 0) {
            HostStatHelper.refreshSystem(stats);
        } else {
            throw new RuntimeException(LocalizedStrings.HostStatHelper_UNEXPECTED_OS_STATS_FLAGS_0.toLocalizedString(flags));
        }
    }

    public static Statistics newProcess(OsStatisticsFactory f, long pid, String name) {
        Statistics stats;
        switch (osCode) {
            case 1: {
                stats = f.createOsStatistics(SolarisProcessStats.getType(), name, pid, 1);
                break;
            }
            case 3: {
                stats = f.createOsStatistics(LinuxProcessStats.getType(), name, pid, 1);
                break;
            }
            case 4: {
                stats = f.createOsStatistics(OSXProcessStats.getType(), name, pid, 1);
                break;
            }
            case 2: {
                stats = f.createOsStatistics(WindowsProcessStats.getType(), name, pid, 1);
                break;
            }
            default: {
                throw new InternalGemFireException(LocalizedStrings.HostStatHelper_UNHANDLED_OSCODE_0_HOSTSTATHELPERNEWPROCESS.toLocalizedString(osCode));
            }
        }
        return stats;
    }

    static ProcessStats newProcessStats(Statistics stats) {
        switch (osCode) {
            case 1: {
                return SolarisProcessStats.createProcessStats(stats);
            }
            case 3: {
                return LinuxProcessStats.createProcessStats(stats);
            }
            case 2: {
                return WindowsProcessStats.createProcessStats(stats);
            }
            case 4: {
                return OSXProcessStats.createProcessStats(stats);
            }
        }
        throw new InternalGemFireException(LocalizedStrings.HostStatHelper_UNHANDLED_OSCODE_0_HOSTSTATHELPERNEWPROCESSSTATS.toLocalizedString(osCode));
    }

    static void newSystem(OsStatisticsFactory f) {
        Statistics stats;
        switch (osCode) {
            case 1: {
                stats = f.createOsStatistics(SolarisSystemStats.getType(), HostStatHelper.getHostSystemName(), HostStatHelper.getHostSystemId(), 2);
                break;
            }
            case 3: {
                stats = f.createOsStatistics(LinuxSystemStats.getType(), HostStatHelper.getHostSystemName(), HostStatHelper.getHostSystemId(), 2);
                break;
            }
            case 2: {
                stats = f.createOsStatistics(WindowsSystemStats.getType(), HostStatHelper.getHostSystemName(), HostStatHelper.getHostSystemId(), 2);
                break;
            }
            case 4: {
                stats = f.createOsStatistics(OSXSystemStats.getType(), HostStatHelper.getHostSystemName(), HostStatHelper.getHostSystemId(), 2);
                break;
            }
            default: {
                throw new InternalGemFireException(LocalizedStrings.HostStatHelper_UNHANDLED_OSCODE_0_HOSTSTATHELPERNEWSYSTEM.toLocalizedString(osCode));
            }
        }
        if (stats instanceof LocalStatisticsImpl) {
            HostStatHelper.refreshSystem((LocalStatisticsImpl)stats);
        }
    }

    private static String getHostSystemName() {
        String hostname = "unknownHostName";
        try {
            InetAddress addr = SocketCreator.getLocalHost();
            hostname = addr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    private static long getHostSystemId() {
        long id = 0L;
        try {
            InetAddress host = SocketCreator.getLocalHost();
            byte[] addr = host.getAddress();
            id = ((long)addr[1] & 0xFFL) << 24 | ((long)addr[0] & 0xFFL) << 16 | ((long)addr[3] & 0xFFL) << 8 | ((long)addr[2] & 0xFFL) << 0;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return id;
    }

    static {
        String osName = System.getProperty("os.name", "unknown");
        if (!PureJavaMode.osStatsAreAvailable()) {
            throw new RuntimeException(LocalizedStrings.HostStatHelper_HOSTSTATHELPER_NOT_ALLOWED_IN_PURE_JAVA_MODE.toLocalizedString());
        }
        if (osName.equals("SunOS")) {
            osCode = 1;
        } else if (osName.startsWith("Windows")) {
            osCode = 2;
        } else if (osName.startsWith("Linux")) {
            osCode = 3;
        } else if (osName.equals("Mac OS X")) {
            osCode = 4;
        } else {
            throw new InternalGemFireException(LocalizedStrings.HostStatHelper_UNSUPPORTED_OS_0_SUPPORTED_OSS_ARE_SUNOSSPARC_SOLARIS_LINUXX86_AND_WINDOWS.toLocalizedString(osName));
        }
    }
}

