/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;

public class HistogramStats {
    private static final String hist_typeDesc = "A bucketed histogram of values with unit ";
    private final int[] statCounterIndex;
    private final long[] bp;
    private final Statistics stats;

    public HistogramStats(String name, String unit, StatisticsFactory factory, long[] breakPoints, boolean largerIsBetter) {
        this.bp = breakPoints;
        StatisticDescriptor[] fieldDescriptors = new StatisticDescriptor[this.bp.length * 2];
        int k = 0;
        for (int bucketNumber = 0; bucketNumber < this.bp.length; ++bucketNumber) {
            String desc = (bucketNumber < this.bp.length - 1 ? "ForLTE" : "ForGT") + this.bp[bucketNumber];
            fieldDescriptors[k] = factory.createIntCounter("BucketCount" + desc, "Number of data points in Bucket " + bucketNumber, "count", !largerIsBetter);
            fieldDescriptors[++k] = factory.createLongCounter("BucketTotal" + desc, "Sum of Bucket " + bucketNumber, unit, !largerIsBetter);
            ++k;
        }
        StatisticsType hist_type = factory.createType("HistogramWith" + breakPoints.length + "Buckets", hist_typeDesc + unit + " for " + breakPoints.length + " breakpoints", fieldDescriptors);
        this.statCounterIndex = new int[this.bp.length * 2];
        k = 0;
        for (int bucketNumber = 0; bucketNumber < this.bp.length; ++bucketNumber) {
            String desc = (bucketNumber < this.bp.length - 1 ? "ForLTE" : "ForGT") + this.bp[bucketNumber];
            this.statCounterIndex[k] = hist_type.nameToId("BucketCount" + desc);
            this.statCounterIndex[++k] = hist_type.nameToId("BucketTotal" + desc);
            ++k;
        }
        this.stats = factory.createAtomicStatistics(hist_type, name, 0L);
    }

    public void endOp(long delta) {
        int index2 = this.statCounterIndex.length - 2;
        for (int i = 0; i < this.bp.length; ++i) {
            if (delta > this.bp[i]) continue;
            index2 = i * 2;
            break;
        }
        this.stats.incInt(this.statCounterIndex[index2], 1);
        this.stats.incLong(this.statCounterIndex[index2 + 1], delta);
    }
}

