/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.SmHelper;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SystemAdmin;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URL;
import java.security.CodeSource;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GemFireVersion {
    private static String RESOURCE_NAME = "GemFireVersion.properties";
    private static GemFireVersion instance;
    private static final String PRODUCT_NAME = "Product-Name";
    private static final String GEMFIRE_VERSION = "Product-Version";
    private static final String SOURCE_DATE = "Source-Date";
    private static final String SOURCE_REVISION = "Source-Revision";
    private static final String SOURCE_REPOSITORY = "Source-Repository";
    private static final String BUILD_DATE = "Build-Date";
    private static final String BUILD_ID = "Build-Id";
    private static final String BUILD_PLATFORM = "Build-Platform";
    private static final String BUILD_JAVA_VERSION = "Build-Java-Version";
    private String error = null;
    private String productName;
    private String gemfireVersion;
    private String nativeVersion;
    private String sourceDate;
    private String sourceRevision;
    private String sourceRepository;
    private String buildDate;
    private String buildId;
    private String buildPlatform;
    private String buildJavaVersion;
    private static final String VER_FILE_NAME = "GemFireVersion.properties";
    private static final String JAR_VER_NAME = "gemfire.jar";
    private static final Pattern MAJOR_MINOR;
    private static final Pattern RELEASE;
    private static final Pattern MAJOR_MINOR_RELEASE;

    private static GemFireVersion getInstance() {
        if (instance == null) {
            instance = new GemFireVersion();
        }
        return instance;
    }

    public static String getProductName() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.productName;
    }

    public static String getGemFireVersion() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.gemfireVersion;
    }

    private static String stripSpaces(String s) {
        StringBuffer result = new StringBuffer(s);
        while (result.charAt(0) == ' ') {
            result.deleteCharAt(0);
        }
        while (result.charAt(result.length() - 1) == ' ') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static String getNativeCodeVersion() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.nativeVersion;
    }

    public static String getJavaCodeVersion() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        StringBuffer result = new StringBuffer(80);
        result.append(GemFireVersion.getGemFireVersion()).append(' ').append(GemFireVersion.getBuildId()).append(' ').append(GemFireVersion.getBuildDate()).append(" javac ").append(GemFireVersion.getBuildJavaVersion());
        return result.toString();
    }

    public static String getSourceDate() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.sourceDate;
    }

    public static String getSourceRevision() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.sourceRevision;
    }

    public static String getSourceRepository() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.sourceRepository;
    }

    public static String getBuildDate() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildDate;
    }

    public static String getBuildId() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildId;
    }

    public static String getBuildPlatform() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildPlatform;
    }

    public static String getBuildJavaVersion() {
        GemFireVersion v = GemFireVersion.getInstance();
        if (v.error != null) {
            return v.error;
        }
        return v.buildJavaVersion;
    }

    private GemFireVersion() {
        String name = GemFireVersion.class.getPackage().getName().replace('.', '/');
        name = name + "/" + RESOURCE_NAME;
        InputStream is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), name);
        if (is == null) {
            this.error = LocalizedStrings.GemFireVersion_COULD_NOT_FIND_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0.toLocalizedString(RESOURCE_NAME);
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (Exception ex) {
            this.error = LocalizedStrings.GemFireVersion_COULD_NOT_READ_PROPERTIES_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_0_BECAUSE_1.toLocalizedString(RESOURCE_NAME, ex);
            return;
        }
        this.nativeVersion = SmHelper.getNativeVersion();
        this.productName = props.getProperty(PRODUCT_NAME);
        if (this.productName == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(PRODUCT_NAME, RESOURCE_NAME);
            return;
        }
        this.gemfireVersion = props.getProperty(GEMFIRE_VERSION);
        if (this.gemfireVersion == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(GEMFIRE_VERSION, RESOURCE_NAME);
            return;
        }
        this.sourceDate = props.getProperty(SOURCE_DATE);
        if (this.sourceDate == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_DATE, RESOURCE_NAME);
            return;
        }
        this.sourceRevision = props.getProperty(SOURCE_REVISION);
        if (this.sourceRevision == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REVISION, RESOURCE_NAME);
            return;
        }
        this.sourceRepository = props.getProperty(SOURCE_REPOSITORY);
        if (this.sourceRepository == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(SOURCE_REPOSITORY, RESOURCE_NAME);
            return;
        }
        this.buildDate = props.getProperty(BUILD_DATE);
        if (this.buildDate == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_DATE, RESOURCE_NAME);
            return;
        }
        this.buildId = props.getProperty(BUILD_ID);
        if (this.buildId == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_ID, RESOURCE_NAME);
            return;
        }
        this.buildPlatform = props.getProperty(BUILD_PLATFORM);
        if (this.buildPlatform == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_PLATFORM, RESOURCE_NAME);
            return;
        }
        this.buildJavaVersion = props.getProperty(BUILD_JAVA_VERSION);
        if (this.buildJavaVersion == null) {
            this.error = LocalizedStrings.GemFireVersion_MISSING_PROPERTY_0_FROM_RESOURCE_COM_GEMSTONE_GEMFIRE_INTERNAL_1.toLocalizedString(BUILD_JAVA_VERSION, RESOURCE_NAME);
            return;
        }
    }

    public static URL getJarURL() {
        File gemfireJar;
        String jar;
        CodeSource cs = GemFireVersion.class.getProtectionDomain().getCodeSource();
        if (cs != null) {
            return cs.getLocation();
        }
        URL csLoc = null;
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            jar = tokenizer.nextToken();
            if (jar.indexOf(JAR_VER_NAME) == -1) continue;
            gemfireJar = new File(jar);
            try {
                csLoc = gemfireJar.toURL();
            }
            catch (Exception e) {}
            break;
        }
        if (csLoc != null) {
            return csLoc;
        }
        tokenizer = new StringTokenizer(System.getProperty("sun.boot.class.path"), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            jar = tokenizer.nextToken();
            if (jar.indexOf(JAR_VER_NAME) == -1) continue;
            gemfireJar = new File(jar);
            try {
                csLoc = gemfireJar.toURL();
            }
            catch (Exception e) {}
            break;
        }
        return csLoc;
    }

    public static void createVersionFile() {
        String jarVersion = GemFireVersion.stripSpaces(GemFireVersion.getJavaCodeVersion());
        File libDir = SystemAdmin.findGemFireLibDir();
        if (libDir == null) {
            throw new RuntimeException(LocalizedStrings.GemFireVersion_COULD_NOT_DETERMINE_PRODUCT_LIB_DIRECTORY.toLocalizedString());
        }
        File versionPropFile = new File(libDir, VER_FILE_NAME);
        Properties props = new Properties();
        props.setProperty(JAR_VER_NAME, jarVersion);
        try {
            FileOutputStream out = new FileOutputStream(versionPropFile);
            props.store(out, "Expected versions for this product build as of");
            out.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(LocalizedStrings.GemFireVersion_COULD_NOT_WRITE_0_BECAUSE_1.toLocalizedString(versionPropFile, ex.toString()));
        }
        System.out.println("Created \"" + versionPropFile + "\"");
    }

    public static String asString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        GemFireVersion.print(pw);
        pw.flush();
        return sw.toString();
    }

    public static void print(PrintWriter pw) {
        GemFireVersion.print(pw, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(PrintWriter pw, boolean printSourceInfo) {
        File versionPropFile;
        String jarVersion = GemFireVersion.stripSpaces(GemFireVersion.getJavaCodeVersion());
        pw.println("Java version:   " + jarVersion);
        String libVersion = GemFireVersion.stripSpaces(GemFireVersion.getNativeCodeVersion());
        pw.println("Native version: " + libVersion);
        File libDir = SystemAdmin.findGemFireLibDir();
        if (libDir != null && (versionPropFile = new File(libDir, VER_FILE_NAME)).exists()) {
            try {
                Properties props = new Properties();
                try (FileInputStream inStream = new FileInputStream(versionPropFile);){
                    props.load(inStream);
                }
                String expectedJarVersion = props.getProperty(JAR_VER_NAME);
                if (expectedJarVersion != null && !expectedJarVersion.equals(jarVersion)) {
                    pw.println(LocalizedStrings.GemFireVersion_WARNING_EXPECTED_JAVA_VERSION_0.toLocalizedString(expectedJarVersion));
                }
            }
            catch (IOException ex) {
                pw.println(LocalizedStrings.GemFireVersion_WARNING_FAILED_TO_READ_0_BECAUSE_1.toLocalizedString(versionPropFile, ex));
            }
        }
        if (printSourceInfo) {
            String sourceRevision = GemFireVersion.getSourceRevision();
            pw.println("Source revision: " + sourceRevision);
            String sourceRepository = GemFireVersion.getSourceRepository();
            pw.println("Source repository: " + sourceRepository);
        }
        InetAddress host = null;
        try {
            host = SocketCreator.getLocalHost();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        int cpuCount = Runtime.getRuntime().availableProcessors();
        pw.println(LocalizedStrings.GemFireVersion_RUNNING_ON_0.toLocalizedString(host + ", " + cpuCount + " cpu(s)" + ", " + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version")));
    }

    public static void print(PrintStream ps) {
        GemFireVersion.print(ps, true);
    }

    public static void print(PrintStream ps, boolean printSourceInfo) {
        PrintWriter pw = new PrintWriter(ps);
        GemFireVersion.print(pw, printSourceInfo);
        pw.flush();
    }

    public static void main(String[] args) {
        GemFireVersion.print(System.out);
    }

    public static int getMajorVersion(String v) {
        String digits;
        int majorVersion = 0;
        Matcher m = MAJOR_MINOR.matcher(v);
        if (m.matches() && (digits = m.group(1)) != null && digits.length() > 0) {
            majorVersion = Integer.decode(digits);
        }
        return majorVersion;
    }

    public static int getMinorVersion(String v) {
        String digits;
        int minorVersion = 0;
        Matcher m = MAJOR_MINOR.matcher(v);
        if (m.matches() && (digits = m.group(2)) != null && digits.length() > 0) {
            minorVersion = Integer.decode(digits);
        }
        return minorVersion;
    }

    public static int getRelease(String v) {
        String digits;
        String others;
        Matcher r;
        int release = 0;
        Matcher m = MAJOR_MINOR.matcher(v);
        if (m.matches() && (r = RELEASE.matcher(others = m.group(3))).matches() && (digits = r.group(1)) != null && digits.length() > 0) {
            try {
                release = Integer.decode(digits);
            }
            catch (NumberFormatException e) {
                release = 0;
            }
        }
        return release;
    }

    public static int getBuild(String v) {
        String digits;
        String buildStr;
        Matcher b;
        int build = 0;
        Matcher m = MAJOR_MINOR_RELEASE.matcher(v);
        if (m.matches() && (b = RELEASE.matcher(buildStr = m.group(4))).matches() && (digits = b.group(1)) != null && digits.length() > 0) {
            try {
                build = Integer.decode(digits);
            }
            catch (NumberFormatException e) {
                build = 0;
            }
        }
        return build;
    }

    public static int compareVersions(String v1, String v2) {
        return GemFireVersion.compareVersions(v1, v2, true);
    }

    public static int compareVersions(String v1, String v2, boolean includeBuild) {
        if (v1 == null && v2 != null) {
            return -1;
        }
        if (v1 != null && v2 == null) {
            return 1;
        }
        if (v1 == null && v2 == null) {
            return 0;
        }
        int major1 = GemFireVersion.getMajorVersion(v1);
        int major2 = GemFireVersion.getMajorVersion(v2);
        int minor1 = GemFireVersion.getMinorVersion(v1);
        int minor2 = GemFireVersion.getMinorVersion(v2);
        int release1 = GemFireVersion.getRelease(v1);
        int release2 = GemFireVersion.getRelease(v2);
        if (major1 > major2) {
            return 1;
        }
        if (major1 < major2) {
            return -1;
        }
        if (minor1 > minor2) {
            return 1;
        }
        if (minor1 < minor2) {
            return -1;
        }
        if (release1 > release2) {
            return 1;
        }
        if (release1 < release2) {
            return -1;
        }
        if (includeBuild) {
            int build2;
            int build1 = GemFireVersion.getBuild(v1);
            if (build1 > (build2 = GemFireVersion.getBuild(v2))) {
                return 1;
            }
            if (build1 < build2) {
                return -1;
            }
        }
        return 0;
    }

    static {
        MAJOR_MINOR = Pattern.compile("(\\d+)\\.(\\d*)(.*)");
        RELEASE = Pattern.compile("\\.(\\d*)(.*)");
        MAJOR_MINOR_RELEASE = Pattern.compile("(\\d+)\\.(\\d*)\\.(\\d*)(.*)");
    }
}

