/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static final long MAX_TRANSFER_SIZE = Long.getLong("gemfire.FileUtil.MAX_TRANSFER_SIZE", 0x100000L);
    public static final boolean USE_NIO = !Boolean.getBoolean("gemfire.FileUtil.USE_OLD_IO");
    public static final String extSeparator = ".";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            dest.mkdir();
            for (File child : FileUtil.listFiles(source)) {
                FileUtil.copy(child, new File(dest, child.getName()));
            }
        } else if (source.exists()) {
            long lm = source.lastModified();
            if (dest.isDirectory()) {
                dest = new File(dest, source.getName());
            }
            try (FileOutputStream fos = new FileOutputStream(dest);
                 FileInputStream fis = new FileInputStream(source);){
                if (USE_NIO) {
                    FileUtil.nioCopy(fos, fis);
                } else {
                    FileUtil.oioCopy(source, fos, fis);
                }
            }
            dest.setExecutable(source.canExecute(), true);
            dest.setLastModified(lm);
        }
    }

    public static File[] listFiles(File dir) {
        File[] result = dir.listFiles();
        if (result == null) {
            result = new File[]{};
        }
        return result;
    }

    public static File[] listFiles(File dir, FilenameFilter filter) {
        File[] result = dir.listFiles(filter);
        if (result == null) {
            result = new File[]{};
        }
        return result;
    }

    private static void nioCopy(FileOutputStream fos, FileInputStream fis) throws IOException {
        long remaining;
        long toTransfer;
        long transferredBytes;
        FileChannel outChannel = fos.getChannel();
        FileChannel inChannel = fis.getChannel();
        long length = inChannel.size();
        long offset = 0L;
        while ((offset += (transferredBytes = inChannel.transferTo(offset, toTransfer = (remaining = length - offset) < MAX_TRANSFER_SIZE ? remaining : MAX_TRANSFER_SIZE, outChannel))) < (length = inChannel.size())) {
        }
    }

    private static void oioCopy(File source, FileOutputStream fos, FileInputStream fis) throws IOException {
        int read;
        int size2 = (int)(source.length() < MAX_TRANSFER_SIZE ? source.length() : MAX_TRANSFER_SIZE);
        byte[] buffer = new byte[size2];
        while ((read = fis.read(buffer)) > 0) {
            fos.write(buffer, 0, read);
        }
    }

    public static void delete(File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            for (File child : FileUtil.listFiles(file)) {
                FileUtil.delete(child);
            }
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete " + file);
        }
    }

    public static void delete(File file, StringBuilder failures) {
        if (file.exists() && file.isDirectory()) {
            for (File child : FileUtil.listFiles(file)) {
                FileUtil.delete(child, failures);
            }
        }
        if (file.exists() && !file.delete() && failures != null) {
            failures.append("Could not delete ").append(file).append('\n');
        }
    }

    public static File find(File baseFile, String regex) {
        if (baseFile.getAbsolutePath().matches(regex)) {
            return baseFile;
        }
        if (baseFile.exists() && baseFile.isDirectory()) {
            for (File child : FileUtil.listFiles(baseFile)) {
                File foundFile = FileUtil.find(child, regex);
                if (foundFile == null) continue;
                return foundFile;
            }
        }
        return null;
    }

    public static List<File> findAll(File baseFile, String regex) {
        ArrayList<File> found = new ArrayList<File>();
        FileUtil.findAll(baseFile, regex, found);
        return found;
    }

    public static void deleteMatching(File baseFile, String regex) {
        if (baseFile.exists() && baseFile.isDirectory()) {
            for (File child : FileUtil.listFiles(baseFile)) {
                if (!child.getName().matches(regex)) continue;
                try {
                    FileUtil.delete(child);
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }

    private static void findAll(File baseFile, String regex, List<File> found) {
        if (baseFile.getAbsolutePath().matches(regex)) {
            found.add(baseFile);
        }
        if (baseFile.exists() && baseFile.isDirectory()) {
            for (File child : FileUtil.listFiles(baseFile)) {
                FileUtil.findAll(child, regex, found);
            }
        }
    }

    public static File removeParent(File parent, File file) {
        String absolutePath = file.getAbsolutePath();
        String parentAbsolutePath = parent.getAbsolutePath();
        String newPath = absolutePath.replace(parentAbsolutePath + "/", "");
        return new File(newPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, File file) throws IOException {
        try (InputStream is = url.openStream();
             FileOutputStream os = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, read);
            }
        }
    }

    public static boolean mkdirs(File file) {
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (!parentFile.exists()) {
            FileUtil.mkdirs(parentFile);
        }
        if (parentFile.exists()) {
            return file.mkdir();
        }
        return false;
    }

    public static String stripOffExtension(String fileName) {
        if (fileName.contains(extSeparator)) {
            return fileName.substring(0, fileName.lastIndexOf(extSeparator));
        }
        return fileName;
    }
}

