/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import java.io.Serializable;

public class ConfigSource
implements Serializable {
    private static final long serialVersionUID = -4097017272431018553L;
    private final Type type;
    private final String description;
    private static final ConfigSource API_SINGLETON = new ConfigSource(Type.API, null);
    private static final ConfigSource SYSPROP_SINGLETON = new ConfigSource(Type.SYSTEM_PROPERTY, null);
    private static final ConfigSource XML_SINGLETON = new ConfigSource(Type.XML, null);
    private static final ConfigSource RUNTIME_SINGLETON = new ConfigSource(Type.RUNTIME, null);
    private static final ConfigSource LAUNCHER_SINGLETON = new ConfigSource(Type.LAUNCHER, null);

    private ConfigSource(Type t, String d) {
        this.type = t;
        this.description = d;
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        String result = this.description;
        if (result == null) {
            switch (this.getType()) {
                case API: {
                    result = "api";
                    break;
                }
                case SYSTEM_PROPERTY: {
                    result = "system property";
                    break;
                }
                case FILE: {
                    result = "file";
                    break;
                }
                case SECURE_FILE: {
                    result = "secure file";
                    break;
                }
                case XML: {
                    result = "cache.xml";
                    break;
                }
                case RUNTIME: {
                    result = "runtime modification";
                    break;
                }
                case LAUNCHER: {
                    result = "launcher";
                }
            }
        }
        return result;
    }

    public static ConfigSource api() {
        return API_SINGLETON;
    }

    public static ConfigSource sysprop() {
        return SYSPROP_SINGLETON;
    }

    public static ConfigSource xml() {
        return XML_SINGLETON;
    }

    public static ConfigSource runtime() {
        return RUNTIME_SINGLETON;
    }

    public static ConfigSource file(String fileName, boolean secure) {
        return new ConfigSource(secure ? Type.SECURE_FILE : Type.FILE, fileName);
    }

    public static ConfigSource launcher() {
        return LAUNCHER_SINGLETON;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigSource other = (ConfigSource)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return this.description;
    }

    public static enum Type {
        API,
        SYSTEM_PROPERTY,
        FILE,
        SECURE_FILE,
        XML,
        RUNTIME,
        LAUNCHER;

    }
}

