/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class AvailablePortTask
extends Task {
    private String protocolString = null;
    private String property = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        int protocol;
        Project proj = this.getProject();
        if (this.protocolString == null) {
            throw new BuildException(LocalizedStrings.AvailablePortTask_MISSING_PROTOCOL.toLocalizedString());
        }
        if (this.protocolString.equalsIgnoreCase("JGROUPS")) {
            protocol = 1;
        } else if (this.protocolString.equalsIgnoreCase("SOCKET")) {
            protocol = 0;
        } else {
            throw new BuildException(LocalizedStrings.AvailablePortTask_UNKNOWN_PROTOCOL_0.toLocalizedString(this.protocolString));
        }
        if (this.property == null) {
            throw new BuildException(LocalizedStrings.AvailablePortTask_MISSING_PORT_PROPERTY.toLocalizedString());
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            int port = AvailablePort.getRandomAvailablePort(protocol);
            proj.setProperty(this.property, String.valueOf(port));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public void setPortproperty(String property2) {
        this.property = property2;
    }

    public void setProtocol(String protocol) {
        this.protocolString = protocol;
    }
}

