/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;

public class AvailablePort {
    public static final int SOCKET = 0;
    public static final int JGROUPS = 1;
    public static Random rand;
    private static final PrintStream out;
    private static final PrintStream err;

    private static InetAddress getAddress(int protocol) {
        String name = null;
        try {
            if (protocol == 0) {
                name = System.getProperty("gemfire.bind-address");
            } else if (protocol == 1) {
                name = System.getProperty("gemfire.mcast-address");
            }
            if (name != null) {
                return InetAddress.getByName(name);
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to resolve address " + name);
        }
        return null;
    }

    public static boolean isPortAvailable(int port, int protocol) {
        return AvailablePort.isPortAvailable(port, protocol, AvailablePort.getAddress(protocol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isPortAvailable(int port, int protocol, InetAddress addr) {
        if (protocol == 0) {
            if (addr == null) {
                return AvailablePort.testAllInterfaces(port);
            }
            return AvailablePort.testOneInterface(addr, port);
        }
        if (protocol == 1) {
            MulticastSocket socket = null;
            try {
                socket = new MulticastSocket();
                socket.setSoTimeout(Integer.getInteger("AvailablePort.timeout", 2000));
                byte[] buffer = new byte[]{112, 105, 110, 103};
                InetSocketAddress mcaddr = new InetSocketAddress(addr == null ? DistributionConfig.DEFAULT_MCAST_ADDRESS : addr, port);
                DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length, mcaddr);
                socket.send(packet);
                try {
                    socket.receive(packet);
                    packet.getData();
                    boolean bl = false;
                    return bl;
                }
                catch (SocketTimeoutException ste) {
                    boolean bl;
                    block29: {
                        bl = true;
                        if (socket == null) break block29;
                        try {
                            socket.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return bl;
                }
                catch (Exception e) {
                    boolean bl;
                    block30: {
                        e.printStackTrace();
                        bl = false;
                        if (socket == null) break block30;
                        try {
                            socket.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    return bl;
                    {
                        catch (IOException ioe) {
                            if (ioe.getMessage().equals("Network is unreachable")) {
                                throw new RuntimeException(LocalizedStrings.AvailablePort_NETWORK_IS_UNREACHABLE.toLocalizedString(), ioe);
                            }
                            ioe.printStackTrace();
                            boolean bl2 = false;
                            return bl2;
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                            boolean bl3 = false;
                            return bl3;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.AvailablePort_UNKNOWN_PROTOCOL_0.toLocalizedString(protocol));
    }

    public static Keeper isPortKeepable(int port, int protocol, InetAddress addr) {
        if (protocol == 0) {
            if (addr == null) {
                return AvailablePort.keepAllInterfaces(port);
            }
            return AvailablePort.keepOneInterface(addr, port);
        }
        if (protocol == 1) {
            throw new IllegalArgumentException("You can not keep the JGROUPS protocol");
        }
        throw new IllegalArgumentException(LocalizedStrings.AvailablePort_UNKNOWN_PROTOCOL_0.toLocalizedString(protocol));
    }

    private static boolean testOneInterface(InetAddress addr, int port) {
        Keeper k = AvailablePort.keepOneInterface(addr, port);
        if (k != null) {
            k.release();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Keeper keepOneInterface(InetAddress addr, int port) {
        ServerSocket server = null;
        try {
            server = new ServerSocket();
            String osName = System.getProperty("os.name");
            if (osName != null && !osName.startsWith("Windows")) {
                server.setReuseAddress(true);
            }
            if (addr != null) {
                server.bind(new InetSocketAddress(addr, port));
            } else {
                server.bind(new InetSocketAddress(port));
            }
            Keeper result = new Keeper(server, port);
            server = null;
            Keeper keeper = result;
            return keeper;
        }
        catch (IOException ioe) {
            byte[] addrBytes;
            if (ioe.getMessage().equals("Network is unreachable")) {
                throw new RuntimeException("Network is unreachable");
            }
            if (addr instanceof Inet6Address && (addrBytes = addr.getAddress())[0] == -2 && addrBytes[1] == -128) {
                Keeper result = new Keeper(server, port);
                server = null;
                Keeper keeper = result;
                return keeper;
            }
            Keeper keeper = null;
            return keeper;
        }
        catch (Exception ex) {
            Keeper keeper = null;
            return keeper;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static boolean testAllInterfaces(int port) {
        Keeper k = AvailablePort.keepAllInterfaces(port);
        if (k != null) {
            k.release();
            return true;
        }
        return false;
    }

    private static Keeper keepAllInterfaces(int port) {
        Enumeration<NetworkInterface> en;
        if (!AvailablePort.testOneInterface(null, port)) {
            return null;
        }
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (en.hasMoreElements()) {
            NetworkInterface next2 = en.nextElement();
            Enumeration<InetAddress> en2 = next2.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                boolean available = AvailablePort.testOneInterface(addr, port);
                if (available) continue;
                return null;
            }
        }
        return AvailablePort.keepOneInterface(null, port);
    }

    public static int getRandomAvailablePort(int protocol) {
        return AvailablePort.getRandomAvailablePort(protocol, AvailablePort.getAddress(protocol));
    }

    public static Keeper getRandomAvailablePortKeeper(int protocol) {
        return AvailablePort.getRandomAvailablePortKeeper(protocol, AvailablePort.getAddress(protocol));
    }

    public static int getAvailablePortInRange(int rangeBase, int rangeTop, int protocol) {
        return AvailablePort.getAvailablePortInRange(protocol, AvailablePort.getAddress(protocol), rangeBase, rangeTop);
    }

    public static int getRandomAvailablePortWithMod(int protocol, int mod) {
        return AvailablePort.getRandomAvailablePortWithMod(protocol, AvailablePort.getAddress(protocol), mod);
    }

    public static int getRandomAvailablePort(int protocol, InetAddress addr) {
        int port;
        while (!AvailablePort.isPortAvailable(port = AvailablePort.getRandomWildcardBindPortNumber(), protocol, addr)) {
        }
        return port;
    }

    public static Keeper getRandomAvailablePortKeeper(int protocol, InetAddress addr) {
        int port;
        Keeper result;
        while ((result = AvailablePort.isPortKeepable(port = AvailablePort.getRandomWildcardBindPortNumber(), protocol, addr)) == null) {
        }
        return result;
    }

    public static int getAvailablePortInRange(int protocol, InetAddress addr, int rangeBase, int rangeTop) {
        for (int port = rangeBase; port <= rangeTop; ++port) {
            if (!AvailablePort.isPortAvailable(port, protocol, addr)) continue;
            return port;
        }
        return -1;
    }

    public static int getRandomAvailablePortWithMod(int protocol, InetAddress addr, int mod) {
        int port;
        while (!AvailablePort.isPortAvailable(port = AvailablePort.getRandomWildcardBindPortNumber(), protocol, addr) || port % mod != 0) {
        }
        return port;
    }

    private static int getRandomWildcardBindPortNumber() {
        int rangeBase = 20001;
        int rangeTop = 29999;
        return rand.nextInt(rangeTop - rangeBase) + rangeBase;
    }

    private static int getRandomPortNumberInRange(int rangeBase, int rangeTop) {
        return rand.nextInt(rangeTop - rangeBase) + rangeBase;
    }

    public static int getRandomAvailablePortInRange(int rangeBase, int rangeTop, int protocol) {
        int numberOfPorts = rangeTop - rangeBase;
        int numberOfRetrys = numberOfPorts * 5;
        for (int i = 0; i < numberOfRetrys; ++i) {
            int port = rand.nextInt(numberOfPorts + 1) + rangeBase;
            if (!AvailablePort.isPortAvailable(port, protocol, AvailablePort.getAddress(protocol))) continue;
            return port;
        }
        return -1;
    }

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: java AvailablePort socket|jgroups [\"addr\" network-address] [port]");
        err.println("");
        err.println(LocalizedStrings.AvailablePort_THIS_PROGRAM_EITHER_PRINTS_WHETHER_OR_NOT_A_PORT_IS_AVAILABLE_FOR_A_GIVEN_PROTOCOL_OR_IT_PRINTS_OUT_AN_AVAILABLE_PORT_FOR_A_GIVEN_PROTOCOL.toLocalizedString());
        err.println("");
        System.exit(1);
    }

    public static void main(String[] args) {
        int protocol;
        String protocolString = null;
        String addrString = null;
        String portString = null;
        for (int i = 0; i < args.length; ++i) {
            if (protocolString == null) {
                protocolString = args[i];
                continue;
            }
            if (args[i].equals("addr")) {
                addrString = args[++i];
                continue;
            }
            if (portString == null) {
                portString = args[i];
                continue;
            }
            AvailablePort.usage("Spurious command line: " + args[i]);
        }
        if (protocolString == null) {
            AvailablePort.usage("Missing protocol");
            return;
        }
        if (protocolString.equalsIgnoreCase("socket")) {
            protocol = 0;
        } else if (protocolString.equalsIgnoreCase("javagroups") || protocolString.equalsIgnoreCase("jgroups")) {
            protocol = 1;
        } else {
            AvailablePort.usage("Unknown protocol: " + protocolString);
            return;
        }
        InetAddress addr = null;
        if (addrString != null) {
            try {
                addr = InetAddress.getByName(addrString);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (portString != null) {
            int port;
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                AvailablePort.usage("Malformed port: " + portString);
                return;
            }
            out.println("\nPort " + port + " is " + (AvailablePort.isPortAvailable(port, protocol, addr) ? "" : "not ") + "available for a " + protocolString + " connection\n");
        } else {
            out.println("\nRandomly selected " + protocolString + " port: " + AvailablePort.getRandomAvailablePort(protocol, addr) + "\n");
        }
    }

    static {
        boolean fast = Boolean.getBoolean("AvailablePort.fastRandom");
        rand = fast ? new Random() : new SecureRandom();
        out = System.out;
        err = System.err;
    }

    public static class Keeper {
        private final ServerSocket ss;
        private final int port;

        public Keeper(ServerSocket ss, int port) {
            this.ss = ss;
            this.port = port;
        }

        public Keeper(ServerSocket ss, Integer port) {
            this.ss = ss;
            this.port = port != null ? port : 0;
        }

        public int getPort() {
            return this.port;
        }

        public void release() {
            try {
                if (this.ss != null) {
                    this.ss.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

