/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.jgroup;

import com.gemstone.gemfire.distributed.internal.membership.QuorumChecker;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.stack.IpAddress;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class QuorumCheckerImpl
implements QuorumChecker {
    private static final Logger logger = LogService.getLogger();
    private View lastView;
    private volatile DatagramSocket sock;
    private AtomicBoolean stopper = new AtomicBoolean();
    private Thread pingResponder;
    private int partitionThreshold;
    private Set<IpAddress> receivedAcks;
    private Map<SocketAddress, IpAddress> addressConversionMap;
    private volatile boolean suspended;
    private boolean quorumAchieved;

    @Override
    public void suspend() {
        this.suspended = true;
    }

    @Override
    public void resume() {
        this.suspended = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean checkForQuorum(long timeout) throws InterruptedException {
        if (this.quorumAchieved) {
            return true;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.sock == null || this.sock.isClosed()) {
            if (isDebugEnabled) {
                logger.debug("quorum check: UDP socket is closed.  Unable to perform a quorum check");
            }
            return false;
        }
        boolean wasSuspended = this.suspended;
        if (this.suspended) {
            this.suspended = false;
        }
        byte[] buffer = new byte[]{112, 105, 110, 103};
        if (isDebugEnabled) {
            logger.debug("beginning quorum check with {}", this);
        }
        try {
            Vector members = this.lastView.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                IpAddress addr = (IpAddress)members.get(i);
                if (this.receivedAcks.contains(addr)) continue;
                InetSocketAddress sockaddr = new InetSocketAddress(addr.getIpAddress(), addr.getPort());
                if (isDebugEnabled) {
                    logger.debug("quorum check: sending request to {}", addr);
                }
                try {
                    DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length, sockaddr);
                    this.sock.send(packet);
                    continue;
                }
                catch (IOException io) {
                    // empty catch block
                }
            }
            long endTime = System.currentTimeMillis() + timeout;
            while (true) {
                long time;
                long remaining;
                if ((remaining = endTime - (time = System.currentTimeMillis())) <= 0L) {
                    if (!isDebugEnabled) break;
                    logger.debug("quorum check: timeout waiting for responses.  {} responses received", this.receivedAcks.size());
                    break;
                }
                if (isDebugEnabled) {
                    logger.debug("quorum check: waiting up to {}ms to receive a quorum of responses", remaining);
                }
                Thread.sleep(500L);
                if (this.receivedAcks.size() != members.size()) continue;
                if (isDebugEnabled) {
                    logger.debug("quorum check: received responses from all members that were in the old distributed system");
                }
                this.quorumAchieved = true;
                boolean bl = true;
                return bl;
            }
            int weight = GMS.getWeight(this.lastView.getMembers(), this.lastView.getLeadMember());
            int ackedWeight = GMS.getWeight(this.receivedAcks, this.lastView.getLeadMember());
            int lossThreshold = (int)Math.round((double)(weight * this.partitionThreshold) / 100.0);
            if (isDebugEnabled) {
                logger.debug("quorum check: contacted {} processes with {} member weight units.  Threshold for a quorum is {}", this.receivedAcks.size(), ackedWeight, lossThreshold);
            }
            boolean bl = this.quorumAchieved = ackedWeight >= lossThreshold;
            return bl;
        }
        finally {
            if (wasSuspended) {
                this.suspended = true;
            }
        }
    }

    @Override
    public Object getMembershipInfo() {
        if (this.sock == null || this.sock.isClosed()) {
            return null;
        }
        return this.sock;
    }

    protected QuorumCheckerImpl(View jgView, int partitionThreshold, DatagramSocket jgSock) {
        this.sock = jgSock;
        this.lastView = jgView;
        this.partitionThreshold = partitionThreshold;
    }

    protected void initialize() {
        if (this.sock == null || this.sock.isClosed()) {
            return;
        }
        this.receivedAcks = new ConcurrentHashSet<IpAddress>(this.lastView.size());
        this.addressConversionMap = new ConcurrentHashMap<SocketAddress, IpAddress>(this.lastView.size());
        Vector members = this.lastView.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            IpAddress addr = (IpAddress)members.get(i);
            InetSocketAddress sockaddr = new InetSocketAddress(addr.getIpAddress(), addr.getPort());
            this.addressConversionMap.put(sockaddr, addr);
        }
        this.startPingResponder();
    }

    private void startPingResponder() {
        this.stopper.set(false);
        this.pingResponder = new Thread("GemFire Auto-reconnect responder"){

            @Override
            public void run() {
                byte[] pongBuffer = new byte[]{112, 111, 110, 103};
                byte[] buffer = new byte[100];
                while (!QuorumCheckerImpl.this.stopper.get()) {
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    try {
                        boolean sleep = QuorumCheckerImpl.this.suspended;
                        if (sleep) {
                            try {
                                Thread.sleep(2000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        QuorumCheckerImpl.this.sock.receive(packet);
                        SocketAddress senderSockAddr = packet.getSocketAddress();
                        logger.info("received {} bytes from {}", packet.getLength(), senderSockAddr);
                        if (packet.getLength() != 4) continue;
                        if (buffer[0] == 112 && buffer[1] == 105 && buffer[2] == 110 && buffer[3] == 103) {
                            logger.info("received ping-pong request from {} - sending response", senderSockAddr);
                            DatagramPacket response = new DatagramPacket(pongBuffer, pongBuffer.length, senderSockAddr);
                            QuorumCheckerImpl.this.sock.send(response);
                            continue;
                        }
                        if (buffer[0] != 112 || buffer[1] != 111 || buffer[2] != 110 || buffer[3] != 103) continue;
                        QuorumCheckerImpl.this.pongReceived(senderSockAddr);
                    }
                    catch (IOException e) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
            }
        };
        this.pingResponder.setDaemon(true);
        this.pingResponder.start();
    }

    public void pongReceived(SocketAddress senderSockAddr) {
        logger.info("received ping-pong response from {}", senderSockAddr);
        IpAddress memberAddr = this.addressConversionMap.get(senderSockAddr);
        if (memberAddr != null) {
            logger.info("quorum check: mapped address to member ID {}", memberAddr);
            this.receivedAcks.add(memberAddr);
        }
    }

    protected void teardown() {
        if (this.sock != null) {
            this.stopper.set(true);
        }
    }

    public String toString() {
        if (this.sock != null) {
            return "QuorumChecker(port=" + this.sock.getLocalPort() + "; view=" + this.lastView + ")";
        }
        return "QuorumChecker(disabled; view=" + this.lastView + ")";
    }
}

