/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership;

import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.HashMap;
import java.util.Map;

public class InternalRole
implements Role {
    private final String name;
    private static final Map roles = new HashMap();

    private InternalRole(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Role o) {
        if (o == null || !(o instanceof InternalRole)) {
            throw new ClassCastException(LocalizedStrings.InternalRole_INTERNALROLECOMPARETO_COMPARISON_BETWEEN_DIFFERENT_CLASSES.toLocalizedString());
        }
        InternalRole other = (InternalRole)o;
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof InternalRole)) {
            return false;
        }
        InternalRole that = (InternalRole)other;
        return this.name == that.name || this.name != null && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalRole getRole(String name) {
        Map map = roles;
        synchronized (map) {
            InternalRole role = (InternalRole)roles.get(name);
            if (role == null) {
                role = new InternalRole(name);
                roles.put(name, role);
            }
            return role;
        }
    }

    @Override
    public boolean isPresent() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys == null) {
            throw new IllegalStateException(LocalizedStrings.InternalRole_ISPRESENT_REQUIRES_A_CONNECTION_TO_THE_DISTRIBUTED_SYSTEM.toLocalizedString());
        }
        DM dm = sys.getDistributionManager();
        return dm.isRolePresent(this);
    }

    @Override
    public int getCount() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys == null) {
            throw new IllegalStateException(LocalizedStrings.InternalRole_GETCOUNT_REQUIRES_A_CONNECTION_TO_THE_DISTRIBUTED_SYSTEM.toLocalizedString());
        }
        DM dm = sys.getDistributionManager();
        return dm.getRoleCount(this);
    }

    public String toString() {
        return this.name;
    }
}

