/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.locks.DLockGrantor;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.LockGrantorDestroyedException;
import com.gemstone.gemfire.distributed.internal.locks.LockGrantorId;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class NonGrantorDestroyedProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private NonGrantorDestroyedReplyMessage reply;

    static boolean send(String serviceName, LockGrantorId theLockGrantorId, DM dm) {
        InternalDistributedMember recipient = theLockGrantorId.getLockGrantorMember();
        NonGrantorDestroyedProcessor processor = new NonGrantorDestroyedProcessor(dm, recipient);
        NonGrantorDestroyedMessage.send(serviceName, recipient, dm, processor);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleAsUnexpected();
        }
        return processor.informedGrantor();
    }

    private NonGrantorDestroyedProcessor(DM dm, InternalDistributedMember grantor) {
        super(dm, grantor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionMessage msg) {
        try {
            Assert.assertTrue(msg instanceof NonGrantorDestroyedReplyMessage, "NonGrantorDestroyedProcessor is unable to process message of type " + msg.getClass());
            this.reply = (NonGrantorDestroyedReplyMessage)msg;
        }
        finally {
            super.process(msg);
        }
    }

    public boolean informedGrantor() {
        return this.reply != null && this.reply.isOK();
    }

    @Override
    protected boolean allowReplyFromSender() {
        return true;
    }

    public static final class NonGrantorDestroyedReplyMessage
    extends ReplyMessage {
        public static final byte OK = 0;
        public static final byte NOT_GRANTOR = 1;
        private byte replyCode;

        public static void send(MessageWithReply destroyedMsg, byte replyCode, DM dm) {
            NonGrantorDestroyedReplyMessage m = new NonGrantorDestroyedReplyMessage();
            m.processorId = destroyedMsg.getProcessorId();
            m.setRecipient(destroyedMsg.getSender());
            m.replyCode = replyCode;
            if (dm.getId().equals(destroyedMsg.getSender())) {
                m.setSender(destroyedMsg.getSender());
                m.dmProcess(dm);
            } else {
                dm.putOutgoing(m);
            }
        }

        public boolean isOK() {
            return this.replyCode == 0;
        }

        public static String replyCodeToString(int replyCode) {
            String s = null;
            switch (replyCode) {
                case 0: {
                    s = "OK";
                    break;
                }
                case 1: {
                    s = "NOT_GRANTOR";
                    break;
                }
                default: {
                    s = "UNKNOWN:" + String.valueOf(replyCode);
                }
            }
            return s;
        }

        @Override
        public int getDSFID() {
            return -70;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.replyCode = in.readByte();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeByte(this.replyCode);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("NonGrantorDestroyedReplyMessage").append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append("; replyCode=").append(NonGrantorDestroyedReplyMessage.replyCodeToString(this.replyCode)).append(")");
            return buff.toString();
        }
    }

    public static final class NonGrantorDestroyedMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private String serviceName;

        protected static void send(String serviceName, InternalDistributedMember grantor, DM dm, ReplyProcessor21 proc) {
            Assert.assertTrue(grantor != null, "Cannot send NonGrantorDestroyedMessage to null grantor");
            NonGrantorDestroyedMessage msg = new NonGrantorDestroyedMessage();
            msg.serviceName = serviceName;
            msg.processorId = proc.getProcessorId();
            msg.setRecipient(grantor);
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "NonGrantorDestroyedMessage sending {} to {}", msg, grantor);
            }
            if (grantor.equals(dm.getId())) {
                msg.setSender(dm.getId());
                msg.processLocally(dm);
            } else {
                dm.putOutgoing(msg);
            }
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        private void reply(byte replyCode, DM dm) {
            NonGrantorDestroyedReplyMessage.send(this, replyCode, dm);
        }

        @Override
        protected void process(DistributionManager dm) {
            this.basicProcess(dm);
        }

        protected void processLocally(DM dm) {
            this.basicProcess(dm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void basicProcess(DM dm) {
            boolean replied = false;
            try {
                DLockGrantor grantor;
                DLockService svc = DLockService.getInternalServiceNamed(this.serviceName);
                if (svc != null && svc.isCurrentlyOrIsMakingLockGrantor() && (grantor = DLockGrantor.waitForGrantor(svc)) != null) {
                    grantor.handleDepartureOf(this.getSender());
                    if (!grantor.isDestroyed()) {
                        this.reply((byte)0, dm);
                        replied = true;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "Processing of NonGrantorDestroyedMessage resulted in InterruptedException", (Throwable)e);
                }
            }
            catch (LockServiceDestroyedException e) {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "Processing of NonGrantorDestroyedMessage resulted in LockServiceDestroyedException", (Throwable)e);
                }
            }
            catch (LockGrantorDestroyedException e) {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "Processing of NonGrantorDestroyedMessage resulted in LockGrantorDestroyedException", (Throwable)e);
                }
            }
            finally {
                if (!replied) {
                    this.reply((byte)1, dm);
                }
            }
        }

        @Override
        public int getDSFID() {
            return 123;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.serviceName = DataSerializer.readString(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            DataSerializer.writeString(this.serviceName, out);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("NonGrantorDestroyedMessage (serviceName='").append(this.serviceName).append("' processorId=").append(this.processorId).append(")");
            return buff.toString();
        }
    }
}

