/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.deadlock.Dependency;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyMonitor;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyMonitorManager;
import com.gemstone.gemfire.distributed.internal.deadlock.UnsafeThreadLocal;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MessageDependencyMonitor
implements DependencyMonitor {
    private final UnsafeThreadLocal<ReplyProcessor21> waitingProcessors = new UnsafeThreadLocal();
    private final UnsafeThreadLocal<MessageWithReply> processingMessages = new UnsafeThreadLocal();
    public static final MessageDependencyMonitor INSTANCE = new MessageDependencyMonitor();

    public static void waitingForReply(ReplyProcessor21 reply) {
        MessageDependencyMonitor.INSTANCE.waitingProcessors.set(reply);
    }

    public static void doneWaiting(ReplyProcessor21 reply) {
        MessageDependencyMonitor.INSTANCE.waitingProcessors.set(null);
    }

    public static void processingMessage(DistributionMessage message) {
        if (message instanceof MessageWithReply) {
            MessageDependencyMonitor.INSTANCE.processingMessages.set((MessageWithReply)((Object)message));
        }
    }

    public static void doneProcessing(DistributionMessage message) {
        if (message instanceof MessageWithReply) {
            MessageDependencyMonitor.INSTANCE.processingMessages.set(null);
        }
    }

    @Override
    public Set<Dependency<Thread, Serializable>> getBlockedThreads(Thread[] allThreads) {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (system == null) {
            return Collections.emptySet();
        }
        InternalDistributedMember myId = system.getDistributedMember();
        HashSet<Dependency<Thread, Serializable>> blockedThreads = new HashSet<Dependency<Thread, Serializable>>();
        for (Thread thread : allThreads) {
            ReplyProcessor21 processor = this.waitingProcessors.get(thread);
            if (processor == null || processor.getProcessorId() <= 0) continue;
            blockedThreads.add(new Dependency<Thread, MessageKey>(thread, new MessageKey(myId, processor.getProcessorId())));
        }
        return blockedThreads;
    }

    @Override
    public Set<Dependency<Serializable, Thread>> getHeldResources(Thread[] allThreads) {
        HashSet<Dependency<Serializable, Thread>> heldResources = new HashSet<Dependency<Serializable, Thread>>();
        for (Thread thread : allThreads) {
            MessageWithReply message = this.processingMessages.get(thread);
            if (message == null || message.getProcessorId() <= 0) continue;
            heldResources.add(new Dependency<MessageKey, Thread>(new MessageKey(message.getSender(), message.getProcessorId()), thread));
        }
        return heldResources;
    }

    static {
        DependencyMonitorManager.addMonitor(INSTANCE);
    }

    private static class MessageKey
    implements Serializable {
        private final InternalDistributedMember myId;
        private final int processorId;

        public MessageKey(InternalDistributedMember myId, int processorId) {
            this.myId = myId;
            this.processorId = processorId;
        }

        public InternalDistributedMember getMyId() {
            return this.myId;
        }

        public int getProcessorId() {
            return this.processorId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myId == null ? 0 : this.myId.hashCode());
            result = 31 * result + this.processorId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MessageKey)) {
                return false;
            }
            MessageKey other = (MessageKey)obj;
            if (this.myId == null ? other.myId != null : !this.myId.equals(other.myId)) {
                return false;
            }
            return this.processorId == other.processorId;
        }

        public String toString() {
            return "MessageFrom(" + this.myId + ", " + this.processorId + ")";
        }
    }
}

