/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.distributed.internal.deadlock.ThreadReference;
import java.io.Serializable;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;

public class LocalThread
implements Serializable,
ThreadReference {
    private static final long serialVersionUID = 1L;
    private final Serializable locality;
    private final String threadName;
    private final long threadId;
    private final String threadStack;

    public LocalThread(Serializable locatility, ThreadInfo info) {
        this.locality = locatility;
        this.threadName = info.getThreadName();
        this.threadStack = this.generateThreadStack(info);
        this.threadId = info.getThreadId();
    }

    private String generateThreadStack(ThreadInfo info) {
        StringBuilder result = new StringBuilder();
        result.append(info.getThreadName()).append(" ID=").append(info.getThreadId()).append(" state=").append((Object)info.getThreadState());
        if (info.getLockInfo() != null) {
            result.append("\n\twaiting to lock <" + info.getLockInfo() + ">");
        }
        for (StackTraceElement element : info.getStackTrace()) {
            result.append("\n\tat " + element);
            for (MonitorInfo monitor : info.getLockedMonitors()) {
                if (!element.equals(monitor.getLockedStackFrame())) continue;
                result.append("\n\tlocked <" + monitor + ">");
            }
        }
        if (info.getLockedSynchronizers().length > 0) {
            result.append("\nLocked synchronizers:");
            for (LockInfo sync : info.getLockedSynchronizers()) {
                result.append("\n" + sync.getClassName() + "@" + sync.getIdentityHashCode());
            }
        }
        return result.toString();
    }

    public Serializable getLocatility() {
        return this.locality;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadStack() {
        return this.threadStack;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.threadId ^ this.threadId >>> 32);
        result = 31 * result + (this.locality == null ? 0 : this.locality.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalThread)) {
            return false;
        }
        LocalThread other = (LocalThread)obj;
        if (this.threadId != other.threadId) {
            return false;
        }
        return !(this.locality == null ? other.locality != null : !this.locality.equals(other.locality));
    }

    public String toString() {
        return this.locality + ":" + this.threadName;
    }
}

