/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.deadlock.DeadlockDetector;
import com.gemstone.gemfire.distributed.internal.deadlock.Dependency;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyGraph;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class GemFireDeadlockDetector {
    private Set<DistributedMember> targetMembers = null;

    public GemFireDeadlockDetector() {
    }

    public GemFireDeadlockDetector(Set<DistributedMember> targetMembers) {
        this.targetMembers = targetMembers;
    }

    public DependencyGraph find() {
        final DeadlockDetector detector = new DeadlockDetector();
        ResultCollector<HashSet<Dependency>, Serializable> collector = new ResultCollector<HashSet<Dependency>, Serializable>(){

            @Override
            public synchronized Serializable getResult() throws FunctionException {
                return null;
            }

            @Override
            public synchronized Serializable getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
                return null;
            }

            @Override
            public synchronized void addResult(DistributedMember memberID, HashSet<Dependency> resultOfSingleExecution) {
                detector.addDependencies(resultOfSingleExecution);
            }

            @Override
            public void endResults() {
            }

            @Override
            public void clearResults() {
            }
        };
        Execution execution = this.targetMembers != null ? FunctionService.onMembers(this.targetMembers).withCollector(collector) : FunctionService.onMembers(new String[0]).withCollector(collector);
        ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        collector = execution.execute(new CollectDependencyFunction());
        collector.getResult();
        return detector.getDependencyGraph();
    }

    private static class CollectDependencyFunction
    implements Function {
        private static final long serialVersionUID = 6204378622627095817L;

        private CollectDependencyFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public void execute(FunctionContext context) {
            InternalDistributedSystem instance = InternalDistributedSystem.getAnyInstance();
            if (instance == null) {
                context.getResultSender().lastResult(new HashSet());
                return;
            }
            InternalDistributedMember member = instance.getDistributedMember();
            Set<Dependency> dependencies = DeadlockDetector.collectAllDependencies(member);
            context.getResultSender().lastResult((Serializable)((Object)dependencies));
        }

        @Override
        public String getId() {
            return "DetectDeadlock";
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }
}

