/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.OverflowQueueWithDMStats;
import com.gemstone.gemfire.distributed.internal.Sizeable;
import com.gemstone.gemfire.distributed.internal.ThrottledMemQueueStatHelper;
import java.util.Collection;
import java.util.Iterator;

public class ThrottlingMemLinkedQueueWithDMStats
extends OverflowQueueWithDMStats {
    private static final long serialVersionUID = 5425180246954573433L;
    private final int maxMemSize;
    private final int startThrottleMemSize;
    private final int maxSize;
    private final int startThrottleSize;
    private volatile int memSize;

    public ThrottlingMemLinkedQueueWithDMStats(int maxMemSize, int startThrottleMemSize, int maxSize, int startThrottleSize, ThrottledMemQueueStatHelper stats) {
        super(maxSize, stats);
        this.maxMemSize = maxMemSize;
        this.startThrottleMemSize = startThrottleMemSize;
        this.maxSize = maxSize;
        this.startThrottleSize = startThrottleSize;
    }

    public int getThrottleTime() {
        return this.calculateThrottleTime();
    }

    public int getMemSize() {
        return this.memSize;
    }

    private int calculateThrottleTime() {
        int sleep;
        int myMemSize = this.memSize;
        if (myMemSize > this.startThrottleMemSize) {
            sleep = (int)((float)(myMemSize - this.startThrottleMemSize) / (float)(this.maxMemSize - this.startThrottleMemSize) * 100.0f);
        } else {
            int qSize = this.size();
            if (qSize > this.startThrottleSize) {
                sleep = (int)((float)(qSize - this.startThrottleSize) / (float)(this.maxSize - this.startThrottleSize) * 100.0f);
            } else {
                return 0;
            }
        }
        sleep *= sleep / 10 + 1;
        sleep = Math.max(sleep, 1);
        return sleep;
    }

    @Override
    protected void preAdd(Object o) {
        try {
            this.preAddInterruptibly(o);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void preAddInterruptibly(Object o) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!DistributionMessage.isPreciousThread()) {
            long startTime = DistributionStats.getStatTime();
            do {
                try {
                    int sleep = this.calculateThrottleTime();
                    if (sleep > 0) {
                        Thread.sleep(sleep);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (!DistributionStats.enableClockStats) continue;
                long endTime = DistributionStats.getStatTime();
                ((ThrottledMemQueueStatHelper)this.stats).throttleTime(endTime - startTime);
                startTime = endTime;
            } while (this.memSize >= this.maxMemSize || this.size() >= this.maxSize);
            ((ThrottledMemQueueStatHelper)this.stats).incThrottleCount();
        }
        if (o instanceof Sizeable) {
            int mem = ((Sizeable)o).getSize();
            ((ThrottledMemQueueStatHelper)this.stats).addMem(mem);
            this.memSize += mem;
        }
    }

    @Override
    protected void postRemove(Object o) {
        if (o != null && o instanceof Sizeable) {
            int mem = ((Sizeable)o).getSize();
            this.memSize -= mem;
            ((ThrottledMemQueueStatHelper)this.stats).removeMem(mem);
        }
    }

    @Override
    protected void postDrain(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.postRemove(it.next());
        }
    }
}

