/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.StartupMessage;
import com.gemstone.gemfire.distributed.internal.StartupMessageReplyProcessor;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class StartupResponseMessage
extends HighPriorityDistributionMessage
implements AdminMessageType {
    private static final Logger logger = LogService.getLogger();
    protected String rejectionMessage;
    protected int processorId;
    protected boolean responderIsAdmin;
    protected Set interfaces;
    protected Properties usedLicense;
    protected int distributedSystemId;
    protected String redundancyZone;
    protected int[] serializerIds = null;
    protected String[] serializerClasseNames = null;
    protected String[] instantiatorClasseNames = null;
    protected String[] instantiatedClasseNames = null;
    protected int[] instantiatorIds = null;
    protected transient StringBuffer fromDataProblems;
    private static Version[] serializationVersions = new Version[]{Version.GFE_80};

    public StartupResponseMessage() {
    }

    StartupResponseMessage(DistributionManager dm, int processorId, InternalDistributedMember recipient, String rejectionMessage, boolean responderIsAdmin) {
        this.setRecipient(recipient);
        this.setProcessorId(processorId);
        this.rejectionMessage = rejectionMessage;
        this.responderIsAdmin = responderIsAdmin;
        this.interfaces = StartupMessage.getMyAddresses(dm);
        this.distributedSystemId = dm.getDistributedSystemId();
        this.redundancyZone = dm.getRedundancyZone(dm.getId());
        LicenseChecker licenseChecker = dm.getSystem().getLicenseChecker();
        this.usedLicense = licenseChecker != null ? licenseChecker.getLicenseProperties() : new Properties();
        Object[] instantiators = InternalInstantiator.getInstantiatorsForSerialization();
        this.instantiatorClasseNames = new String[instantiators.length];
        this.instantiatedClasseNames = new String[instantiators.length];
        this.instantiatorIds = new int[instantiators.length];
        for (int i = 0; i < instantiators.length; ++i) {
            Object inst;
            if (instantiators[i] instanceof Instantiator) {
                inst = (Instantiator)instantiators[i];
                this.instantiatorClasseNames[i] = inst.getClass().getName();
                this.instantiatedClasseNames[i] = ((Instantiator)inst).getInstantiatedClass().getName();
                this.instantiatorIds[i] = ((Instantiator)inst).getId();
                continue;
            }
            inst = (InternalInstantiator.InstantiatorAttributesHolder)instantiators[i];
            this.instantiatorClasseNames[i] = ((InternalInstantiator.InstantiatorAttributesHolder)inst).getInstantiatorClassName();
            this.instantiatedClasseNames[i] = ((InternalInstantiator.InstantiatorAttributesHolder)inst).getInstantiatedClassName();
            this.instantiatorIds[i] = ((InternalInstantiator.InstantiatorAttributesHolder)inst).getId();
        }
        InternalDataSerializer.SerializerAttributesHolder[] sahs = InternalDataSerializer.getSerializersForDistribution();
        this.serializerIds = new int[sahs.length];
        this.serializerClasseNames = new String[sahs.length];
        for (int i = 0; i < sahs.length; ++i) {
            this.serializerIds[i] = sahs[i].getId();
            this.serializerClasseNames[i] = sahs[i].getClassName();
        }
    }

    public void setProcessorId(int processorId) {
        this.processorId = processorId;
    }

    @Override
    public boolean getInlineProcess() {
        return true;
    }

    @Override
    public boolean sendViaJGroups() {
        return true;
    }

    @Override
    protected void process(DistributionManager dm) {
        LicenseChecker licenseChecker;
        int i;
        if (this.interfaces != null && this.interfaces.size() != 0) {
            dm.setEquivalentHosts(this.interfaces);
        }
        dm.setDistributedSystemId(this.distributedSystemId);
        dm.setRedundancyZone(this.getSender(), this.redundancyZone);
        if (this.fromDataProblems != null && logger.isDebugEnabled()) {
            logger.debug(this.fromDataProblems);
        }
        if (this.serializerIds != null) {
            for (i = 0; i < this.serializerIds.length; ++i) {
                String cName = this.serializerClasseNames[i];
                if (cName == null) continue;
                InternalDataSerializer.register(cName, false, null, null, this.serializerIds[i]);
            }
        }
        if (this.instantiatorIds != null) {
            for (i = 0; i < this.instantiatorIds.length; ++i) {
                String instantiatorClassName = this.instantiatorClasseNames[i];
                String instantiatedClassName = this.instantiatedClasseNames[i];
                int id = this.instantiatorIds[i];
                if (instantiatorClassName == null || instantiatedClassName == null) continue;
                InternalInstantiator.register(instantiatorClassName, instantiatedClassName, id, false);
            }
        }
        if ((licenseChecker = dm.getSystem().getLicenseChecker()) != null) {
            licenseChecker.checkSerialNumber(this.sender, this.usedLicense);
        }
        dm.processStartupResponse(this.sender, this.rejectionMessage);
        StartupMessageReplyProcessor proc = (StartupMessageReplyProcessor)ReplyProcessor21.getProcessor(this.processorId);
        if (proc != null) {
            if (this.rejectionMessage != null) {
                proc.setReceivedRejectionMessage(true);
            } else {
                if (!this.responderIsAdmin) {
                    proc.setReceivedAcceptance(true);
                }
                proc.process(this);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "{} Processed {}", proc, this);
                }
            }
        }
    }

    @Override
    public int getDSFID() {
        return 97;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        int i;
        super.toData(out);
        out.writeInt(this.processorId);
        DataSerializer.writeString(this.rejectionMessage, out);
        out.writeBoolean(this.responderIsAdmin);
        out.writeInt(this.serializerIds.length);
        for (i = 0; i < this.serializerIds.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(this.serializerClasseNames[i], out);
            out.writeInt(this.serializerIds[i]);
        }
        out.writeInt(this.instantiatorIds.length);
        for (i = 0; i < this.instantiatorIds.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(this.instantiatorClasseNames[i], out);
            DataSerializer.writeNonPrimitiveClassName(this.instantiatedClasseNames[i], out);
            out.writeInt(this.instantiatorIds[i]);
        }
        DataSerializer.writeObject(this.interfaces, out);
        DataSerializer.writeObject(this.usedLicense, out);
        out.writeInt(this.distributedSystemId);
        DataSerializer.writeString(this.redundancyZone, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.rejectionMessage = DataSerializer.readString(in);
        this.responderIsAdmin = in.readBoolean();
        int serializerCount = in.readInt();
        this.serializerClasseNames = new String[serializerCount];
        this.serializerIds = new int[serializerCount];
        for (int i = 0; i < serializerCount; ++i) {
            try {
                this.serializerClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
                continue;
            }
            finally {
                this.serializerIds[i] = in.readInt();
            }
        }
        int instantiatorCount = in.readInt();
        this.instantiatorClasseNames = new String[instantiatorCount];
        this.instantiatedClasseNames = new String[instantiatorCount];
        this.instantiatorIds = new int[instantiatorCount];
        for (int i = 0; i < instantiatorCount; ++i) {
            this.instantiatorClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatedClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatorIds[i] = in.readInt();
        }
        this.interfaces = (Set)DataSerializer.readObject(in);
        this.usedLicense = (Properties)DataSerializer.readObject(in);
        this.distributedSystemId = in.readInt();
        this.redundancyZone = DataSerializer.readString(in);
    }

    private void fromDataProblem(String s) {
        if (this.fromDataProblems == null) {
            this.fromDataProblems = new StringBuffer();
        }
        this.fromDataProblems.append(s);
        this.fromDataProblems.append(System.getProperty("line.separator", "\n"));
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        int i;
        super.toData(out);
        out.writeInt(this.processorId);
        out.writeLong(System.currentTimeMillis());
        DataSerializer.writeString(this.rejectionMessage, out);
        out.writeBoolean(this.responderIsAdmin);
        out.writeInt(this.serializerIds.length);
        for (i = 0; i < this.serializerIds.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(this.serializerClasseNames[i], out);
            out.writeInt(this.serializerIds[i]);
        }
        out.writeInt(this.instantiatorIds.length);
        for (i = 0; i < this.instantiatorIds.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(this.instantiatorClasseNames[i], out);
            DataSerializer.writeNonPrimitiveClassName(this.instantiatedClasseNames[i], out);
            out.writeInt(this.instantiatorIds[i]);
        }
        DataSerializer.writeObject(this.interfaces, out);
        DataSerializer.writeObject(this.usedLicense, out);
        out.writeInt(this.distributedSystemId);
        DataSerializer.writeString(this.redundancyZone, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        in.readLong();
        this.rejectionMessage = DataSerializer.readString(in);
        this.responderIsAdmin = in.readBoolean();
        int serializerCount = in.readInt();
        this.serializerClasseNames = new String[serializerCount];
        this.serializerIds = new int[serializerCount];
        for (int i = 0; i < serializerCount; ++i) {
            try {
                this.serializerClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
                continue;
            }
            finally {
                this.serializerIds[i] = in.readInt();
            }
        }
        int instantiatorCount = in.readInt();
        this.instantiatorClasseNames = new String[instantiatorCount];
        this.instantiatedClasseNames = new String[instantiatorCount];
        this.instantiatorIds = new int[instantiatorCount];
        for (int i = 0; i < instantiatorCount; ++i) {
            this.instantiatorClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatedClasseNames[i] = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatorIds[i] = in.readInt();
        }
        this.interfaces = (Set)DataSerializer.readObject(in);
        this.usedLicense = (Properties)DataSerializer.readObject(in);
        this.distributedSystemId = in.readInt();
        this.redundancyZone = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "StartupResponse: rejectionMessage=" + this.rejectionMessage + " processor=" + this.processorId + " responderIsAdmin=" + this.responderIsAdmin + " distributed system id = " + this.distributedSystemId;
    }
}

