/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.LicenseException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.StartupMessageData;
import com.gemstone.gemfire.distributed.internal.StartupResponseWithVersionMessage;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.tcp.Stub;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class StartupMessage
extends HighPriorityDistributionMessage
implements AdminMessageType {
    private static final Logger logger = LogService.getLogger();
    private Stub directChannel;
    private Properties usedLicense;
    private String version = GemFireVersion.getGemFireVersion();
    private int replyProcessorId;
    private boolean isMcastDiscovery;
    private boolean isMcastEnabled;
    private boolean isTcpDisabled;
    private Set interfaces;
    private int distributedSystemId;
    private String redundancyZone;
    private boolean enforceUniqueZone;
    private Collection<String> hostedLocatorsAll;
    boolean isSharedConfigurationEnabled;
    private int mcastPort;
    private String mcastHostAddress;
    private transient StringBuffer fromDataProblems;

    public static Set getMyAddresses(DistributionManager dm) {
        try {
            Set<InetAddress> addresses = SocketCreator.getMyAddresses();
            return addresses;
        }
        catch (IllegalArgumentException e) {
            logger.fatal(e.getMessage(), (Throwable)e);
            return Collections.EMPTY_SET;
        }
    }

    public StartupMessage() {
    }

    StartupMessage(Collection<String> hostedLocators, boolean isSharedConfigurationEnabled) {
        this.hostedLocatorsAll = hostedLocators;
        this.isSharedConfigurationEnabled = isSharedConfigurationEnabled;
    }

    void setUsedLicense(Properties props) {
        this.usedLicense = props;
    }

    void setDirectChannel(Stub directChannel) {
        this.directChannel = directChannel;
    }

    void setReplyProcessorId(int proc) {
        this.replyProcessorId = proc;
    }

    void setMcastEnabled(boolean flag) {
        this.isMcastEnabled = flag;
    }

    int getMcastPort() {
        return this.mcastPort;
    }

    void setMcastPort(int port) {
        this.mcastPort = port;
    }

    String getMcastHostAddress() {
        return this.mcastHostAddress;
    }

    void setMcastHostAddress(InetAddress addr) {
        String hostAddr = null;
        if (addr != null) {
            hostAddr = addr.getHostAddress();
        }
        this.mcastHostAddress = hostAddr;
    }

    @Override
    public boolean sendViaJGroups() {
        return true;
    }

    void setMcastDiscovery(boolean flag) {
        this.isMcastDiscovery = flag;
    }

    void setTcpDisabled(boolean flag) {
        this.isTcpDisabled = flag;
    }

    void setInterfaces(Set interfaces) {
        this.interfaces = interfaces;
        if (interfaces == null || interfaces.size() == 0) {
            throw new SystemConnectException("Unable to examine network card");
        }
    }

    public void setDistributedSystemId(int distributedSystemId) {
        this.distributedSystemId = distributedSystemId;
    }

    public void setRedundancyZone(String redundancyZone) {
        this.redundancyZone = redundancyZone;
    }

    public void setEnforceUniqueZone(boolean enforceUniqueZone) {
        this.enforceUniqueZone = enforceUniqueZone;
    }

    @Override
    protected void process(DistributionManager dm) {
        LicenseChecker licenseChecker;
        String rejectionMessage = null;
        boolean isAdminDM = dm.getId().getVmKind() == 12 || dm.getId().getVmKind() == 11;
        String myVersion = GemFireVersion.getGemFireVersion();
        String theirVersion = this.version;
        int myMajorVersion = GemFireVersion.getMajorVersion(myVersion);
        int theirMajorVersion = GemFireVersion.getMajorVersion(theirVersion);
        int myMinorVersion = GemFireVersion.getMinorVersion(myVersion);
        int theirMinorVersion = GemFireVersion.getMinorVersion(theirVersion);
        if (myMajorVersion != theirMajorVersion || myMinorVersion != theirMinorVersion) {
            // empty if block
        }
        if (dm.getTransport().isMcastEnabled() != this.isMcastEnabled) {
            rejectionMessage = LocalizedStrings.StartupMessage_REJECTED_NEW_SYSTEM_NODE_0_BECAUSE_ISMCASTENABLED_1_DOES_NOT_MATCH_THE_DISTRIBUTED_SYSTEM_IT_IS_ATTEMPTING_TO_JOIN.toLocalizedString(this.getSender(), this.isMcastEnabled ? "enabled" : "disabled");
        } else if (this.isMcastEnabled && dm.getSystem().getOriginalConfig().getMcastPort() != this.getMcastPort()) {
            rejectionMessage = LocalizedStrings.StartupMessage_REJECTED_NEW_SYSTEM_NODE_0_BECAUSE_MCAST_PORT_1_DOES_NOT_MATCH_THE_DISTRIBUTED_SYSTEM_2_IT_IS_ATTEMPTING_TO_JOIN.toLocalizedString(this.getSender(), this.getMcastPort(), dm.getSystem().getOriginalConfig().getMcastPort());
        } else if (this.isMcastEnabled && !StartupMessage.checkMcastAddress(dm.getSystem().getOriginalConfig().getMcastAddress(), this.getMcastHostAddress())) {
            rejectionMessage = LocalizedStrings.StartupMessage_REJECTED_NEW_SYSTEM_NODE_0_BECAUSE_MCAST_ADDRESS_1_DOES_NOT_MATCH_THE_DISTRIBUTED_SYSTEM_2_IT_IS_ATTEMPTING_TO_JOIN.toLocalizedString(this.getSender(), this.getMcastHostAddress(), dm.getSystem().getOriginalConfig().getMcastAddress());
        } else if (dm.getTransport().isTcpDisabled() != this.isTcpDisabled) {
            rejectionMessage = LocalizedStrings.StartupMessage_REJECTED_NEW_SYSTEM_NODE_0_BECAUSE_ISTCPDISABLED_1_DOES_NOT_MATCH_THE_DISTRIBUTED_SYSTEM_IT_IS_ATTEMPTING_TO_JOIN.toLocalizedString(this.getSender(), this.isTcpDisabled);
        } else if (dm.getDistributedSystemId() != -1 && this.distributedSystemId != -1 && this.distributedSystemId != dm.getDistributedSystemId()) {
            String distributedSystemListener = System.getProperty("gemfire.DistributedSystemListener");
            if (distributedSystemListener != null) {
                if (-this.distributedSystemId != dm.getDistributedSystemId()) {
                    rejectionMessage = LocalizedStrings.StartupMessage_REJECTED_NEW_SYSTEM_NODE_0_BECAUSE_DISTRIBUTED_SYSTEM_ID_1_DOES_NOT_MATCH_THE_DISTRIBUTED_SYSTEM_2_IT_IS_ATTEMPTING_TO_JOIN.toLocalizedString(this.getSender(), this.distributedSystemId, dm.getDistributedSystemId());
                }
            } else {
                rejectionMessage = LocalizedStrings.StartupMessage_REJECTED_NEW_SYSTEM_NODE_0_BECAUSE_DISTRIBUTED_SYSTEM_ID_1_DOES_NOT_MATCH_THE_DISTRIBUTED_SYSTEM_2_IT_IS_ATTEMPTING_TO_JOIN.toLocalizedString(this.getSender(), this.distributedSystemId, dm.getDistributedSystemId());
            }
        } else if (!isAdminDM && this.usedLicense != null && !this.usedLicense.keySet().isEmpty()) {
            try {
                licenseChecker = dm.getSystem().getLicenseChecker();
                if (licenseChecker != null) {
                    licenseChecker.checkMembershipRequest(this.sender, this.usedLicense);
                }
            }
            catch (LicenseException ex) {
                rejectionMessage = ex.getLocalizedMessage();
            }
        }
        if (this.fromDataProblems != null && logger.isDebugEnabled()) {
            logger.debug(this.fromDataProblems);
        }
        if (rejectionMessage == null) {
            if (this.interfaces == null || this.interfaces.size() == 0) {
                StringId msg = LocalizedStrings.StartupMessage_REJECTED_NEW_SYSTEM_NODE_0_BECAUSE_PEER_HAS_NO_NETWORK_INTERFACES;
                rejectionMessage = msg.toLocalizedString(this.getSender());
            } else {
                dm.setEquivalentHosts(this.interfaces);
            }
        }
        if (rejectionMessage != null) {
            logger.warn(rejectionMessage);
        }
        if (rejectionMessage == null) {
            dm.setRedundancyZone(this.getSender(), this.redundancyZone);
            dm.setEnforceUniqueZone(this.enforceUniqueZone);
            if (!isAdminDM && this.usedLicense != null && !this.usedLicense.keySet().isEmpty() && (licenseChecker = dm.getSystem().getLicenseChecker()) != null) {
                licenseChecker.checkSerialNumber(this.sender, this.usedLicense);
            }
            if (this.hostedLocatorsAll != null) {
                dm.addHostedLocators(this.getSender(), this.hostedLocatorsAll, this.isSharedConfigurationEnabled);
            }
        }
        StartupResponseWithVersionMessage m = null;
        m = new StartupResponseWithVersionMessage(dm, this.replyProcessorId, this.getSender(), rejectionMessage, isAdminDM);
        if (logger.isDebugEnabled()) {
            logger.debug("Received StartupMessage from a member with version: {}, my version is:{}", theirVersion, myVersion);
        }
        dm.putOutgoing(m);
        if (rejectionMessage != null) {
            dm.getMembershipManager().startupMessageFailed(this.getSender(), rejectionMessage);
        }
        if (rejectionMessage != null) {
            dm.handleManagerDeparture(this.getSender(), false, rejectionMessage);
        }
    }

    private static boolean checkMcastAddress(InetAddress myMcastAddr, String otherMcastHostAddr) {
        String myMcastHostAddr = null;
        if (myMcastAddr != null) {
            myMcastHostAddr = myMcastAddr.getHostAddress();
        }
        if (myMcastHostAddr == otherMcastHostAddr) {
            return true;
        }
        if (myMcastHostAddr == null) {
            return false;
        }
        return myMcastHostAddr.equals(otherMcastHostAddr);
    }

    @Override
    public int getDSFID() {
        return 96;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.directChannel != null);
        if (this.directChannel != null) {
            InternalDataSerializer.invokeToData(this.directChannel, out);
        }
        DataSerializer.writeObject(this.usedLicense, out);
        DataSerializer.writeString(this.version, out);
        out.writeInt(this.replyProcessorId);
        out.writeBoolean(this.isMcastEnabled);
        out.writeBoolean(this.isMcastDiscovery);
        out.writeBoolean(this.isTcpDisabled);
        InternalDataSerializer.SerializerAttributesHolder[] sahs = InternalDataSerializer.getSerializersForDistribution();
        out.writeInt(sahs.length);
        for (int i = 0; i < sahs.length; ++i) {
            DataSerializer.writeNonPrimitiveClassName(sahs[i].getClassName(), out);
            out.writeInt(sahs[i].getId());
        }
        Object[] insts = InternalInstantiator.getInstantiatorsForSerialization();
        out.writeInt(insts.length);
        for (int i = 0; i < insts.length; ++i) {
            int id;
            String instantiatedClassName;
            String instantiatorClassName;
            if (insts[i] instanceof Instantiator) {
                instantiatorClassName = ((Instantiator)insts[i]).getClass().getName();
                instantiatedClassName = ((Instantiator)insts[i]).getInstantiatedClass().getName();
                id = ((Instantiator)insts[i]).getId();
            } else {
                instantiatorClassName = ((InternalInstantiator.InstantiatorAttributesHolder)insts[i]).getInstantiatorClassName();
                instantiatedClassName = ((InternalInstantiator.InstantiatorAttributesHolder)insts[i]).getInstantiatedClassName();
                id = ((InternalInstantiator.InstantiatorAttributesHolder)insts[i]).getId();
            }
            DataSerializer.writeNonPrimitiveClassName(instantiatorClassName, out);
            DataSerializer.writeNonPrimitiveClassName(instantiatedClassName, out);
            out.writeInt(id);
        }
        DataSerializer.writeObject(this.interfaces, out);
        out.writeInt(this.distributedSystemId);
        DataSerializer.writeString(this.redundancyZone, out);
        out.writeBoolean(this.enforceUniqueZone);
        StartupMessageData data = new StartupMessageData();
        data.writeHostedLocators(this.hostedLocatorsAll);
        data.writeIsSharedConfigurationEnabled(this.isSharedConfigurationEnabled);
        data.writeMcastPort(this.mcastPort);
        data.writeMcastHostAddress(this.mcastHostAddress);
        data.toData(out);
    }

    private void fromDataProblem(String s) {
        if (this.fromDataProblems == null) {
            this.fromDataProblems = new StringBuffer();
        }
        this.fromDataProblems.append(s);
        this.fromDataProblems.append("\n\n");
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        boolean hasDirectChannel = in.readBoolean();
        this.directChannel = hasDirectChannel ? Stub.createFromData(in) : null;
        this.usedLicense = (Properties)DataSerializer.readObject(in);
        this.version = DataSerializer.readString(in);
        this.replyProcessorId = in.readInt();
        this.isMcastEnabled = in.readBoolean();
        this.isMcastDiscovery = in.readBoolean();
        this.isTcpDisabled = in.readBoolean();
        int serializerCount = in.readInt();
        for (int i = 0; i < serializerCount; ++i) {
            String cName = DataSerializer.readNonPrimitiveClassName(in);
            int id = in.readInt();
            try {
                if (cName == null) continue;
                InternalDataSerializer.register(cName, false, null, null, id);
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.fromDataProblem(LocalizedStrings.StartupMessage_ILLEGALARGUMENTEXCEPTION_WHILE_REGISTERING_A_DATASERIALIZER_0.toLocalizedString(ex));
            }
        }
        int instantiatorCount = in.readInt();
        for (int i = 0; i < instantiatorCount; ++i) {
            String instantiatorClassName = DataSerializer.readNonPrimitiveClassName(in);
            String instantiatedClassName = DataSerializer.readNonPrimitiveClassName(in);
            int id = in.readInt();
            try {
                if (instantiatorClassName == null || instantiatedClassName == null) continue;
                InternalInstantiator.register(instantiatorClassName, instantiatedClassName, id, false);
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.fromDataProblem(LocalizedStrings.StartupMessage_ILLEGALARGUMENTEXCEPTION_WHILE_REGISTERING_AN_INSTANTIATOR_0.toLocalizedString(ex));
            }
        }
        this.interfaces = (Set)DataSerializer.readObject(in);
        this.distributedSystemId = in.readInt();
        this.redundancyZone = DataSerializer.readString(in);
        this.enforceUniqueZone = in.readBoolean();
        StartupMessageData data = new StartupMessageData(in, this.version);
        this.hostedLocatorsAll = data.readHostedLocators();
        this.isSharedConfigurationEnabled = data.readIsSharedConfigurationEnabled();
        this.mcastPort = data.readMcastPort();
        this.mcastHostAddress = data.readMcastHostAddress();
    }

    @Override
    public String toString() {
        return LocalizedStrings.StartupMessage_STARTUPMESSAGE_DM_0_HAS_STARTED_PROCESSOR_1_WITH_DISTRIBUTED_SYSTEM_ID_2.toLocalizedString(this.getSender(), this.replyProcessorId, this.distributedSystemId);
    }
}

