/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class SerialAckedMessage
extends SerialDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private InternalDistributedMember id;
    private int processorId;
    transient DistributionManager originDm;
    private transient ReplyProcessor21 rp;

    public SerialAckedMessage() {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        if (ds != null) {
            this.originDm = (DistributionManager)ds.getDistributionManager();
            this.id = this.originDm.getDistributionManagerId();
        }
    }

    public void send(Set recipients, boolean multicast) throws InterruptedException, ReplyException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        InternalDistributedMember me = this.originDm.getDistributionManagerId();
        if ((recipients = new HashSet(recipients)).contains(me)) {
            recipients.remove(me);
        }
        if (isDebugEnabled) {
            logger.debug("Recipients for SerialAckedMessage are {}", recipients);
        }
        this.rp = new ReplyProcessor21((DM)this.originDm, recipients);
        this.processorId = this.rp.getProcessorId();
        this.setRecipients(recipients);
        this.setMulticast(multicast);
        Set failures = this.originDm.putOutgoing(this);
        if (failures != null && failures.size() > 0) {
            for (InternalDistributedMember mbr : failures) {
                if (!isDebugEnabled) continue;
                logger.debug("Unable to send serial acked message to {}", mbr);
            }
        }
        this.rp.waitForReplies();
    }

    void setDistributionManagerId(InternalDistributedMember id) {
        this.id = id;
    }

    public void setProcessorId(int pid) {
        this.processorId = pid;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    protected void process(DistributionManager dm) {
        Assert.assertTrue(this.id != null);
        ReplyMessage reply = new ReplyMessage();
        reply.setProcessorId(this.processorId);
        reply.setRecipient(this.getSender());
        dm.putOutgoing(reply);
    }

    @Override
    public int getDSFID() {
        return 2001;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.id, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.id = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "SerialAckedMessage from=" + this.id + ";processorId=" + this.processorId;
    }
}

