/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionConfigSnapshot;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterAppenders;
import java.io.File;

public final class RuntimeDistributionConfigImpl
extends DistributionConfigImpl {
    private static final long serialVersionUID = -805637520096606113L;
    private final transient InternalDistributedSystem ds;

    public RuntimeDistributionConfigImpl(InternalDistributedSystem ds) {
        super(ds.getOriginalConfig());
        this.ds = ds;
        this.modifiable = false;
    }

    @Override
    public void setLogLevel(int value2) {
        this.checkLogLevel(value2);
        this.logLevel = value2;
        this.getAttSourceMap().put("log-level", ConfigSource.runtime());
        this.ds.getInternalLogWriter().setLogWriterLevel(value2);
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    @Override
    public boolean isLogLevelModifiable() {
        return true;
    }

    @Override
    public void setStatisticSamplingEnabled(boolean value2) {
        this.checkStatisticSamplingEnabled(value2);
        this.statisticSamplingEnabled = value2;
        this.getAttSourceMap().put("statistic-sampling-enabled", ConfigSource.runtime());
    }

    @Override
    public boolean isStatisticSamplingEnabledModifiable() {
        return true;
    }

    @Override
    public void setStatisticSampleRate(int value2) {
        this.checkStatisticSampleRate(value2);
        if (value2 < 1000) {
            this.ds.getLogWriter().info("Setting statistic-sample-rate to 1000 instead of the requested " + value2 + " because VSD does not work with sub-second sampling.");
            value2 = 1000;
        }
        this.statisticSampleRate = value2;
    }

    @Override
    public boolean isStatisticSampleRateModifiable() {
        return true;
    }

    @Override
    public void setStatisticArchiveFile(File value2) {
        this.checkStatisticArchiveFile(value2);
        if (value2 == null) {
            value2 = new File("");
        }
        try {
            this.ds.getStatSampler().changeArchive(value2);
        }
        catch (GemFireIOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.statisticArchiveFile = value2;
        this.getAttSourceMap().put("statistic-archive-file", ConfigSource.runtime());
    }

    @Override
    public boolean isStatisticArchiveFileModifiable() {
        return true;
    }

    @Override
    public void setArchiveDiskSpaceLimit(int value2) {
        this.checkArchiveDiskSpaceLimit(value2);
        this.archiveDiskSpaceLimit = value2;
        this.getAttSourceMap().put("archive-disk-space-limit", ConfigSource.runtime());
    }

    @Override
    public boolean isArchiveDiskSpaceLimitModifiable() {
        return true;
    }

    @Override
    public void setArchiveFileSizeLimit(int value2) {
        this.checkArchiveFileSizeLimit(value2);
        this.archiveFileSizeLimit = value2;
        this.getAttSourceMap().put("archive-file-size-limit", ConfigSource.runtime());
    }

    @Override
    public boolean isArchiveFileSizeLimitModifiable() {
        return true;
    }

    @Override
    public void setLogDiskSpaceLimit(int value2) {
        this.checkLogDiskSpaceLimit(value2);
        this.logDiskSpaceLimit = value2;
        this.getAttSourceMap().put("log-disk-space-limit", ConfigSource.runtime());
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    @Override
    public boolean isLogDiskSpaceLimitModifiable() {
        return true;
    }

    @Override
    public void setLogFileSizeLimit(int value2) {
        this.checkLogFileSizeLimit(value2);
        this.logFileSizeLimit = value2;
        this.getAttSourceMap().put("log-file-size-limit", ConfigSource.runtime());
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    @Override
    public boolean isLogFileSizeLimitModifiable() {
        return true;
    }

    public DistributionConfig takeSnapshot() {
        return new DistributionConfigSnapshot(this);
    }
}

