/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ObjIdConcurrentMap;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessorKeeper21 {
    private final ObjIdConcurrentMap<Object> map = new ObjIdConcurrentMap();
    private final boolean useWeakRefs;
    private final AtomicInteger nextKey = new AtomicInteger(1);

    public ProcessorKeeper21() {
        this(true);
    }

    public ProcessorKeeper21(boolean useWeakRefs) {
        this.useWeakRefs = useWeakRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextId() {
        int id = this.nextKey.getAndIncrement();
        if (id <= 0) {
            AtomicInteger atomicInteger = this.nextKey;
            synchronized (atomicInteger) {
                id = this.nextKey.get();
                if (id <= 0) {
                    this.nextKey.set(1);
                }
            }
            id = this.nextKey.getAndIncrement();
        }
        return id;
    }

    public int put(Object processor) {
        int id;
        WeakReference<Object> obj = this.useWeakRefs ? new WeakReference<Object>(processor) : processor;
        while (this.map.putIfAbsent(id = this.getNextId(), obj) != null) {
        }
        Assert.assertTrue(id > 0);
        return id;
    }

    public Object retrieve(int id) {
        Object o = null;
        if (this.useWeakRefs) {
            WeakReference ref = (WeakReference)this.map.get(id);
            if (ref != null && (o = ref.get()) == null) {
                this.map.remove(id, ref);
            }
        } else {
            o = this.map.get(id);
        }
        return o;
    }

    public void remove(int id) {
        this.map.remove(id);
    }
}

